/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.AbsListView;
import android.widget.OverScroller;
import android.widget.ScrollView;
import com.android.internal.R;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.widget.RecyclerView;

public class ResolverDrawerLayout
extends ViewGroup {
    private static final String TAG = "ResolverDrawerLayout";
    private MetricsLogger mMetricsLogger;
    private int mMaxWidthResId;
    private int mMaxWidth;
    private int mMaxCollapsedHeight;
    private int mMaxCollapsedHeightSmall;
    private final boolean mIsMaxCollapsedHeightSmallExplicit;
    private boolean mSmallCollapsed;
    private float mCollapseOffset;
    private float mDragRemainder = 0.0f;
    private int mCollapsibleHeight;
    private int mUncollapsibleHeight;
    private int mAlwaysShowHeight;
    private int mCollapsibleHeightReserved;
    private int mTopOffset;
    private boolean mShowAtTop;
    private int mIgnoreOffsetTopLimitViewId = 0;
    private boolean mIsDragging;
    private boolean mOpenOnClick;
    private boolean mOpenOnLayout;
    private boolean mDismissOnScrollerFinished;
    private final int mTouchSlop;
    private final float mMinFlingVelocity;
    private final OverScroller mScroller;
    private final VelocityTracker mVelocityTracker;
    private Drawable mScrollIndicatorDrawable;
    private OnDismissedListener mOnDismissedListener;
    private RunOnDismissedListener mRunOnDismissedListener;
    private OnCollapsedChangedListener mOnCollapsedChangedListener;
    private boolean mDismissLocked;
    private float mInitialTouchX;
    private float mInitialTouchY;
    private float mLastTouchY;
    private int mActivePointerId = -1;
    private final Rect mTempRect = new Rect();
    private AbsListView mNestedListChild;
    private RecyclerView mNestedRecyclerChild;
    private final ViewTreeObserver.OnTouchModeChangeListener mTouchModeChangeListener = new ViewTreeObserver.OnTouchModeChangeListener(){

        @Override
        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode && ResolverDrawerLayout.this.hasFocus() && ResolverDrawerLayout.this.isDescendantClipped(ResolverDrawerLayout.this.getFocusedChild())) {
                ResolverDrawerLayout.this.smoothScrollTo(0, 0.0f);
            }
        }
    };

    public ResolverDrawerLayout(Context context) {
        this(context, null);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ResolverDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ResolverDrawerLayout, defStyleAttr, 0);
        this.mMaxWidthResId = a.getResourceId(0, -1);
        this.mMaxWidth = a.getDimensionPixelSize(0, -1);
        this.mMaxCollapsedHeight = a.getDimensionPixelSize(2, 0);
        this.mMaxCollapsedHeightSmall = a.getDimensionPixelSize(3, this.mMaxCollapsedHeight);
        this.mIsMaxCollapsedHeightSmallExplicit = a.hasValue(3);
        this.mShowAtTop = a.getBoolean(4, false);
        if (a.hasValue(1)) {
            this.mIgnoreOffsetTopLimitViewId = a.getResourceId(1, 0);
        }
        a.recycle();
        this.mScrollIndicatorDrawable = this.mContext.getDrawable(17303849);
        this.mScroller = new OverScroller(context, AnimationUtils.loadInterpolator(context, 17563653));
        this.mVelocityTracker = VelocityTracker.obtain();
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mTouchSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.setImportantForAccessibility(1);
    }

    public void setMaxCollapsedHeight(int heightInPixels) {
        if (heightInPixels == this.mMaxCollapsedHeight) {
            return;
        }
        this.mMaxCollapsedHeight = heightInPixels;
        if (!this.mIsMaxCollapsedHeightSmallExplicit) {
            this.mMaxCollapsedHeightSmall = this.mMaxCollapsedHeight;
        }
        this.requestLayout();
    }

    public void setSmallCollapsed(boolean smallCollapsed) {
        if (this.mSmallCollapsed != smallCollapsed) {
            this.mSmallCollapsed = smallCollapsed;
            this.requestLayout();
        }
    }

    public boolean isSmallCollapsed() {
        return this.mSmallCollapsed;
    }

    public boolean isCollapsed() {
        return this.mCollapseOffset > 0.0f;
    }

    public void setShowAtTop(boolean showOnTop) {
        if (this.mShowAtTop != showOnTop) {
            this.mShowAtTop = showOnTop;
            this.requestLayout();
        }
    }

    public boolean getShowAtTop() {
        return this.mShowAtTop;
    }

    public void setCollapsed(boolean collapsed) {
        if (!this.isLaidOut()) {
            this.mOpenOnLayout = !collapsed;
        } else {
            this.smoothScrollTo(collapsed ? this.mCollapsibleHeight : 0, 0.0f);
        }
    }

    public void setCollapsibleHeightReserved(int heightPixels) {
        int dReserved;
        int oldReserved = this.mCollapsibleHeightReserved;
        this.mCollapsibleHeightReserved = heightPixels;
        if (oldReserved != this.mCollapsibleHeightReserved) {
            this.requestLayout();
        }
        if ((dReserved = this.mCollapsibleHeightReserved - oldReserved) != 0 && this.mIsDragging) {
            this.mLastTouchY -= (float)dReserved;
        }
        int oldCollapsibleHeight = this.mCollapsibleHeight;
        this.mCollapsibleHeight = Math.min(this.mCollapsibleHeight, this.getMaxCollapsedHeight());
        if (this.updateCollapseOffset(oldCollapsibleHeight, !this.isDragging())) {
            return;
        }
        this.invalidate();
    }

    public void setDismissLocked(boolean locked) {
        this.mDismissLocked = locked;
    }

    private boolean isMoving() {
        return this.mIsDragging || !this.mScroller.isFinished();
    }

    private boolean isDragging() {
        return this.mIsDragging || this.getNestedScrollAxes() == 2;
    }

    private boolean updateCollapseOffset(int oldCollapsibleHeight, boolean remainClosed) {
        if (oldCollapsibleHeight == this.mCollapsibleHeight) {
            return false;
        }
        if (this.getShowAtTop()) {
            this.setCollapseOffset(0.0f);
            return false;
        }
        if (this.isLaidOut()) {
            boolean isCollapsedNew;
            boolean isCollapsedOld;
            boolean bl = isCollapsedOld = this.mCollapseOffset != 0.0f;
            if (remainClosed && oldCollapsibleHeight < this.mCollapsibleHeight && this.mCollapseOffset == (float)oldCollapsibleHeight) {
                this.setCollapseOffset(this.mCollapsibleHeight);
            } else {
                this.setCollapseOffset(Math.min(this.mCollapseOffset, (float)this.mCollapsibleHeight));
            }
            boolean bl2 = isCollapsedNew = this.mCollapseOffset != 0.0f;
            if (isCollapsedOld != isCollapsedNew) {
                this.onCollapsedChanged(isCollapsedNew);
            }
        } else {
            this.setCollapseOffset(this.mOpenOnLayout ? 0.0f : (float)this.mCollapsibleHeight);
        }
        return true;
    }

    private void setCollapseOffset(float collapseOffset) {
        if (this.mCollapseOffset != collapseOffset) {
            this.mCollapseOffset = collapseOffset;
            this.requestLayout();
        }
    }

    private int getMaxCollapsedHeight() {
        return (this.isSmallCollapsed() ? this.mMaxCollapsedHeightSmall : this.mMaxCollapsedHeight) + this.mCollapsibleHeightReserved;
    }

    public void setOnDismissedListener(OnDismissedListener listener) {
        this.mOnDismissedListener = listener;
    }

    private boolean isDismissable() {
        return this.mOnDismissedListener != null && !this.mDismissLocked;
    }

    public void setOnCollapsedChangedListener(OnCollapsedChangedListener listener) {
        this.mOnCollapsedChangedListener = listener;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 0) {
            this.mVelocityTracker.clear();
        }
        this.mVelocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialTouchX = x;
                this.mInitialTouchY = this.mLastTouchY = y;
                this.mOpenOnClick = this.isListChildUnderClipped(x, y) && this.mCollapseOffset > 0.0f;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                float dy = y - this.mInitialTouchY;
                if (!(Math.abs(dy) > (float)this.mTouchSlop) || this.findChildUnder(x, y) == null || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsDragging = true;
                this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(this.mLastTouchY + dy, this.mLastTouchY + (float)this.mTouchSlop));
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.resetTouch();
            }
        }
        if (this.mIsDragging) {
            this.abortAnimation();
        }
        return this.mIsDragging || this.mOpenOnClick;
    }

    private boolean isNestedListChildScrolled() {
        return this.mNestedListChild != null && this.mNestedListChild.getChildCount() > 0 && (this.mNestedListChild.getFirstVisiblePosition() > 0 || this.mNestedListChild.getChildAt(0).getTop() < 0);
    }

    private boolean isNestedRecyclerChildScrolled() {
        if (this.mNestedRecyclerChild != null && this.mNestedRecyclerChild.getChildCount() > 0) {
            RecyclerView.ViewHolder vh = this.mNestedRecyclerChild.findViewHolderForAdapterPosition(0);
            return vh == null || vh.itemView.getTop() < 0;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        this.mVelocityTracker.addMovement(ev);
        boolean handled = false;
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialTouchX = x;
                this.mInitialTouchY = this.mLastTouchY = y;
                this.mActivePointerId = ev.getPointerId(0);
                boolean hitView = this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) != null;
                handled = this.isDismissable() || this.mCollapsibleHeight > 0;
                this.mIsDragging = hitView && handled;
                this.abortAnimation();
                break;
            }
            case 2: {
                float dy;
                int index = ev.findPointerIndex(this.mActivePointerId);
                if (index < 0) {
                    Log.e(TAG, "Bad pointer id " + this.mActivePointerId + ", resetting");
                    index = 0;
                    this.mActivePointerId = ev.getPointerId(0);
                    this.mInitialTouchX = ev.getX();
                    this.mInitialTouchY = this.mLastTouchY = ev.getY();
                }
                float x = ev.getX(index);
                float y = ev.getY(index);
                if (!this.mIsDragging && Math.abs(dy = y - this.mInitialTouchY) > (float)this.mTouchSlop && this.findChildUnder(x, y) != null) {
                    this.mIsDragging = true;
                    handled = true;
                    this.mLastTouchY = Math.max(this.mLastTouchY - (float)this.mTouchSlop, Math.min(this.mLastTouchY + dy, this.mLastTouchY + (float)this.mTouchSlop));
                }
                if (this.mIsDragging) {
                    dy = y - this.mLastTouchY;
                    if (dy > 0.0f && this.isNestedListChildScrolled()) {
                        this.mNestedListChild.smoothScrollBy((int)(-dy), 0);
                    } else if (dy > 0.0f && this.isNestedRecyclerChildScrolled()) {
                        this.mNestedRecyclerChild.scrollBy(0, (int)(-dy));
                    } else {
                        this.performDrag(dy);
                    }
                }
                this.mLastTouchY = y;
                break;
            }
            case 5: {
                int pointerIndex = ev.getActionIndex();
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mInitialTouchX = ev.getX(pointerIndex);
                this.mInitialTouchY = this.mLastTouchY = ev.getY(pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: {
                boolean wasDragging = this.mIsDragging;
                this.mIsDragging = false;
                if (!wasDragging && this.findChildUnder(this.mInitialTouchX, this.mInitialTouchY) == null && this.findChildUnder(ev.getX(), ev.getY()) == null && this.isDismissable()) {
                    this.dispatchOnDismissed();
                    this.resetTouch();
                    return true;
                }
                if (this.mOpenOnClick && Math.abs(ev.getX() - this.mInitialTouchX) < (float)this.mTouchSlop && Math.abs(ev.getY() - this.mInitialTouchY) < (float)this.mTouchSlop) {
                    this.smoothScrollTo(0, 0.0f);
                    return true;
                }
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float yvel = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                if (Math.abs(yvel) > this.mMinFlingVelocity) {
                    if (this.getShowAtTop()) {
                        if (this.isDismissable() && yvel < 0.0f) {
                            this.abortAnimation();
                            this.dismiss();
                        } else {
                            this.smoothScrollTo(yvel < 0.0f ? 0 : this.mCollapsibleHeight, yvel);
                        }
                    } else if (this.isDismissable() && yvel > 0.0f && this.mCollapseOffset > (float)this.mCollapsibleHeight) {
                        this.smoothScrollTo(this.mCollapsibleHeight + this.mUncollapsibleHeight, yvel);
                        this.mDismissOnScrollerFinished = true;
                    } else {
                        this.scrollNestedScrollableChildBackToTop();
                        this.smoothScrollTo(yvel < 0.0f ? 0 : this.mCollapsibleHeight, yvel);
                    }
                } else {
                    this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
                }
                this.resetTouch();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
                }
                this.resetTouch();
                return true;
            }
        }
        return handled;
    }

    public void scrollNestedScrollableChildBackToTop() {
        if (this.isNestedListChildScrolled()) {
            this.mNestedListChild.smoothScrollToPosition(0);
        } else if (this.isNestedRecyclerChildScrolled()) {
            this.mNestedRecyclerChild.smoothScrollToPosition(0);
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mInitialTouchX = ev.getX(newPointerIndex);
            this.mInitialTouchY = this.mLastTouchY = ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
        }
    }

    private void resetTouch() {
        this.mActivePointerId = -1;
        this.mIsDragging = false;
        this.mOpenOnClick = false;
        this.mLastTouchY = 0.0f;
        this.mInitialTouchY = 0.0f;
        this.mInitialTouchX = 0.0f;
        this.mVelocityTracker.clear();
    }

    private void dismiss() {
        this.mRunOnDismissedListener = new RunOnDismissedListener();
        this.post(this.mRunOnDismissedListener);
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            boolean keepGoing = !this.mScroller.isFinished();
            this.performDrag((float)this.mScroller.getCurrY() - this.mCollapseOffset);
            if (keepGoing) {
                this.postInvalidateOnAnimation();
            } else if (this.mDismissOnScrollerFinished && this.mOnDismissedListener != null) {
                this.dismiss();
            }
        }
    }

    private void abortAnimation() {
        this.mScroller.abortAnimation();
        this.mRunOnDismissedListener = null;
        this.mDismissOnScrollerFinished = false;
    }

    private float performDrag(float dy) {
        if (this.getShowAtTop()) {
            return 0.0f;
        }
        float newPos = Math.max(0.0f, Math.min(this.mCollapseOffset + dy, (float)(this.mCollapsibleHeight + this.mUncollapsibleHeight)));
        if (newPos != this.mCollapseOffset) {
            boolean isCollapsedNew;
            dy = newPos - this.mCollapseOffset;
            this.mDragRemainder += dy - (float)((int)dy);
            if (this.mDragRemainder >= 1.0f) {
                this.mDragRemainder -= 1.0f;
                dy += 1.0f;
            } else if (this.mDragRemainder <= -1.0f) {
                this.mDragRemainder += 1.0f;
                dy -= 1.0f;
            }
            boolean isIgnoreOffsetLimitSet = false;
            int ignoreOffsetLimit = 0;
            View ignoreOffsetLimitView = this.findIgnoreOffsetLimitView();
            if (ignoreOffsetLimitView != null) {
                LayoutParams lp = (LayoutParams)ignoreOffsetLimitView.getLayoutParams();
                ignoreOffsetLimit = ignoreOffsetLimitView.getBottom() + lp.bottomMargin;
                isIgnoreOffsetLimitSet = true;
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                int targetTop;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.ignoreOffset) {
                    child.offsetTopAndBottom((int)dy);
                    continue;
                }
                if (!isIgnoreOffsetLimitSet) continue;
                int top = child.getTop();
                if (top != (targetTop = Math.max((int)((float)(ignoreOffsetLimit + lp.topMargin) + dy), lp.mFixedTop))) {
                    child.offsetTopAndBottom(targetTop - top);
                }
                ignoreOffsetLimit = child.getBottom() + lp.bottomMargin;
            }
            boolean isCollapsedOld = this.mCollapseOffset != 0.0f;
            this.mCollapseOffset = newPos;
            this.mTopOffset = (int)((float)this.mTopOffset + dy);
            boolean bl = isCollapsedNew = newPos != 0.0f;
            if (isCollapsedOld != isCollapsedNew) {
                this.onCollapsedChanged(isCollapsedNew);
                this.getMetricsLogger().write(new LogMaker(1651).setSubtype(isCollapsedNew ? 1 : 0));
            }
            this.onScrollChanged(0, (int)newPos, 0, (int)(newPos - dy));
            this.postInvalidateOnAnimation();
            return dy;
        }
        return 0.0f;
    }

    private void onCollapsedChanged(boolean isCollapsed) {
        this.notifyViewAccessibilityStateChangedIfNeeded(0);
        if (this.mScrollIndicatorDrawable != null) {
            this.setWillNotDraw(!isCollapsed);
        }
        if (this.mOnCollapsedChangedListener != null) {
            this.mOnCollapsedChangedListener.onCollapsedChanged(isCollapsed);
        }
    }

    void dispatchOnDismissed() {
        if (this.mOnDismissedListener != null) {
            this.mOnDismissedListener.onDismissed();
        }
        if (this.mRunOnDismissedListener != null) {
            this.removeCallbacks(this.mRunOnDismissedListener);
            this.mRunOnDismissedListener = null;
        }
    }

    private void smoothScrollTo(int yOffset, float velocity) {
        this.abortAnimation();
        int sy = (int)this.mCollapseOffset;
        int dy = yOffset - sy;
        if (dy == 0) {
            return;
        }
        int height = this.getHeight();
        int halfHeight = height / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dy) / (float)height);
        float distance = (float)halfHeight + (float)halfHeight * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        if ((velocity = Math.abs(velocity)) > 0.0f) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / velocity));
        } else {
            float pageDelta = (float)Math.abs(dy) / (float)height;
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 300);
        this.mScroller.startScroll(0, sy, 0, dy, duration);
        this.postInvalidateOnAnimation();
    }

    private float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    private View findChildUnder(float x, float y) {
        return ResolverDrawerLayout.findChildUnder(this, x, y);
    }

    private static View findChildUnder(ViewGroup parent, float x, float y) {
        int childCount = parent.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = parent.getChildAt(i);
            if (!ResolverDrawerLayout.isChildUnder(child, x, y)) continue;
            return child;
        }
        return null;
    }

    private View findListChildUnder(float x, float y) {
        View v = this.findChildUnder(x, y);
        while (v != null) {
            x -= v.getX();
            y -= v.getY();
            if (v instanceof AbsListView) {
                return ResolverDrawerLayout.findChildUnder((ViewGroup)v, x, y);
            }
            v = v instanceof ViewGroup ? ResolverDrawerLayout.findChildUnder((ViewGroup)v, x, y) : null;
        }
        return v;
    }

    private boolean isListChildUnderClipped(float x, float y) {
        View listChild = this.findListChildUnder(x, y);
        return listChild != null && this.isDescendantClipped(listChild);
    }

    private boolean isDescendantClipped(View child) {
        View directChild;
        this.mTempRect.set(0, 0, child.getWidth(), child.getHeight());
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        if (child.getParent() == this) {
            directChild = child;
        } else {
            View v = child;
            ViewParent p = child.getParent();
            while (p != this) {
                v = (View)((Object)p);
                p = v.getParent();
            }
            directChild = v;
        }
        int clipEdge = this.getHeight() - this.getPaddingBottom();
        int childCount = this.getChildCount();
        for (int i = this.indexOfChild(directChild) + 1; i < childCount; ++i) {
            View nextChild = this.getChildAt(i);
            if (nextChild.getVisibility() == 8) continue;
            clipEdge = Math.min(clipEdge, nextChild.getTop());
        }
        return this.mTempRect.bottom > clipEdge;
    }

    private static boolean isChildUnder(View child, float x, float y) {
        float left = child.getX();
        float top = child.getY();
        float right = left + (float)child.getWidth();
        float bottom = top + (float)child.getHeight();
        return x >= left && y >= top && x < right && y < bottom;
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (!this.isInTouchMode() && this.isDescendantClipped(focused)) {
            this.smoothScrollTo(0, 0.0f);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnTouchModeChangeListener(this.mTouchModeChangeListener);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnTouchModeChangeListener(this.mTouchModeChangeListener);
        this.abortAnimation();
    }

    @Override
    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        if ((nestedScrollAxes & 2) != 0) {
            if (target instanceof AbsListView) {
                this.mNestedListChild = (AbsListView)target;
            }
            if (target instanceof RecyclerView) {
                this.mNestedRecyclerChild = (RecyclerView)target;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
    }

    @Override
    public void onStopNestedScroll(View child) {
        super.onStopNestedScroll(child);
        if (this.mScroller.isFinished()) {
            this.smoothScrollTo(this.mCollapseOffset < (float)(this.mCollapsibleHeight / 2) ? 0 : this.mCollapsibleHeight, 0.0f);
        }
    }

    @Override
    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        if (dyUnconsumed < 0) {
            this.performDrag(-dyUnconsumed);
        }
    }

    @Override
    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0) {
            consumed[1] = (int)(-this.performDrag(-dy));
        }
    }

    @Override
    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (!this.getShowAtTop() && velocityY > this.mMinFlingVelocity && this.mCollapseOffset != 0.0f) {
            this.smoothScrollTo(0, velocityY);
            return true;
        }
        return false;
    }

    @Override
    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed && Math.abs(velocityY) > this.mMinFlingVelocity) {
            if (this.getShowAtTop()) {
                if (this.isDismissable() && velocityY > 0.0f) {
                    this.abortAnimation();
                    this.dismiss();
                } else {
                    this.smoothScrollTo(velocityY < 0.0f ? this.mCollapsibleHeight : 0, velocityY);
                }
            } else if (this.isDismissable() && velocityY < 0.0f && this.mCollapseOffset > (float)this.mCollapsibleHeight) {
                this.smoothScrollTo(this.mCollapsibleHeight + this.mUncollapsibleHeight, velocityY);
                this.mDismissOnScrollerFinished = true;
            } else {
                this.smoothScrollTo(velocityY > 0.0f ? 0 : this.mCollapsibleHeight, velocityY);
            }
            return true;
        }
        return false;
    }

    private boolean performAccessibilityActionCommon(int action) {
        switch (action) {
            case 4096: 
            case 262144: 
            case 16908346: {
                if (this.mCollapseOffset == 0.0f) break;
                this.smoothScrollTo(0, 0.0f);
                return true;
            }
            case 524288: {
                if (!(this.mCollapseOffset < (float)this.mCollapsibleHeight)) break;
                this.smoothScrollTo(this.mCollapsibleHeight, 0.0f);
                return true;
            }
            case 0x100000: {
                if (!(this.mCollapseOffset < (float)(this.mCollapsibleHeight + this.mUncollapsibleHeight)) || !this.isDismissable()) break;
                this.smoothScrollTo(this.mCollapsibleHeight + this.mUncollapsibleHeight, 0.0f);
                this.mDismissOnScrollerFinished = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onNestedPrePerformAccessibilityAction(View target, int action, Bundle args) {
        if (super.onNestedPrePerformAccessibilityAction(target, action, args)) {
            return true;
        }
        return this.performAccessibilityActionCommon(action);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return ScrollView.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.isEnabled()) {
            if (this.mCollapseOffset != 0.0f) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_EXPAND);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_DOWN);
                info.setScrollable(true);
            }
            if (this.mCollapseOffset < (float)(this.mCollapsibleHeight + this.mUncollapsibleHeight) && (this.mCollapseOffset < (float)this.mCollapsibleHeight || this.isDismissable())) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_UP);
                info.setScrollable(true);
            }
            if (this.mCollapseOffset < (float)this.mCollapsibleHeight) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_COLLAPSE);
            }
            if (this.mCollapseOffset < (float)(this.mCollapsibleHeight + this.mUncollapsibleHeight) && this.isDismissable()) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_DISMISS);
            }
        }
        info.removeAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS);
    }

    @Override
    public boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        if (action == AccessibilityNodeInfo.AccessibilityAction.ACTION_ACCESSIBILITY_FOCUS.getId()) {
            return false;
        }
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        return this.performAccessibilityActionCommon(action);
    }

    @Override
    public void onDrawForeground(Canvas canvas) {
        if (this.mScrollIndicatorDrawable != null) {
            this.mScrollIndicatorDrawable.draw(canvas);
        }
        super.onDrawForeground(canvas);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int remainingHeight;
        LayoutParams lp;
        View child;
        int i;
        int sourceWidth;
        int widthSize = sourceWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (this.mMaxWidth >= 0) {
            widthSize = Math.min(widthSize, this.mMaxWidth + this.getPaddingLeft() + this.getPaddingRight());
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, 0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec(heightSize, 0x40000000);
        int heightUsed = 0;
        int childCount = this.getChildCount();
        for (i = 0; i < childCount; ++i) {
            child = this.getChildAt(i);
            lp = (LayoutParams)child.getLayoutParams();
            if (!lp.alwaysShow || child.getVisibility() == 8) continue;
            if (lp.maxHeight != -1) {
                remainingHeight = heightSize - heightUsed;
                this.measureChildWithMargins(child, widthSpec, 0, View.MeasureSpec.makeMeasureSpec(lp.maxHeight, Integer.MIN_VALUE), lp.maxHeight > remainingHeight ? lp.maxHeight - remainingHeight : 0);
            } else {
                this.measureChildWithMargins(child, widthSpec, 0, heightSpec, heightUsed);
            }
            heightUsed += child.getMeasuredHeight();
        }
        this.mAlwaysShowHeight = heightUsed;
        for (i = 0; i < childCount; ++i) {
            child = this.getChildAt(i);
            lp = (LayoutParams)child.getLayoutParams();
            if (lp.alwaysShow || child.getVisibility() == 8) continue;
            if (lp.maxHeight != -1) {
                remainingHeight = heightSize - heightUsed;
                this.measureChildWithMargins(child, widthSpec, 0, View.MeasureSpec.makeMeasureSpec(lp.maxHeight, Integer.MIN_VALUE), lp.maxHeight > remainingHeight ? lp.maxHeight - remainingHeight : 0);
            } else {
                this.measureChildWithMargins(child, widthSpec, 0, heightSpec, heightUsed);
            }
            heightUsed += child.getMeasuredHeight();
        }
        int oldCollapsibleHeight = this.mCollapsibleHeight;
        this.mCollapsibleHeight = Math.max(0, heightUsed - this.mAlwaysShowHeight - this.getMaxCollapsedHeight());
        this.mUncollapsibleHeight = heightUsed - this.mCollapsibleHeight;
        this.updateCollapseOffset(oldCollapsibleHeight, !this.isDragging());
        this.mTopOffset = this.getShowAtTop() ? 0 : Math.max(0, heightSize - heightUsed) + (int)this.mCollapseOffset;
        this.setMeasuredDimension(sourceWidth, heightSize);
    }

    public int getAlwaysShowHeight() {
        return this.mAlwaysShowHeight;
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mMaxWidthResId > 0) {
            this.mMaxWidth = this.getResources().getDimensionPixelSize(this.mMaxWidthResId);
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int top;
        int width = this.getWidth();
        View indicatorHost = null;
        int ypos = this.mTopOffset;
        int leftEdge = this.getPaddingLeft();
        int rightEdge = width - this.getPaddingRight();
        int widthAvailable = rightEdge - leftEdge;
        boolean isIgnoreOffsetLimitSet = false;
        int ignoreOffsetLimit = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.hasNestedScrollIndicator) {
                indicatorHost = child;
            }
            if (child.getVisibility() == 8) continue;
            if (this.mIgnoreOffsetTopLimitViewId != 0 && !isIgnoreOffsetLimitSet && this.mIgnoreOffsetTopLimitViewId == child.getId()) {
                ignoreOffsetLimit = child.getBottom() + lp.bottomMargin;
                isIgnoreOffsetLimitSet = true;
            }
            top = ypos + lp.topMargin;
            if (lp.ignoreOffset) {
                if (!this.isDragging()) {
                    lp.mFixedTop = (int)((float)top - this.mCollapseOffset);
                }
                if (isIgnoreOffsetLimitSet) {
                    top = Math.max(ignoreOffsetLimit + lp.topMargin, (int)((float)top - this.mCollapseOffset));
                    ignoreOffsetLimit = top + child.getMeasuredHeight() + lp.bottomMargin;
                } else {
                    top = (int)((float)top - this.mCollapseOffset);
                }
            }
            int bottom = top + child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            int left = leftEdge + (widthAvailable - childWidth) / 2;
            int right = left + childWidth;
            child.layout(left, top, right, bottom);
            ypos = bottom + lp.bottomMargin;
        }
        if (this.mScrollIndicatorDrawable != null) {
            if (indicatorHost != null) {
                int left = indicatorHost.getLeft();
                int right = indicatorHost.getRight();
                int bottom = indicatorHost.getTop();
                top = bottom - this.mScrollIndicatorDrawable.getIntrinsicHeight();
                this.mScrollIndicatorDrawable.setBounds(left, top, right, bottom);
                this.setWillNotDraw(!this.isCollapsed());
            } else {
                this.mScrollIndicatorDrawable = null;
                this.setWillNotDraw(true);
            }
        }
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.open = this.mCollapsibleHeight > 0 && this.mCollapseOffset == 0.0f;
        ss.mCollapsibleHeightReserved = this.mCollapsibleHeightReserved;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mOpenOnLayout = ss.open;
        this.mCollapsibleHeightReserved = ss.mCollapsibleHeightReserved;
    }

    private View findIgnoreOffsetLimitView() {
        if (this.mIgnoreOffsetTopLimitViewId == 0) {
            return null;
        }
        Object v = this.findViewById(this.mIgnoreOffsetTopLimitViewId);
        if (v != null && v != this && ((View)v).getParent() == this && ((View)v).getVisibility() != 8) {
            return v;
        }
        return null;
    }

    private MetricsLogger getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    public static interface OnDismissedListener {
        public void onDismissed();
    }

    public static interface OnCollapsedChangedListener {
        public void onCollapsedChanged(boolean var1);
    }

    private class RunOnDismissedListener
    implements Runnable {
        private RunOnDismissedListener() {
        }

        @Override
        public void run() {
            ResolverDrawerLayout.this.dispatchOnDismissed();
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean alwaysShow;
        public boolean ignoreOffset;
        public boolean hasNestedScrollIndicator;
        public int maxHeight;
        int mFixedTop;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ResolverDrawerLayout_LayoutParams);
            this.alwaysShow = a.getBoolean(1, false);
            this.ignoreOffset = a.getBoolean(3, false);
            this.hasNestedScrollIndicator = a.getBoolean(2, false);
            this.maxHeight = a.getDimensionPixelSize(4, -1);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.alwaysShow = source.alwaysShow;
            this.ignoreOffset = source.ignoreOffset;
            this.hasNestedScrollIndicator = source.hasNestedScrollIndicator;
            this.maxHeight = source.maxHeight;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean open;
        private int mCollapsibleHeightReserved;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.open = in.readInt() != 0;
            this.mCollapsibleHeightReserved = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.open ? 1 : 0);
            out.writeInt(this.mCollapsibleHeightReserved);
        }
    }
}

