/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.res.Resources;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.BaseInterpolator;
import android.view.animation.PathInterpolator;
import android.widget.flags.Flags;

public class ViewGroupFader {
    private static final float SCALE_LOWER_BOUND = 0.7f;
    private float mScaleLowerBound = 0.7f;
    private static final float ALPHA_LOWER_BOUND = 0.5f;
    private float mAlphaLowerBound = 0.5f;
    private static final float CHAINED_BOUNDS_TOP_FRACTION = 0.6f;
    private static final float CHAINED_BOUNDS_BOTTOM_FRACTION = 0.2f;
    private static final float CHAINED_LOWER_REGION_FRACTION = 0.35f;
    private static final float CHAINED_UPPER_REGION_FRACTION = 0.55f;
    private float mChainedBoundsTop = 0.6f;
    private float mChainedBoundsBottom = 0.2f;
    private float mChainedLowerRegion = 0.35f;
    private float mChainedUpperRegion = 0.55f;
    protected final ViewGroup mParent;
    private final Rect mContainerBounds = new Rect();
    private final Rect mOffsetViewBounds = new Rect();
    private final AnimationCallback mCallback;
    private final ChildViewBoundsProvider mChildViewBoundsProvider;
    private ContainerBoundsProvider mContainerBoundsProvider;
    private float mTopBoundPixels;
    private float mBottomBoundPixels;
    private BaseInterpolator mTopInterpolator = new PathInterpolator(0.3f, 0.0f, 0.7f, 1.0f);
    private BaseInterpolator mBottomInterpolator = new PathInterpolator(0.3f, 0.0f, 0.7f, 1.0f);

    public ViewGroupFader(ViewGroup parent, AnimationCallback callback, ChildViewBoundsProvider childViewBoundsProvider) {
        this.mParent = parent;
        this.mCallback = callback;
        this.mChildViewBoundsProvider = childViewBoundsProvider;
        this.mContainerBoundsProvider = new ScreenContainerBoundsProvider();
    }

    AnimationCallback getAnimationCallback() {
        return this.mCallback;
    }

    void setScaleLowerBound(float scale) {
        this.mScaleLowerBound = scale;
    }

    void setAlphaLowerBound(float alpha) {
        this.mAlphaLowerBound = alpha;
    }

    void setTopInterpolator(BaseInterpolator interpolator2) {
        this.mTopInterpolator = interpolator2;
    }

    void setBottomInterpolator(BaseInterpolator interpolator2) {
        this.mBottomInterpolator = interpolator2;
    }

    void setContainerBoundsProvider(ContainerBoundsProvider boundsProvider) {
        this.mContainerBoundsProvider = boundsProvider;
    }

    public void updateFade() {
        this.mContainerBoundsProvider.provideBounds(this.mParent, this.mContainerBounds);
        this.mTopBoundPixels = (float)this.mContainerBounds.height() * this.mChainedBoundsTop;
        this.mBottomBoundPixels = (float)this.mContainerBounds.height() * this.mChainedBoundsBottom;
        this.updateListElementFades(this.mParent, true);
    }

    public void updateListElementFades(ViewGroup parent, boolean shouldFade) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            if (Flags.enableFadingViewGroup() && Resources.getSystem().getBoolean(17891734) && child instanceof ViewGroup) {
                this.updateListElementFades((ViewGroup)child, true);
            }
            if (!shouldFade) continue;
            this.fadeElement(parent, child);
        }
    }

    private void fadeElement(ViewGroup parent, View child) {
        this.mChildViewBoundsProvider.provideBounds(parent, child, this.mOffsetViewBounds);
        this.setViewPropertiesByPosition(child, this.mOffsetViewBounds, this.mTopBoundPixels, this.mBottomBoundPixels);
    }

    private void setViewPropertiesByPosition(View view, Rect bounds, float topBoundPixels, float bottomBoundPixels) {
        float fadeOutRegionFraction = (float)view.getHeight() < topBoundPixels && (float)view.getHeight() > bottomBoundPixels ? ViewGroupFader.lerp(this.mChainedLowerRegion, this.mChainedUpperRegion, ((float)view.getHeight() - bottomBoundPixels) / (topBoundPixels - bottomBoundPixels)) : ((float)view.getHeight() < bottomBoundPixels ? this.mChainedLowerRegion : this.mChainedUpperRegion);
        int fadeOutRegionHeight = (int)((float)this.mContainerBounds.height() * fadeOutRegionFraction);
        int topFadeBoundary = fadeOutRegionHeight + this.mContainerBounds.top;
        int bottomFadeBoundary = this.mContainerBounds.bottom - fadeOutRegionHeight;
        boolean wasFullSize = view.getScaleX() == 1.0f;
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        view.setPivotX((float)view.getWidth() * 0.5f);
        if (bounds.top > bottomFadeBoundary && this.mCallback.shouldFadeFromBottom(view)) {
            view.setPivotY(-lp.topMargin);
            this.scaleAndFadeByRelativeOffsetFraction(view, this.mBottomInterpolator.getInterpolation((float)(this.mContainerBounds.bottom - bounds.top) / (float)fadeOutRegionHeight));
        } else if (bounds.bottom < topFadeBoundary && this.mCallback.shouldFadeFromTop(view)) {
            view.setPivotY((float)view.getMeasuredHeight() + (float)lp.bottomMargin);
            this.scaleAndFadeByRelativeOffsetFraction(view, this.mTopInterpolator.getInterpolation((float)(bounds.bottom - this.mContainerBounds.top) / (float)fadeOutRegionHeight));
        } else {
            if (!wasFullSize) {
                this.mCallback.viewHasBecomeFullSize(view);
            }
            this.setDefaultSizeAndAlphaForView(view);
        }
    }

    private void scaleAndFadeByRelativeOffsetFraction(View view, float offsetFraction) {
        float alpha = ViewGroupFader.lerp(this.mAlphaLowerBound, 1.0f, offsetFraction);
        view.setTransitionAlpha(alpha);
        float scale = ViewGroupFader.lerp(this.mScaleLowerBound, 1.0f, offsetFraction);
        view.setScaleX(scale);
        view.setScaleY(scale);
    }

    private void setDefaultSizeAndAlphaForView(View view) {
        view.setTransitionAlpha(1.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
    }

    private static float lerp(float min, float max, float fraction2) {
        return min + (max - min) * fraction2;
    }

    public static interface AnimationCallback {
        public boolean shouldFadeFromTop(View var1);

        public boolean shouldFadeFromBottom(View var1);

        public void viewHasBecomeFullSize(View var1);
    }

    public static interface ChildViewBoundsProvider {
        public void provideBounds(ViewGroup var1, View var2, Rect var3);
    }

    static class ScreenContainerBoundsProvider
    implements ContainerBoundsProvider {
        ScreenContainerBoundsProvider() {
        }

        @Override
        public void provideBounds(ViewGroup parent, Rect bounds) {
            bounds.set(0, 0, parent.getResources().getDisplayMetrics().widthPixels, parent.getResources().getDisplayMetrics().heightPixels);
        }
    }

    static interface ContainerBoundsProvider {
        public void provideBounds(ViewGroup var1, Rect var2);
    }

    static class GlobalVisibleViewBoundsProvider
    implements ChildViewBoundsProvider {
        GlobalVisibleViewBoundsProvider() {
        }

        @Override
        public void provideBounds(ViewGroup parent, View child, Rect bounds) {
            child.getGlobalVisibleRect(bounds);
        }
    }

    static class DefaultViewBoundsProvider
    implements ChildViewBoundsProvider {
        DefaultViewBoundsProvider() {
        }

        @Override
        public void provideBounds(ViewGroup parent, View child, Rect bounds) {
            child.getDrawingRect(bounds);
            bounds.offset(0, (int)child.getTranslationY());
            parent.offsetDescendantRectToMyCoords(child, bounds);
            Rect parentGlobalVisibleBounds = new Rect();
            parent.getGlobalVisibleRect(parentGlobalVisibleBounds);
            bounds.offset(parentGlobalVisibleBounds.left, parentGlobalVisibleBounds.top);
        }
    }

    static class ParentContainerBoundsProvider
    implements ContainerBoundsProvider {
        ParentContainerBoundsProvider() {
        }

        @Override
        public void provideBounds(ViewGroup parent, Rect bounds) {
            parent.getGlobalVisibleRect(bounds);
        }
    }
}

