/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class ClipPath
extends PaintOperation
implements Serializable {
    private static final int OP_CODE = 38;
    private static final String CLASS_NAME = "ClipPath";
    int mId;
    int mRegionOp;
    public static final int PATH_CLIP_REPLACE = 0;
    public static final int PATH_CLIP_DIFFERENCE = 1;
    public static final int PATH_CLIP_INTERSECT = 2;
    public static final int PATH_CLIP_UNION = 3;
    public static final int PATH_CLIP_XOR = 4;
    public static final int PATH_CLIP_REVERSE_DIFFERENCE = 5;
    public static final int PATH_CLIP_UNDEFINED = 6;
    public static final int REPLACE = 0;
    public static final int DIFFERENCE = 1;
    public static final int INTERSECT = 2;
    public static final int UNION = 3;
    public static final int XOR = 4;
    public static final int REVERSE_DIFFERENCE = 5;
    public static final int UNDEFINED = 6;

    public ClipPath(int pathId, int regionOp) {
        this.mId = pathId;
        this.mRegionOp = regionOp;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ClipPath.apply(buffer, this.mId);
    }

    @NonNull
    public String toString() {
        return "ClipPath " + this.mId + ";";
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int pack = buffer.readInt();
        int id2 = pack & 0xFFFFF;
        int regionOp = pack >> 24;
        ClipPath op = new ClipPath(id2, regionOp);
        operations.add(op);
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 38;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2) {
        buffer.start(38);
        buffer.writeInt(id2);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 38, CLASS_NAME).description("Intersect the current clip with the path").field(0, "id", "id of the path");
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.clipPath(this.mId, this.mRegionOp);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("regionOp", this.regionOpToString());
    }

    String regionOpToString() {
        switch (this.mRegionOp) {
            case 0: {
                return "REPLACE";
            }
            case 1: {
                return "DIFFERENCE";
            }
            case 2: {
                return "INTERSECT";
            }
            case 4: {
                return "XOR";
            }
            case 5: {
                return "REVERSE_DIFFERENCE";
            }
        }
        return "UNDEFINED";
    }
}

