/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.SerializableToString;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class ComponentValue
extends Operation
implements SerializableToString,
Serializable {
    private static final int OP_CODE = 150;
    private static final String CLASS_NAME = "ComponentValue";
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    private int mType = 0;
    private int mComponentID = -1;
    private int mValueId = -1;

    public static int id() {
        return 150;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    @NonNull
    public String toString() {
        return "ComponentValue(" + this.mType + ", " + this.mComponentID + ", " + this.mValueId + ")";
    }

    public int getType() {
        return this.mType;
    }

    public int getComponentId() {
        return this.mComponentID;
    }

    public int getValueId() {
        return this.mValueId;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ComponentValue.apply(buffer, this.mType, this.mComponentID, this.mValueId);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int type = buffer.readInt();
        int componentId = buffer.readInt();
        int valueId = buffer.readInt();
        ComponentValue op = new ComponentValue(type, componentId, valueId);
        operations.add(op);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 150, CLASS_NAME).description("Encode a component-related value (eg its width, height etc.)").field(0, "TYPE", "The type of value, either WIDTH(0) or HEIGHT(1)").field(0, "COMPONENT_ID", "The component id to reference").field(0, "VALUE_ID", "The id of the RemoteFloat representing the described component value, which can be used in expressions");
    }

    public ComponentValue(int type, int componentId, int valueId) {
        this.mType = type;
        this.mComponentID = componentId;
        this.mValueId = valueId;
    }

    public static void apply(@NonNull WireBuffer buffer, int type, int componentId, int valueId) {
        buffer.start(150);
        buffer.writeInt(type);
        buffer.writeInt(componentId);
        buffer.writeInt(valueId);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return null;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        String type = "WIDTH";
        if (this.mType == 1) {
            type = "HEIGHT";
        }
        serializer.append(indent, "ComponentValue value " + this.mValueId + " set to " + type + " of Component " + this.mComponentID);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("valueId", this.mValueId).add("componentValueType", this.typeToString(this.mType)).add("componentId", this.mComponentID);
    }

    private String typeToString(int type) {
        if (type == 0) {
            return "WIDTH";
        }
        if (type == 1) {
            return "HEIGHT";
        }
        return "INVALID_TYPE";
    }
}

