/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.Container;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConditionalOperations
extends PaintOperation
implements Container,
VariableSupport,
Serializable {
    private static final String CLASS_NAME = "ConditionalOperations";
    private static final int OP_CODE = 178;
    @NonNull
    public ArrayList<Operation> mList = new ArrayList();
    int mIndexVariableId;
    byte mType;
    float mVarA;
    float mVarB;
    float mVarAOut;
    float mVarBOut;
    public static final byte TYPE_EQ = 0;
    public static final byte TYPE_NEQ = 1;
    public static final byte TYPE_LT = 2;
    public static final byte TYPE_LTE = 3;
    public static final byte TYPE_GT = 4;
    public static final byte TYPE_GTE = 5;
    private static final String[] TYPE_STR = new String[]{"EQ", "NEQ", "LT", "LTE", "GT", "GTE"};

    @Override
    public void registerListening(RemoteContext context) {
        if (Float.isNaN(this.mVarA)) {
            context.listensTo(Utils.idFromNan(this.mVarA), this);
        }
        if (Float.isNaN(this.mVarB)) {
            context.listensTo(Utils.idFromNan(this.mVarB), this);
        }
    }

    @Override
    public void updateVariables(RemoteContext context) {
        this.mVarAOut = Float.isNaN(this.mVarA) ? context.getFloat(Utils.idFromNan(this.mVarA)) : this.mVarA;
        this.mVarBOut = Float.isNaN(this.mVarB) ? context.getFloat(Utils.idFromNan(this.mVarB)) : this.mVarB;
        for (Operation op : this.mList) {
            if (!(op instanceof VariableSupport) || !op.isDirty()) continue;
            ((VariableSupport)((Object)op)).updateVariables(context);
        }
    }

    public ConditionalOperations(byte type, float a, float b) {
        this.mType = type;
        this.mVarAOut = this.mVarA = a;
        this.mVarBOut = this.mVarB = b;
    }

    @Override
    @NonNull
    public ArrayList<Operation> getList() {
        return this.mList;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ConditionalOperations.apply(buffer, this.mType, this.mVarA, this.mVarB);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("ConditionalOperations " + TYPE_STR[this.mType] + "(" + Utils.idFromNan(this.mVarA) + "," + Utils.idFromNan(this.mVarB) + ")\n");
        for (Operation operation : this.mList) {
            builder.append("  ");
            builder.append(operation);
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return (indent != null ? indent : "") + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        RemoteContext remoteContext = context.getContext();
        boolean run = false;
        switch (this.mType) {
            case 0: {
                run = this.mVarAOut == this.mVarBOut;
                break;
            }
            case 1: {
                run = this.mVarAOut != this.mVarBOut;
                break;
            }
            case 2: {
                run = this.mVarAOut < this.mVarBOut;
                break;
            }
            case 3: {
                run = this.mVarAOut <= this.mVarBOut;
                break;
            }
            case 4: {
                run = this.mVarAOut > this.mVarBOut;
                break;
            }
            case 5: {
                boolean bl = run = this.mVarAOut >= this.mVarBOut;
            }
        }
        if (run) {
            for (Operation op : this.mList) {
                remoteContext.incrementOpCount();
                op.apply(context.getContext());
            }
        }
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void apply(@NonNull WireBuffer buffer, byte type, float a, float b) {
        buffer.start(178);
        buffer.writeByte(type);
        buffer.writeFloat(a);
        buffer.writeFloat(b);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        byte type = (byte)buffer.readByte();
        float a = buffer.readFloat();
        float b = buffer.readFloat();
        operations.add(new ConditionalOperations(type, a, b));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Operations", 178, ConditionalOperations.name()).description("Run if the condition is true").field(6, "type", "type of comparison").field(1, "a", "first value").field(1, "b", "second value");
    }

    public int estimateIterations() {
        return 1;
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("type", this.mType).add("varA", this.mVarA, this.mVarAOut).add("VarB", this.mVarB, this.mVarBOut).add("list", this.mList);
    }
}

