/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.DrawBase4;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class DrawRect
extends DrawBase4 {
    private static final int OP_CODE = 42;
    private static final String CLASS_NAME = "DrawRect";

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        DrawBase4.Maker m = DrawRect::new;
        DrawRect.read(m, buffer, operations);
    }

    public static int id() {
        return 42;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Canvas Operations", 42, CLASS_NAME).description("Draw the specified rectangle").field(1, "left", "The left side of the rectangle").field(1, "top", "The top of the rectangle").field(1, "right", "The right side of the rectangle").field(1, "bottom", "The bottom of the rectangle");
    }

    @Override
    protected void write(@NonNull WireBuffer buffer, float v1, float v2, float v3, float v4) {
        DrawRect.apply(buffer, v1, v2, v3, v4);
    }

    public DrawRect(float left, float top, float right, float bottom) {
        super(left, top, right, bottom);
        this.mName = CLASS_NAME;
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        context.drawRect(this.mX1, this.mY1, this.mX2, this.mY2);
    }

    public static void apply(@NonNull WireBuffer buffer, float x1, float y1, float x2, float y2) {
        DrawRect.write(buffer, 42, x1, y1, x2, y2);
    }

    @Override
    public void serialize(MapSerializer serializer) {
        this.serialize(serializer, "left", "top", "right", "bottom").addType(CLASS_NAME);
    }
}

