/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteComposeOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.semantics.ScrollableComponent;
import java.util.List;

public class RootContentBehavior
extends Operation
implements RemoteComposeOperation,
ScrollableComponent {
    private static final int OP_CODE = 65;
    private static final String CLASS_NAME = "RootContentBehavior";
    int mScroll = 0;
    int mSizing = 0;
    int mAlignment = 34;
    int mMode = 0;
    protected static final String TAG = "RootContentBehavior";
    public static final int NONE = 0;
    public static final int SCROLL_HORIZONTAL = 1;
    public static final int SCROLL_VERTICAL = 2;
    public static final int SIZING_LAYOUT = 1;
    public static final int SIZING_SCALE = 2;
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_VERTICAL_CENTER = 2;
    public static final int ALIGNMENT_BOTTOM = 4;
    public static final int ALIGNMENT_START = 16;
    public static final int ALIGNMENT_HORIZONTAL_CENTER = 32;
    public static final int ALIGNMENT_END = 64;
    public static final int ALIGNMENT_CENTER = 34;
    public static final int LAYOUT_HORIZONTAL_MATCH_PARENT = 1;
    public static final int LAYOUT_HORIZONTAL_WRAP_CONTENT = 2;
    public static final int LAYOUT_HORIZONTAL_FIXED = 4;
    public static final int LAYOUT_VERTICAL_MATCH_PARENT = 8;
    public static final int LAYOUT_VERTICAL_WRAP_CONTENT = 16;
    public static final int LAYOUT_VERTICAL_FIXED = 32;
    public static final int LAYOUT_MATCH_PARENT = 9;
    public static final int LAYOUT_WRAP_CONTENT = 18;
    public static final int SCALE_INSIDE = 1;
    public static final int SCALE_FILL_WIDTH = 2;
    public static final int SCALE_FILL_HEIGHT = 3;
    public static final int SCALE_FIT = 4;
    public static final int SCALE_CROP = 5;
    public static final int SCALE_FILL_BOUNDS = 6;

    public RootContentBehavior(int scroll, int alignment, int sizing, int mode) {
        switch (scroll) {
            case 0: 
            case 1: 
            case 2: {
                this.mScroll = scroll;
                break;
            }
            default: {
                System.out.println("RootContentBehaviorincorrect scroll value " + scroll);
            }
        }
        if (alignment == 34) {
            this.mAlignment = alignment;
        } else {
            boolean validVerticalAlignment;
            int horizontalContentAlignment = alignment & 0xF0;
            int verticalContentAlignment = alignment & 0xF;
            boolean validHorizontalAlignment = horizontalContentAlignment == 16 || horizontalContentAlignment == 32 || horizontalContentAlignment == 64;
            boolean bl = validVerticalAlignment = verticalContentAlignment == 1 || verticalContentAlignment == 2 || verticalContentAlignment == 4;
            if (validHorizontalAlignment && validVerticalAlignment) {
                this.mAlignment = alignment;
            } else {
                System.out.println("RootContentBehaviorincorrect alignment  h: " + horizontalContentAlignment + " v: " + verticalContentAlignment);
            }
        }
        switch (sizing) {
            case 1: {
                System.out.println("RootContentBehaviorsizing_layout is not yet supported");
                break;
            }
            case 2: {
                this.mSizing = sizing;
                break;
            }
            default: {
                System.out.println("RootContentBehaviorincorrect sizing value " + sizing);
            }
        }
        if (this.mSizing == 1) {
            if (mode != 0) {
                System.out.println("RootContentBehaviormode for sizing layout is not yet supported");
            }
        } else if (this.mSizing == 2) {
            switch (mode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.mMode = mode;
                    break;
                }
                default: {
                    System.out.println("RootContentBehaviorincorrect mode for scale sizing, mode: " + mode);
                }
            }
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        RootContentBehavior.apply(buffer, this.mScroll, this.mAlignment, this.mSizing, this.mMode);
    }

    @NonNull
    public String toString() {
        return "ROOT_CONTENT_BEHAVIOR scroll: " + this.mScroll + " sizing: " + this.mSizing + " mode: " + this.mMode;
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.setRootContentBehavior(this.mScroll, this.mAlignment, this.mSizing, this.mMode);
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return this.toString();
    }

    @NonNull
    public static String name() {
        return "RootContentBehavior";
    }

    public static int id() {
        return 65;
    }

    public static void apply(@NonNull WireBuffer buffer, int scroll, int alignment, int sizing, int mode) {
        buffer.start(65);
        buffer.writeInt(scroll);
        buffer.writeInt(alignment);
        buffer.writeInt(sizing);
        buffer.writeInt(mode);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int scroll = buffer.readInt();
        int alignment = buffer.readInt();
        int sizing = buffer.readInt();
        int mode = buffer.readInt();
        RootContentBehavior rootContentBehavior = new RootContentBehavior(scroll, alignment, sizing, mode);
        operations.add(rootContentBehavior);
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Protocol Operations", 65, "RootContentBehavior").description("Describes the behaviour of the root").field(0, "scroll", "scroll").possibleValues("SCROLL_HORIZONTAL", 1).possibleValues("SCROLL_VERTICAL", 2).field(0, "alignment", "alignment").possibleValues("ALIGNMENT_TOP", 1).possibleValues("ALIGNMENT_VERTICAL_CENTER", 2).possibleValues("ALIGNMENT_BOTTOM", 4).possibleValues("ALIGNMENT_START", 16).possibleValues("ALIGNMENT_START", 16).possibleValues("ALIGNMENT_END", 64).field(0, "sizing", "sizing").possibleValues("SCALE_INSIDE", 1).possibleValues("SCALE_FIT", 4).possibleValues("SCALE_FILL_WIDTH", 2).possibleValues("SCALE_FILL_HEIGHT", 3).possibleValues("SCALE_CROP", 5).possibleValues("SCALE_FILL_BOUNDS", 6).field(0, "mode", "mode").possibleValues("LAYOUT_HORIZONTAL_MATCH_PARENT", 1).possibleValues("LAYOUT_HORIZONTAL_WRAP_CONTENT", 2).possibleValues("LAYOUT_HORIZONTAL_FIXED", 4).possibleValues("LAYOUT_VERTICAL_MATCH_PARENT", 8).possibleValues("LAYOUT_VERTICAL_WRAP_CONTENT", 16).possibleValues("LAYOUT_VERTICAL_FIXED", 32).possibleValues("LAYOUT_MATCH_PARENT", 9).possibleValues("LAYOUT_WRAP_CONTENT", 18);
    }

    @Override
    public boolean isInterestingForSemantics() {
        return this.mScroll != 0;
    }

    @Override
    public boolean supportsScrollByOffset() {
        return this.mScroll != 0;
    }

    @Override
    public int scrollByOffset(RemoteContext context, int offset) {
        return offset;
    }

    @Override
    public int scrollDirection() {
        return this.mScroll;
    }
}

