/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import java.util.List;

public class TextLength
extends Operation {
    private static final int OP_CODE = 156;
    private static final String CLASS_NAME = "TextLength";
    public int mLengthId;
    public int mTextId;

    public TextLength(int lengthId, int textId) {
        this.mLengthId = lengthId;
        this.mTextId = textId;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextLength.apply(buffer, this.mLengthId, this.mTextId);
    }

    @NonNull
    public String toString() {
        return "TextLength[" + this.mLengthId + "] = " + this.mTextId;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 156;
    }

    public static void apply(@NonNull WireBuffer buffer, int lengthId, int textId) {
        buffer.start(156);
        buffer.writeInt(lengthId);
        buffer.writeInt(textId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int lengthId = buffer.readInt();
        int textId = buffer.readInt();
        operations.add(new TextLength(lengthId, textId));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 156, CLASS_NAME).description("get the length of the text and store in float table").field(0, "id", "id of float length").field(0, "value", "index of text");
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
        context.loadFloat(this.mLengthId, context.getText(this.mTextId).length());
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }
}

