/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.List;

public class TextMeasure
extends PaintOperation {
    private static final int OP_CODE = 155;
    private static final String CLASS_NAME = "TextMeasure";
    public int mId;
    public int mTextId;
    public int mType;
    public static final int MEASURE_WIDTH = 0;
    public static final int MEASURE_HEIGHT = 1;
    public static final int MEASURE_LEFT = 2;
    public static final int MEASURE_RIGHT = 3;
    public static final int MEASURE_TOP = 4;
    public static final int MEASURE_BOTTOM = 5;
    public static final int MEASURE_MONOSPACE_FLAG = 256;
    public static final int MEASURE_MAX_HEIGHT_FLAG = 512;
    @NonNull
    float[] mBounds = new float[4];

    public TextMeasure(int id2, int textId, int type) {
        this.mId = id2;
        this.mTextId = textId;
        this.mType = type;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        TextMeasure.apply(buffer, this.mId, this.mTextId, this.mType);
    }

    @NonNull
    public String toString() {
        return "FloatConstant[" + this.mId + "] = " + this.mTextId + " " + this.mType;
    }

    @NonNull
    public static String name() {
        return CLASS_NAME;
    }

    public static int id() {
        return 155;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, int textId, int type) {
        buffer.start(155);
        buffer.writeInt(id2);
        buffer.writeInt(textId);
        buffer.writeInt(type);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        int textId = buffer.readInt();
        int type = buffer.readInt();
        operations.add(new TextMeasure(id2, textId, type));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 155, CLASS_NAME).description("Measure text").field(0, "id", "id of float result of the measure").field(0, "textId", "id of text").field(0, "type", "type: measure 0=width,1=height");
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        int val = this.mType & 0xFF;
        int flags = this.mType >> 8;
        context.getTextBounds(this.mTextId, 0, -1, flags, this.mBounds);
        switch (val) {
            case 0: {
                context.getContext().loadFloat(this.mId, this.mBounds[2] - this.mBounds[0]);
                break;
            }
            case 1: {
                context.getContext().loadFloat(this.mId, this.mBounds[3] - this.mBounds[1]);
                break;
            }
            case 2: {
                context.getContext().loadFloat(this.mId, this.mBounds[0]);
                break;
            }
            case 4: {
                context.getContext().loadFloat(this.mId, this.mBounds[1]);
                break;
            }
            case 3: {
                context.getContext().loadFloat(this.mId, this.mBounds[2]);
                break;
            }
            case 5: {
                context.getContext().loadFloat(this.mId, this.mBounds[3]);
            }
        }
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("textId", this.mTextId).add("measureType", this.typeToString());
    }

    private String typeToString() {
        int val = this.mType & 0xFF;
        switch (val) {
            case 0: {
                return "MEASURE_WIDTH";
            }
            case 1: {
                return "MEASURE_HEIGHT";
            }
            case 2: {
                return "MEASURE_LEFT";
            }
            case 4: {
                return "MEASURE_TOP";
            }
            case 3: {
                return "MEASURE_RIGHT";
            }
            case 5: {
                return "MEASURE_BOTTOM";
            }
        }
        return "INVALID_TYPE";
    }
}

