/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.operations.BitmapData;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.LayoutManager;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.operations.paint.PaintBundle;
import com.android.internal.widget.remotecompose.core.operations.utilities.ImageScaling;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;
import java.util.List;

public class ImageLayout
extends LayoutManager
implements VariableSupport {
    private static final boolean DEBUG = false;
    private int mBitmapId = -1;
    private int mScaleType;
    private float mAlpha = 1.0f;
    @NonNull
    ImageScaling mScaling = new ImageScaling();
    @NonNull
    PaintBundle mPaint = new PaintBundle();

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (this.mBitmapId != -1) {
            context.listensTo(this.mBitmapId, this);
        }
    }

    public ImageLayout(@Nullable Component parent, int componentId, int animationId, int bitmapId, float x, float y, float width, float height, int scaleType, float alpha) {
        super(parent, componentId, animationId, x, y, width, height);
        this.mBitmapId = bitmapId;
        this.mScaleType = scaleType & 0xFF;
        this.mAlpha = alpha;
    }

    public ImageLayout(@Nullable Component parent, int componentId, int animationId, int bitmapId, int scaleType, float alpha) {
        this(parent, componentId, animationId, bitmapId, 0.0f, 0.0f, 0.0f, 0.0f, scaleType, alpha);
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        BitmapData bitmapData = (BitmapData)context.getContext().getObject(this.mBitmapId);
        if (bitmapData != null) {
            size.setWidth(bitmapData.getWidth());
            size.setHeight(bitmapData.getHeight());
        }
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        float modifiersWidth = this.computeModifierDefinedWidth(context.getContext());
        float modifiersHeight = this.computeModifierDefinedHeight(context.getContext());
        ComponentMeasure m = measure.get(this);
        m.setW(modifiersWidth);
        m.setH(modifiersHeight);
    }

    @Override
    public void paintingComponent(@NonNull PaintContext context) {
        context.save();
        context.translate(this.mX, this.mY);
        this.mComponentModifiers.paint(context);
        float tx = this.mPaddingLeft;
        float ty = this.mPaddingTop;
        context.translate(tx, ty);
        float w = this.mWidth - this.mPaddingLeft - this.mPaddingRight;
        float h = this.mHeight - this.mPaddingTop - this.mPaddingBottom;
        context.clipRect(0.0f, 0.0f, w, h);
        BitmapData bitmapData = (BitmapData)context.getContext().getObject(this.mBitmapId);
        if (bitmapData != null) {
            this.mScaling.setup(0.0f, 0.0f, bitmapData.getWidth(), bitmapData.getHeight(), 0.0f, 0.0f, w, h, this.mScaleType, 1.0f);
            context.savePaint();
            if (this.mAlpha == 1.0f) {
                context.drawBitmap(this.mBitmapId, 0, 0, bitmapData.getWidth(), bitmapData.getHeight(), (int)this.mScaling.mFinalDstLeft, (int)this.mScaling.mFinalDstTop, (int)this.mScaling.mFinalDstRight, (int)this.mScaling.mFinalDstBottom, -1);
            } else {
                context.savePaint();
                this.mPaint.reset();
                this.mPaint.setColor(0.0f, 0.0f, 0.0f, this.mAlpha);
                context.applyPaint(this.mPaint);
                context.drawBitmap(this.mBitmapId, 0, 0, bitmapData.getWidth(), bitmapData.getHeight(), (int)this.mScaling.mFinalDstLeft, (int)this.mScaling.mFinalDstTop, (int)this.mScaling.mFinalDstRight, (int)this.mScaling.mFinalDstBottom, -1);
                context.restorePaint();
            }
            context.restorePaint();
        }
        context.translate(-tx, -ty);
        context.restore();
    }

    @Override
    @NonNull
    public String toString() {
        return "IMAGE_LAYOUT [" + this.mComponentId + ":" + this.mAnimationId + "] (" + this.mX + ", " + this.mY + " - " + this.mWidth + " x " + this.mHeight + ") " + this.mVisibility;
    }

    @Override
    @NonNull
    protected String getSerializedName() {
        return "IMAGE_LAYOUT";
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, this.getSerializedName() + " [" + this.mComponentId + ":" + this.mAnimationId + "] = [" + this.mX + ", " + this.mY + ", " + this.mWidth + ", " + this.mHeight + "] " + this.mVisibility + " (" + this.mBitmapId + "\")");
    }

    @NonNull
    public static String name() {
        return "ImageLayout";
    }

    public static int id() {
        return 234;
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int bitmapId, int scaleType, float alpha) {
        buffer.start(ImageLayout.id());
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(bitmapId);
        buffer.writeInt(scaleType);
        buffer.writeFloat(alpha);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        int bitmapId = buffer.readInt();
        int scaleType = buffer.readInt();
        float alpha = buffer.readFloat();
        operations.add(new ImageLayout(null, componentId, animationId, bitmapId, scaleType, alpha));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Layout Operations", ImageLayout.id(), ImageLayout.name()).description("Image layout implementation.\n\n").field(0, "COMPONENT_ID", "unique id for this component").field(0, "ANIMATION_ID", "id used to match components, for animation purposes").field(0, "BITMAP_ID", "bitmap id").field(0, "SCALE_TYPE", "scale type").field(1, "ALPHA", "alpha");
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        ImageLayout.apply(buffer, this.mComponentId, this.mAnimationId, this.mBitmapId, this.mScaleType, this.mAlpha);
    }
}

