/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.managers;

import android.annotation.NonNull;
import android.annotation.Nullable;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.PaintContext;
import com.android.internal.widget.remotecompose.core.PaintOperation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.layout.Component;
import com.android.internal.widget.remotecompose.core.operations.layout.LayoutComponent;
import com.android.internal.widget.remotecompose.core.operations.layout.managers.LayoutManager;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.ComponentMeasure;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.MeasurePass;
import com.android.internal.widget.remotecompose.core.operations.layout.measure.Size;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateLayout
extends LayoutManager {
    public int measuredLayoutIndex = 0;
    public int currentLayoutIndex = 0;
    public int previousLayoutIndex = 0;
    private int mIndexId = 0;
    @NonNull
    public Map<Integer, Component[]> statePaintedComponents = new HashMap<Integer, Component[]>();
    public int MAX_CACHE_ELEMENTS = 16;
    @NonNull
    public int[] cacheListElementsId = new int[this.MAX_CACHE_ELEMENTS];
    public boolean inTransition = false;

    public StateLayout(@Nullable Component parent, int componentId, int animationId, float x, float y, float width, float height, int indexId) {
        super(parent, componentId, animationId, x, y, width, height);
        this.mIndexId = indexId;
    }

    @Override
    public void inflate() {
        super.inflate();
        this.hideLayoutsOtherThan(this.currentLayoutIndex);
    }

    public void findAnimatedComponents() {
        for (int i = 0; i < this.mChildrenComponents.size(); ++i) {
            Component cs = (Component)this.mChildrenComponents.get(i);
            if (!(cs instanceof LayoutComponent)) continue;
            LayoutComponent state = (LayoutComponent)cs;
            state.setX(0.0f);
            state.setY(0.0f);
            ArrayList<Component> childrenComponents = state.getChildrenComponents();
            for (int j = 0; j < childrenComponents.size(); ++j) {
                Component child = childrenComponents.get(j);
                if (child.getAnimationId() == -1) continue;
                if (!this.statePaintedComponents.containsKey(child.getAnimationId())) {
                    this.statePaintedComponents.put(child.getAnimationId(), new Component[this.mChildrenComponents.size()]);
                }
                this.statePaintedComponents.get((Object)Integer.valueOf((int)child.getAnimationId()))[i] = child;
            }
        }
        this.collapsePaintedComponents();
    }

    public void collapsePaintedComponents() {
        int numStates = this.mChildrenComponents.size();
        for (Integer id2 : this.statePaintedComponents.keySet()) {
            int i;
            Component[] list = this.statePaintedComponents.get(id2);
            int numComponents = list.length;
            if (numComponents <= 1 || list[0] == null) continue;
            Component c1 = list[0];
            boolean same = true;
            for (i = 1; i < list.length; ++i) {
                Component c2 = list[i];
                if (c2 != null && c1.suitableForTransition(c2)) continue;
                same = false;
                break;
            }
            if (!same) continue;
            for (i = 0; i < numStates; ++i) {
                list[i] = c1;
            }
        }
    }

    @Override
    public void computeSize(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        LayoutManager layout2 = this.getLayout(this.currentLayoutIndex);
        layout2.computeSize(context, minWidth, maxWidth, minHeight, maxHeight, measure);
    }

    @Override
    public void internalLayoutMeasure(@NonNull PaintContext context, @NonNull MeasurePass measure) {
        LayoutManager layout2 = this.getLayout(this.currentLayoutIndex);
        layout2.internalLayoutMeasure(context, measure);
    }

    @Override
    public void computeWrapSize(@NonNull PaintContext context, float maxWidth, float maxHeight, boolean horizontalWrap, boolean verticalWrap, @NonNull MeasurePass measure, @NonNull Size size) {
        LayoutManager layout2 = this.getLayout(this.currentLayoutIndex);
        layout2.computeWrapSize(context, maxWidth, maxHeight, horizontalWrap, verticalWrap, measure, size);
    }

    @Override
    public void onClick(@NonNull RemoteContext context, @NonNull CoreDocument document, float x, float y) {
        if (!this.contains(x, y)) {
            return;
        }
        LayoutManager layout2 = this.getLayout(this.currentLayoutIndex);
        layout2.onClick(context, document, x, y);
    }

    @Override
    public void layout(@NonNull RemoteContext context, @NonNull MeasurePass measure) {
        ComponentMeasure self = measure.get(this);
        super.selfLayout(context, measure);
        LayoutManager layout2 = this.getLayout(this.currentLayoutIndex);
        ComponentMeasure layoutMeasure = measure.get(layout2.getComponentId());
        layoutMeasure.copyFrom(self);
        layout2.layout(context, measure);
        if (this.inTransition && this.previousLayoutIndex != this.currentLayoutIndex) {
            LayoutManager previous = this.getLayout(this.previousLayoutIndex);
            for (Component c : previous.getChildrenComponents()) {
                int id2 = c.getComponentId();
                if (c.getAnimationId() != -1) {
                    Component[] rc;
                    id2 = c.getAnimationId();
                    for (Component ac : rc = this.statePaintedComponents.get(id2)) {
                        if (ac == null) continue;
                        ac.layout(context, measure);
                    }
                }
                if (!measure.contains(id2)) continue;
                c.layout(context, measure);
            }
        }
        this.mFirstLayout = false;
    }

    @Override
    public void measure(@NonNull PaintContext context, float minWidth, float maxWidth, float minHeight, float maxHeight, @NonNull MeasurePass measure) {
        Object previousLayout;
        if (this.statePaintedComponents.isEmpty()) {
            this.findAnimatedComponents();
        }
        LayoutManager layout2 = this.getLayout(this.currentLayoutIndex);
        if (this.inTransition && this.currentLayoutIndex != this.previousLayoutIndex) {
            previousLayout = this.getLayout(this.previousLayoutIndex);
            block0: for (Component c : layout2.getChildrenComponents()) {
                int id2 = c.getAnimationId();
                if (id2 == -1) continue;
                for (Component pc : ((LayoutComponent)previousLayout).getChildrenComponents()) {
                    if (pc.getAnimationId() != id2) continue;
                    Component prev = this.statePaintedComponents.get(c.getAnimationId())[this.previousLayoutIndex];
                    if (c == prev) continue block0;
                    c.measure(context, prev.getWidth(), prev.getWidth(), prev.getHeight(), prev.getHeight(), measure);
                    c.layout(context.getContext(), measure);
                    c.setX(prev.getX());
                    c.setY(prev.getY());
                    c.mVisibility = 0;
                    continue block0;
                }
            }
        }
        layout2.measure(context, minWidth, maxWidth, minHeight, maxHeight, measure);
        for (Component component : layout2.getChildrenComponents()) {
            ComponentMeasure cm = measure.get(component);
            if (component.getAnimationId() != -1) {
                ComponentMeasure m = measure.get(component.getAnimationId());
                m.copyFrom(cm);
                m.setVisibility(1);
                Component[] components = this.statePaintedComponents.get(component.getAnimationId());
                for (int idx = 0; idx < components.length; ++idx) {
                    Component ac = components[idx];
                    if (ac == null) continue;
                    ComponentMeasure m2 = measure.get(ac.getComponentId());
                    if (component != ac) {
                        m2.copyFrom(cm);
                    }
                    if (idx == this.currentLayoutIndex) {
                        m2.setVisibility(1);
                    } else if (component != ac) {
                        m2.setVisibility(0);
                    }
                    if (component == ac) continue;
                    ac.measure(context, m.getW(), m.getW(), m.getH(), m.getH(), measure);
                }
                continue;
            }
            cm.setVisibility(1);
        }
        if (this.previousLayoutIndex != this.currentLayoutIndex) {
            previousLayout = this.getLayout(this.previousLayoutIndex);
            for (Component c : ((LayoutComponent)previousLayout).getChildrenComponents()) {
                int id3 = c.getComponentId();
                if (c.getAnimationId() != -1) {
                    id3 = c.getAnimationId();
                }
                if (measure.contains(id3)) continue;
                ComponentMeasure m = measure.get(c.getComponentId());
                m.setX(c.getX());
                m.setY(c.getY());
                m.setW(c.getWidth());
                m.setH(c.getHeight());
                m.setVisibility(0);
            }
        }
        ComponentMeasure m = measure.get(layout2);
        ComponentMeasure componentMeasure = measure.get(this);
        componentMeasure.copyFrom(m);
        this.measuredLayoutIndex = this.currentLayoutIndex;
    }

    public void hideLayoutsOtherThan(int idx) {
        int index = 0;
        for (Component pane : this.mChildrenComponents) {
            if (!(pane instanceof LayoutComponent)) continue;
            pane.mVisibility = index != idx ? 0 : 1;
            ++index;
        }
    }

    @NonNull
    public LayoutManager getLayout(int idx) {
        int index = 0;
        for (Component pane : this.mChildrenComponents) {
            if (!(pane instanceof LayoutComponent)) continue;
            if (index == idx) {
                return (LayoutManager)pane;
            }
            ++index;
        }
        return (LayoutManager)this.mChildrenComponents.get(0);
    }

    @Override
    public void paint(@NonNull PaintContext context) {
        boolean needsToPaintTransition;
        int newValue;
        if (this.mIndexId != 0 && (newValue = context.getContext().mRemoteComposeState.getInteger(this.mIndexId)) != this.currentLayoutIndex) {
            this.previousLayoutIndex = this.currentLayoutIndex;
            this.currentLayoutIndex = newValue;
            this.inTransition = true;
            this.invalidateMeasure();
        }
        int index = 0;
        for (Component pane : this.mChildrenComponents) {
            if (!(pane instanceof LayoutComponent)) continue;
            if (index != this.currentLayoutIndex && index != this.previousLayoutIndex) {
                pane.mVisibility = 0;
            }
            if (index == this.currentLayoutIndex && !pane.isVisible()) {
                pane.mVisibility = 1;
            }
            ++index;
        }
        LayoutManager currentLayout = this.getLayout(this.measuredLayoutIndex);
        boolean bl = needsToPaintTransition = this.inTransition && this.previousLayoutIndex != this.measuredLayoutIndex;
        if (needsToPaintTransition) {
            int i;
            LayoutManager previousLayout = this.getLayout(this.previousLayoutIndex);
            int numPreviousComponents = previousLayout.getChildrenComponents().size();
            if (numPreviousComponents > this.MAX_CACHE_ELEMENTS) {
                this.MAX_CACHE_ELEMENTS *= 2;
                this.cacheListElementsId = new int[this.MAX_CACHE_ELEMENTS];
            }
            previousLayout.applyAnimationAsNeeded(context);
            int idIndex = 0;
            for (Component component : previousLayout.getChildrenComponents()) {
                this.cacheListElementsId[idIndex] = component.getPaintId();
                ++idIndex;
            }
            int count = idIndex;
            for (Component c : currentLayout.getChildrenComponents()) {
                int id2 = c.getPaintId();
                for (i = 0; i < idIndex; ++i) {
                    if (this.cacheListElementsId[i] != id2) continue;
                    this.cacheListElementsId[i] = -1;
                    --count;
                }
            }
            if (count > 0) {
                context.save();
                context.translate(previousLayout.getX(), previousLayout.getY());
                block4: for (Component c : previousLayout.getChildrenComponents()) {
                    int id2 = c.getPaintId();
                    for (i = 0; i < idIndex; ++i) {
                        if (this.cacheListElementsId[i] != id2) continue;
                        c.paint(context);
                        continue block4;
                    }
                }
                context.restore();
            }
            currentLayout.applyAnimationAsNeeded(context);
        }
        context.save();
        context.translate(currentLayout.getX(), currentLayout.getY());
        for (Operation op : currentLayout.getList()) {
            if (op instanceof Component && ((Component)op).getAnimationId() != -1) {
                Component component;
                Component[] stateComponents = this.statePaintedComponents.get(((Component)op).getAnimationId());
                Component component2 = stateComponents[this.measuredLayoutIndex];
                if (needsToPaintTransition && (component = stateComponents[this.previousLayoutIndex]) != null && component2 != component) {
                    component.paint(context);
                }
                component2.paint(context);
                continue;
            }
            if (!(op instanceof PaintOperation)) continue;
            ((PaintOperation)op).paint(context);
        }
        context.restore();
        if (needsToPaintTransition) {
            this.checkEndOfTransition();
        }
    }

    public void checkEndOfTransition() {
        LayoutManager currentLayout = this.getLayout(this.measuredLayoutIndex);
        LayoutManager previousLayout = this.getLayout(this.previousLayoutIndex);
        if (this.inTransition && currentLayout.mAnimateMeasure == null && previousLayout.mAnimateMeasure == null) {
            this.inTransition = false;
            LayoutManager previous = this.getLayout(this.previousLayoutIndex);
            if (previous != currentLayout && !previous.isGone()) {
                previous.mVisibility = 0;
                previous.needsRepaint();
            }
        }
    }

    @Override
    @NonNull
    public String toString() {
        return "STATE_LAYOUT";
    }

    public static void apply(@NonNull WireBuffer buffer, int componentId, int animationId, int horizontalPositioning, int verticalPositioning, int indexId) {
        buffer.start(217);
        buffer.writeInt(componentId);
        buffer.writeInt(animationId);
        buffer.writeInt(horizontalPositioning);
        buffer.writeInt(verticalPositioning);
        buffer.writeInt(indexId);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int componentId = buffer.readInt();
        int animationId = buffer.readInt();
        buffer.readInt();
        buffer.readInt();
        int indexId = buffer.readInt();
        operations.add(new StateLayout(null, componentId, animationId, 0.0f, 0.0f, 100.0f, 100.0f, indexId));
    }

    @Override
    public void serialize(MapSerializer serializer) {
        super.serialize(serializer);
        serializer.add("indexId", this.mIndexId);
    }
}

