/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.operations.layout.modifiers;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.VariableSupport;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.operations.Utils;
import com.android.internal.widget.remotecompose.core.operations.layout.modifiers.ModifierOperation;
import com.android.internal.widget.remotecompose.core.operations.utilities.StringSerializer;

public abstract class DimensionInModifierOperation
extends Operation
implements ModifierOperation,
VariableSupport {
    int mOpCode = -1;
    float mV1;
    float mV2;
    float mValue1;
    float mValue2;

    public DimensionInModifierOperation(int opcode, float min, float max) {
        this.mOpCode = opcode;
        this.mValue1 = min;
        this.mValue2 = max;
        if (!Float.isNaN(this.mValue1)) {
            this.mV1 = this.mValue1;
        }
        if (!Float.isNaN(this.mValue2)) {
            this.mV2 = this.mValue2;
        }
    }

    @Override
    public void updateVariables(@NonNull RemoteContext context) {
        this.mV1 = Float.isNaN(this.mValue1) ? context.getFloat(Utils.idFromNan(this.mValue1)) : this.mValue1;
        float f = this.mV2 = Float.isNaN(this.mValue2) ? context.getFloat(Utils.idFromNan(this.mValue2)) : this.mValue2;
        if (this.mV1 != -1.0f) {
            this.mV1 *= context.getDensity();
        }
        if (this.mV2 != -1.0f) {
            this.mV2 *= context.getDensity();
        }
    }

    @Override
    public void registerListening(@NonNull RemoteContext context) {
        if (Float.isNaN(this.mValue1)) {
            context.listensTo(Utils.idFromNan(this.mValue1), this);
        }
        if (Float.isNaN(this.mValue2)) {
            context.listensTo(Utils.idFromNan(this.mValue2), this);
        }
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return indent + this.toString();
    }

    public float getMin() {
        return this.mV1;
    }

    public float getMax() {
        return this.mV2;
    }

    @Override
    public void serializeToString(int indent, @NonNull StringSerializer serializer) {
        serializer.append(indent, "WIDTH_IN = [" + this.getMin() + ", " + this.getMax() + "]");
    }
}

