/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.remotecompose.core.types;

import android.annotation.NonNull;
import com.android.internal.widget.remotecompose.core.Operation;
import com.android.internal.widget.remotecompose.core.RemoteContext;
import com.android.internal.widget.remotecompose.core.WireBuffer;
import com.android.internal.widget.remotecompose.core.documentation.DocumentationBuilder;
import com.android.internal.widget.remotecompose.core.serialize.MapSerializer;
import com.android.internal.widget.remotecompose.core.serialize.Serializable;
import java.util.List;

public class BooleanConstant
extends Operation
implements Serializable {
    private static final String CLASS_NAME = "BooleanConstant";
    private static final int OP_CODE = 143;
    private boolean mValue = false;
    private int mId;

    public BooleanConstant(int id2, boolean value) {
        this.mId = id2;
        this.mValue = value;
    }

    public boolean getValue() {
        return this.mValue;
    }

    @Override
    public void write(@NonNull WireBuffer buffer) {
        BooleanConstant.apply(buffer, this.mId, this.mValue);
    }

    @Override
    public void apply(@NonNull RemoteContext context) {
    }

    @Override
    @NonNull
    public String deepToString(@NonNull String indent) {
        return this.toString();
    }

    @NonNull
    public String toString() {
        return "BooleanConstant[" + this.mId + "] = " + this.mValue + "";
    }

    @NonNull
    public static String name() {
        return "OrigamiBoolean";
    }

    public static int id() {
        return 143;
    }

    public static void apply(@NonNull WireBuffer buffer, int id2, boolean value) {
        buffer.start(143);
        buffer.writeInt(id2);
        buffer.writeBoolean(value);
    }

    public static void read(@NonNull WireBuffer buffer, @NonNull List<Operation> operations) {
        int id2 = buffer.readInt();
        boolean value = buffer.readBoolean();
        operations.add(new BooleanConstant(id2, value));
    }

    public static void documentation(@NonNull DocumentationBuilder doc) {
        doc.operation("Expressions Operations", 143, CLASS_NAME).description("A boolean and its associated id").field(0, "id", "id of Int").field(6, "value", "8-bit 0 or 1");
    }

    @Override
    public void serialize(MapSerializer serializer) {
        serializer.addType(CLASS_NAME).add("id", this.mId).add("value", this.mValue);
    }
}

