/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.util.DisplayMetrics;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.CustomBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;

public class NavigationBar
extends CustomBar {
    private static final String ATTR_COLOR = "navigationBarColor";
    public static final String ATTR_TRANSLUCENT = "windowTranslucentNavigation";
    private static final int PADDING_WIDTH_DEFAULT = 36;
    private static final int PADDING_WIDTH_SW360 = 40;
    private static final int PADDING_WIDTH_SW400 = 50;
    private static final int WIDTH_DEFAULT = 36;
    private static final int WIDTH_SW360 = 40;
    private static final int WIDTH_SW600 = 48;
    private static final String LAYOUT_XML = "navigation_bar.xml";
    private static final String LAYOUT_600DP_XML = "navigation_bar600dp.xml";

    public NavigationBar(BridgeContext context, Density density, int orientation, boolean isRtl, boolean rtlEnabled, boolean isEdgeToEdge, int simulatedPlatformVersion, boolean quickStepEnabled) {
        this(context, density, orientation, isRtl, rtlEnabled, isEdgeToEdge, simulatedPlatformVersion, NavigationBar.getShortestWidth(context) >= 600.0f ? LAYOUT_600DP_XML : LAYOUT_XML, quickStepEnabled);
    }

    private NavigationBar(BridgeContext context, Density density, int orientation, boolean isRtl, boolean rtlEnabled, boolean isEdgeToEdge, int simulatedPlatformVersion, String layoutPath, boolean quickStepEnabled) {
        super(context, orientation, layoutPath, simulatedPlatformVersion);
        boolean isLightTheme = ResourceHelper.getBooleanThemeFrameworkAttrValue(context.getRenderResources(), "isLightTheme", false);
        if (isEdgeToEdge) {
            this.setBackgroundColor(isLightTheme ? -419430401 : 0x66000000);
        } else {
            int color2 = this.getBarColor(ATTR_COLOR, ATTR_TRANSLUCENT);
            this.setBackgroundColor(color2 == 0 ? -16777216 : color2);
        }
        int back = 1;
        int recent = 5;
        if (orientation == 1 || isRtl && !rtlEnabled) {
            back = 5;
            recent = 1;
        }
        int iconColor = isLightTheme ? -1728053248 : -1;
        String ext = Config.getNavIconType(simulatedPlatformVersion);
        this.loadIcon(back, (quickStepEnabled ? "ic_sysbar_back_quick_step." : "ic_sysbar_back.") + ext, density, isRtl, iconColor);
        this.loadIcon(3, (quickStepEnabled ? "ic_sysbar_home_quick_step." : "ic_sysbar_home.") + ext, density, isRtl, iconColor);
        if (!quickStepEnabled) {
            this.loadIcon(recent, "ic_sysbar_recent." + ext, density, isRtl, iconColor);
        }
        this.setupNavBar(context, orientation);
    }

    private void setupNavBar(BridgeContext context, int orientation) {
        float sw = NavigationBar.getShortestWidth(context);
        View leftPadding = this.getChildAt(0);
        View rightPadding = this.getChildAt(6);
        NavigationBar.setSize(context, leftPadding, orientation, this.getSidePadding(sw));
        NavigationBar.setSize(context, rightPadding, orientation, this.getSidePadding(sw));
        int navButtonWidth = NavigationBar.getWidth(sw);
        for (int i = 1; i < 6; i += 2) {
            View navButton = this.getChildAt(i);
            NavigationBar.setSize(context, navButton, orientation, navButtonWidth);
        }
        if (sw >= 600.0f) {
            NavigationBar.setSize(context, this.getChildAt(2), orientation, 128);
            NavigationBar.setSize(context, this.getChildAt(4), orientation, 128);
        }
    }

    private static void setSize(BridgeContext context, View view, int orientation, int size) {
        size = (int)((float)size * context.getMetrics().density);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
        if (orientation == 0) {
            layoutParams.width = size;
        } else {
            layoutParams.height = size;
        }
        view.setLayoutParams(layoutParams);
    }

    private int getSidePadding(float sw) {
        if (sw >= 400.0f) {
            return 50;
        }
        if (sw >= 360.0f) {
            return 40;
        }
        return 36;
    }

    private static int getWidth(float sw) {
        if (sw >= 600.0f) {
            return 48;
        }
        if (sw >= 360.0f) {
            return 40;
        }
        return 36;
    }

    private static float getShortestWidth(BridgeContext context) {
        DisplayMetrics metrics = context.getMetrics();
        float sw = Math.min(metrics.widthPixels, metrics.heightPixels);
        return sw /= metrics.density;
    }

    @Override
    protected TextView getStyleableTextView() {
        return null;
    }
}

