/*
 * Decompiled with CFR 0.152.
 */
package com.android.ondevicepersonalization.internal.util;

import android.util.Log;
import java.util.Locale;

public class LoggerFactory {
    public static final String TAG = "ondevicepersonalization";
    private static final Logger sLogger = new Logger("ondevicepersonalization");

    public static Logger getLogger() {
        return sLogger;
    }

    public static class Logger {
        private final String mTag;

        private Logger(String mTag) {
            this.mTag = mTag;
        }

        public int v(String msg) {
            if (Log.isLoggable(this.mTag, 2)) {
                return Log.v(this.mTag, msg);
            }
            return 0;
        }

        public int v(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 2)) {
                String msg = Logger.format(format, params);
                return Log.v(this.mTag, msg);
            }
            return 0;
        }

        public int d(String msg) {
            if (Log.isLoggable(this.mTag, 3)) {
                return Log.d(this.mTag, msg);
            }
            return 0;
        }

        public int d(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 3)) {
                String msg = Logger.format(format, params);
                return Log.d(this.mTag, msg);
            }
            return 0;
        }

        public int d(Throwable tr, String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 3)) {
                String msg = Logger.format(format, params);
                return Log.d(this.mTag, msg, tr);
            }
            return 0;
        }

        public int i(String msg) {
            if (Log.isLoggable(this.mTag, 4)) {
                return Log.i(this.mTag, msg);
            }
            return 0;
        }

        public int i(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 4)) {
                String msg = Logger.format(format, params);
                return Log.i(this.mTag, msg);
            }
            return 0;
        }

        public int w(String msg) {
            if (Log.isLoggable(this.mTag, 5)) {
                return Log.w(this.mTag, msg);
            }
            return 0;
        }

        public int w(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 5)) {
                String msg = Logger.format(format, params);
                return Log.w(this.mTag, msg);
            }
            return 0;
        }

        public int e(String msg) {
            if (Log.isLoggable(this.mTag, 6)) {
                return Log.e(this.mTag, msg);
            }
            return 0;
        }

        public int e(String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 6)) {
                String msg = Logger.format(format, params);
                return Log.e(this.mTag, msg);
            }
            return 0;
        }

        public int e(Throwable tr, String msg) {
            if (Log.isLoggable(this.mTag, 6)) {
                if (Log.isLoggable(this.mTag, 3)) {
                    return Log.e(this.mTag, msg, tr);
                }
                msg = msg + ": " + tr;
                return Log.e(this.mTag, msg);
            }
            return 0;
        }

        public int e(Throwable tr, String format, Object ... params) {
            return Log.isLoggable(this.mTag, 6) ? this.e(tr, Logger.format(format, params)) : 0;
        }

        public int w(Throwable tr, String format, Object ... params) {
            if (Log.isLoggable(this.mTag, 5)) {
                if (Log.isLoggable(this.mTag, 3)) {
                    String msg = Logger.format(format, params);
                    return Log.w(this.mTag, msg, tr);
                }
                String msg = Logger.format(format, params) + ": " + tr;
                return Log.w(this.mTag, msg);
            }
            return 0;
        }

        @Deprecated
        public int d(String msg, Throwable tr) {
            return this.d(tr, msg, new Object[0]);
        }

        @Deprecated
        public int w(String msg, Throwable tr) {
            return this.w(tr, msg, new Object[0]);
        }

        @Deprecated
        public int e(String msg, Throwable tr) {
            return this.e(tr, msg);
        }

        private static String format(String format, Object ... args) {
            return String.format(Locale.US, format, args);
        }
    }
}

