/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResultWithImage;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.base.Preconditions;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public class AccessibilityViewCheckResult
extends AccessibilityCheckResult {
    private final @Nullable ViewHierarchyElement element;
    private final @Nullable View view;
    private final @Nullable Image viewImage;
    private final @Nullable AccessibilityHierarchyCheckResult hierarchyCheckResult;

    public AccessibilityViewCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, CharSequence message, @Nullable View view, @Nullable Image viewImage) {
        super(checkClass, type, message);
        this.element = null;
        this.view = view;
        this.viewImage = viewImage;
        this.hierarchyCheckResult = null;
    }

    public AccessibilityViewCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, CharSequence message, @Nullable View view) {
        this(checkClass, type, message, view, null);
    }

    AccessibilityViewCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityHierarchyCheckResult hierarchyCheckResult, @Nullable ViewHierarchyElement element, @Nullable View view) {
        super(checkClass, hierarchyCheckResult.getType(), null);
        this.element = element;
        this.view = view;
        this.viewImage = hierarchyCheckResult instanceof AccessibilityHierarchyCheckResultWithImage ? ((AccessibilityHierarchyCheckResultWithImage)hierarchyCheckResult).getViewImage() : null;
        this.hierarchyCheckResult = hierarchyCheckResult;
    }

    public AccessibilityViewCheckResult getSuppressedResultCopy() {
        AccessibilityViewCheckResult result = this.hierarchyCheckResult == null ? new AccessibilityViewCheckResult(this.getSourceCheckClass(), AccessibilityCheckResult.AccessibilityCheckResultType.SUPPRESSED, this.getMessage(Locale.ENGLISH), this.getView()) : new AccessibilityViewCheckResult(this.getSourceCheckClass(), this.hierarchyCheckResult.getSuppressedResultCopy(), this.getElement(), this.getView());
        return result;
    }

    public @Nullable View getView() {
        return this.view;
    }

    public @Nullable Image getViewImage() {
        return this.viewImage;
    }

    public @Nullable ViewHierarchyElement getElement() {
        return this.element;
    }

    public AccessibilityHierarchyCheckResult getAccessibilityHierarchyCheckResult() {
        return (AccessibilityHierarchyCheckResult)Preconditions.checkNotNull((Object)this.hierarchyCheckResult);
    }

    public Class<? extends AccessibilityHierarchyCheck> getAccessibilityHierarchyCheck() {
        return this.getAccessibilityHierarchyCheckResult().getSourceCheckClass().asSubclass(AccessibilityHierarchyCheck.class);
    }

    public int getResultId() {
        return this.getAccessibilityHierarchyCheckResult().getResultId();
    }

    @Pure
    public @Nullable ResultMetadata getMetadata() {
        return this.getAccessibilityHierarchyCheckResult().getMetadata();
    }

    @Override
    public CharSequence getMessage() {
        return this.hierarchyCheckResult == null ? super.getMessage() : this.hierarchyCheckResult.getMessage();
    }

    @Override
    public CharSequence getMessage(Locale locale) {
        return this.hierarchyCheckResult == null ? super.getMessage(locale) : this.hierarchyCheckResult.getMessage(locale);
    }

    @Override
    public String toString() {
        return String.format("[AccessibilityViewCheckResult check=%s view=%s]", this.hierarchyCheckResult, this.view);
    }
}

