/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.res.Resources;
import android.graphics.Rect;
import android.os._Original_Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ViewAccessibilityUtils {
    private static final String TAG = "ViewA11yUtils";

    private ViewAccessibilityUtils() {
    }

    public static Set<View> getAllViewsInHierarchy(View rootView) {
        HashSet<View> allViews = new HashSet<View>();
        allViews.add(rootView);
        ViewAccessibilityUtils.addAllChildrenToSet(rootView, allViews);
        return allViews;
    }

    public static boolean isImportantForAccessibility(View view) {
        if (view == null) {
            return false;
        }
        if (_Original_Build.VERSION.SDK_INT >= 21) {
            return view.isImportantForAccessibility();
        }
        if (_Original_Build.VERSION.SDK_INT < 16) {
            return true;
        }
        int mode = view.getImportantForAccessibility();
        if (mode == 2 || mode == 4) {
            return false;
        }
        ViewParent parent = view.getParent();
        while (parent instanceof View) {
            if (((View)((Object)parent)).getImportantForAccessibility() == 4) {
                return false;
            }
            parent = parent.getParent();
        }
        return mode == 1 || ViewAccessibilityUtils.isActionableForAccessibility(view) || ViewAccessibilityUtils.hasListenersForAccessibility(view) || view.getAccessibilityNodeProvider() != null || ViewAccessibilityUtils.isAccessibilityLiveRegion(view);
    }

    public static boolean isActionableForAccessibility(View view) {
        if (view == null) {
            return false;
        }
        return view.isClickable() || view.isLongClickable() || view.isFocusable();
    }

    public static boolean isVisibleToUser(View view) {
        if (view == null) {
            return false;
        }
        Object current = view;
        while (current instanceof View) {
            Object currentView = current;
            if (((View)currentView).getAlpha() <= 0.0f || ((View)currentView).getVisibility() != 0) {
                return false;
            }
            current = ((View)currentView).getParent();
        }
        return view.getGlobalVisibleRect(new Rect());
    }

    @RequiresApi(value=16)
    public static boolean shouldFocusView(View view) {
        if (view == null) {
            return false;
        }
        if (!ViewAccessibilityUtils.isVisibleToUser(view) || !ViewAccessibilityUtils.isImportantForAccessibility(view)) {
            return false;
        }
        if (ViewAccessibilityUtils.isAccessibilityFocusable(view)) {
            if (!(view instanceof ViewGroup) || view instanceof ViewGroup && !ViewAccessibilityUtils.hasAnyImportantDescendant((ViewGroup)view)) {
                return true;
            }
            return ViewAccessibilityUtils.isSpeakingView(view);
        }
        return ViewAccessibilityUtils.hasText(view) && !ViewAccessibilityUtils.hasFocusableAncestor(view);
    }

    public static @Nullable View getLabelForView(View view) {
        if (_Original_Build.VERSION.SDK_INT < 17) {
            return null;
        }
        int idToFind = view.getId();
        if (idToFind == -1) {
            return null;
        }
        View childToSkip = null;
        View labelingView;
        while ((labelingView = ViewAccessibilityUtils.lookForLabelForViewInViewAndChildren(view, childToSkip, idToFind)) == null) {
            ViewParent parent = view.getParent();
            childToSkip = view;
            if (!(parent instanceof View)) {
                return null;
            }
            view = (View)((Object)parent);
        }
        return labelingView;
    }

    public static @Nullable Boolean isViewEditable(View view) {
        if (view == null) {
            return null;
        }
        if (view instanceof EditText) {
            return true;
        }
        if (view instanceof TextView) {
            return ((TextView)view).getEditableText() != null;
        }
        return false;
    }

    public static @Nullable String getResourceNameForView(View view) {
        if (view == null || view.getId() == 0 || view.getId() == -1 || view.getResources() == null) {
            return null;
        }
        if (!ViewAccessibilityUtils.isViewIdGenerated(view.getId())) {
            try {
                return view.getResources().getResourceName(view.getId());
            }
            catch (Resources.NotFoundException nfe) {
                LogUtils.w(TAG, "Unable to resolve resource name from view ID.", new Object[0]);
            }
        }
        return null;
    }

    public static boolean isViewIdGenerated(int resourceId) {
        return (resourceId & 0xFF000000) == 0 && (resourceId & 0xFFFFFF) != 0;
    }

    @RequiresApi(value=17)
    private static @Nullable View lookForLabelForViewInViewAndChildren(View view, @Nullable View childToSkip, int idToFind) {
        if (view.getLabelFor() == idToFind) {
            return view;
        }
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View labelingView;
            View child = viewGroup.getChildAt(i);
            if (child.equals(childToSkip) || (labelingView = ViewAccessibilityUtils.lookForLabelForViewInViewAndChildren(child, null, idToFind)) == null) continue;
            return labelingView;
        }
        return null;
    }

    private static void addAllChildrenToSet(View rootView, Set<View> theSet) {
        if (!(rootView instanceof ViewGroup)) {
            return;
        }
        ViewGroup rootViewGroup = (ViewGroup)rootView;
        for (int i = 0; i < rootViewGroup.getChildCount(); ++i) {
            View nextView = rootViewGroup.getChildAt(i);
            theSet.add(nextView);
            ViewAccessibilityUtils.addAllChildrenToSet(nextView, theSet);
        }
    }

    private static boolean hasListenersForAccessibility(View view) {
        if (view == null) {
            return false;
        }
        boolean result = false;
        return result |= view.getTouchDelegate() != null;
    }

    private static boolean isAccessibilityLiveRegion(View view) {
        return _Original_Build.VERSION.SDK_INT >= 19 && view.getAccessibilityLiveRegion() != 0;
    }

    @RequiresApi(value=16)
    private static boolean hasFocusableAncestor(View view) {
        if (view == null) {
            return false;
        }
        ViewParent parent = view.getParentForAccessibility();
        if (!(parent instanceof View)) {
            return false;
        }
        if (ViewAccessibilityUtils.isAccessibilityFocusable((View)((Object)parent))) {
            return true;
        }
        return ViewAccessibilityUtils.hasFocusableAncestor((View)((Object)parent));
    }

    @RequiresApi(value=16)
    private static boolean isAccessibilityFocusable(View view) {
        if (view == null) {
            return false;
        }
        if (view.getVisibility() != 0) {
            return false;
        }
        if (!ViewAccessibilityUtils.isImportantForAccessibility(view)) {
            return false;
        }
        if (ViewAccessibilityUtils.isActionableForAccessibility(view)) {
            return true;
        }
        return ViewAccessibilityUtils.isChildOfScrollableContainer(view) && ViewAccessibilityUtils.isSpeakingView(view);
    }

    @RequiresApi(value=16)
    private static boolean isChildOfScrollableContainer(View view) {
        if (view == null) {
            return false;
        }
        ViewParent viewParent = view.getParentForAccessibility();
        if (viewParent == null || !(viewParent instanceof View)) {
            return false;
        }
        View parent = (View)((Object)viewParent);
        if (parent.isScrollContainer()) {
            return true;
        }
        return (parent instanceof AdapterView || parent instanceof ScrollView || parent instanceof HorizontalScrollView) && !(parent instanceof Spinner);
    }

    @RequiresApi(value=16)
    private static boolean isSpeakingView(View view) {
        if (ViewAccessibilityUtils.hasText(view)) {
            return true;
        }
        if (view instanceof Checkable) {
            return true;
        }
        return ViewAccessibilityUtils.hasNonActionableSpeakingChildren(view);
    }

    @RequiresApi(value=16)
    private static boolean hasNonActionableSpeakingChildren(View view) {
        if (view == null || !(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            if (child == null || child.getVisibility() != 0 || ViewAccessibilityUtils.isAccessibilityFocusable(child) || !ViewAccessibilityUtils.isImportantForAccessibility(child) || !ViewAccessibilityUtils.isSpeakingView(child)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasText(View view) {
        if (!TextUtils.isEmpty(view.getContentDescription())) {
            return true;
        }
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            return !TextUtils.isEmpty(textView.getText()) || !TextUtils.isEmpty(textView.getHint());
        }
        return false;
    }

    private static boolean hasAnyImportantDescendant(ViewGroup group) {
        if (group == null) {
            return false;
        }
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            if (ViewAccessibilityUtils.isImportantForAccessibility(child)) {
                return true;
            }
            if (!(child instanceof ViewGroup) || !ViewAccessibilityUtils.hasAnyImportantDescendant((ViewGroup)child)) continue;
            return true;
        }
        return false;
    }
}

