/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.system.VMRuntime;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import libcore.util.NativeAllocationRegistry_Delegate;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class NativeAllocationRegistry {
    private final Class clazz;
    private final ClassLoader classLoader;
    private final long freeFunction;
    private final long size;
    private static final long IS_MALLOCED = 1L;
    private static final long DEFAULT_SIZE = 98L;
    private static final Map<NativeAllocationRegistry, Void> registries = new WeakHashMap<NativeAllocationRegistry, Void>();
    private volatile int counter = 0;
    private static final VarHandle COUNTER;
    private static int numClasses;

    private boolean isMalloced() {
        return (this.size & 1L) == 1L;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NativeAllocationRegistry createNonmalloced(ClassLoader classLoader, long freeFunction, long size) {
        return new NativeAllocationRegistry(classLoader, NativeAllocationRegistry.class, freeFunction, size, false);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.native_metrics")
    public static NativeAllocationRegistry createNonmalloced(Class clazz, long freeFunction, long size) {
        return new NativeAllocationRegistry(clazz.getClassLoader(), clazz, freeFunction, size, false);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NativeAllocationRegistry createMalloced_Original(ClassLoader classLoader, long freeFunction, long size) {
        return new NativeAllocationRegistry(classLoader, NativeAllocationRegistry.class, freeFunction, size, true);
    }

    @LayoutlibDelegate
    public static NativeAllocationRegistry createMalloced(ClassLoader classLoader, long l, long l2) {
        return NativeAllocationRegistry_Delegate.createMalloced(classLoader, l, l2);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static NativeAllocationRegistry createMalloced_Original(ClassLoader classLoader, long freeFunction) {
        return new NativeAllocationRegistry(classLoader, NativeAllocationRegistry.class, freeFunction, 98L, true);
    }

    @LayoutlibDelegate
    public static NativeAllocationRegistry createMalloced(ClassLoader classLoader, long l) {
        return NativeAllocationRegistry_Delegate.createMalloced(classLoader, l);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.native_metrics")
    public static NativeAllocationRegistry createMalloced_Original(Class clazz, long freeFunction, long size) {
        return new NativeAllocationRegistry(clazz.getClassLoader(), clazz, freeFunction, size, true);
    }

    @LayoutlibDelegate
    public static NativeAllocationRegistry createMalloced(Class clazz, long l, long l2) {
        return NativeAllocationRegistry_Delegate.createMalloced(clazz, l, l2);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.native_metrics")
    public static NativeAllocationRegistry createMalloced_Original(Class clazz, long freeFunction) {
        return new NativeAllocationRegistry(clazz.getClassLoader(), clazz, freeFunction, 98L, true);
    }

    @LayoutlibDelegate
    public static NativeAllocationRegistry createMalloced(Class clazz, long l) {
        return NativeAllocationRegistry_Delegate.createMalloced(clazz, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeAllocationRegistry(ClassLoader classLoader, Class clazz, long freeFunction, long size, boolean mallocAllocation) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid native allocation size: " + size);
        }
        this.clazz = Objects.requireNonNull(clazz);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.freeFunction = freeFunction;
        this.size = mallocAllocation ? size | 1L : size & 0xFFFFFFFFFFFFFFFEL;
        Class<NativeAllocationRegistry> clazz2 = NativeAllocationRegistry.class;
        synchronized (NativeAllocationRegistry.class) {
            registries.put(this, null);
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public NativeAllocationRegistry(ClassLoader classLoader, long freeFunction, long size) {
        this(classLoader, NativeAllocationRegistry.class, freeFunction, size, size == 0L);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.native_metrics")
    public static synchronized Collection<Metrics> getMetrics() {
        ArrayList<Metrics> result = new ArrayList<Metrics>(numClasses + 1);
        for (NativeAllocationRegistry r : registries.keySet()) {
            String className = r.clazz.getName();
            Metrics m = null;
            for (int i = 0; i < result.size(); ++i) {
                if (((Metrics)result.get((int)i)).className != className) continue;
                m = (Metrics)result.get(i);
                break;
            }
            if (m == null) {
                m = new Metrics(className);
                result.add(m);
            }
            m.add(r);
        }
        numClasses = result.size();
        return result;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public Runnable registerNativeAllocation(Object referent, long nativePtr) {
        CleanerRunner result;
        CleanerThunk thunk;
        if (referent == null) {
            throw new IllegalArgumentException("referent is null");
        }
        if (nativePtr == 0L) {
            throw new IllegalArgumentException("nativePtr is null");
        }
        try {
            thunk = new CleanerThunk();
            Cleaner cleaner = Cleaner.create(referent, thunk);
            result = new CleanerRunner(cleaner);
            NativeAllocationRegistry.registerNativeAllocation(this.size);
        }
        catch (VirtualMachineError vme) {
            NativeAllocationRegistry_Delegate.applyFreeFunction(this.freeFunction, nativePtr);
            throw vme;
        }
        thunk.setNativePtr(nativePtr);
        Reference.reachabilityFence(referent);
        COUNTER.getAndAdd(this, 1);
        return result;
    }

    public static boolean isCleanerThunk(Object obj) {
        return obj instanceof CleanerThunk;
    }

    private static void registerNativeAllocation(long size) {
        VMRuntime runtime = VMRuntime.getRuntime();
        if ((size & 1L) != 0L) {
            long notifyImmediateThreshold = 300000L;
            if (size >= 300000L) {
                runtime.notifyNativeAllocationsInternal();
            } else {
                runtime.notifyNativeAllocation();
            }
        } else {
            runtime.registerNativeAllocation(size);
        }
    }

    private static void registerNativeFree(long size) {
        if ((size & 1L) == 0L) {
            VMRuntime.getRuntime().registerNativeFree(size);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static native void applyFreeFunction(long var0, long var2);

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            COUNTER = l.findVarHandle(NativeAllocationRegistry.class, "counter", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
        numClasses = 3;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @FlaggedApi(value="com.android.libcore.native_metrics")
    public static class Metrics {
        private String className;
        private int mallocedCount;
        private long mallocedBytes;
        private int nonmallocedCount;
        private long nonmallocedBytes;

        private Metrics(String className) {
            this.className = className;
        }

        private void add(NativeAllocationRegistry r) {
            int count = r.counter;
            long bytes = (long)count * (r.size & 0xFFFFFFFFFFFFFFFEL);
            if (r.isMalloced()) {
                this.mallocedCount += count;
                this.mallocedBytes += bytes;
            } else {
                this.nonmallocedCount += count;
                this.nonmallocedBytes += bytes;
            }
        }

        public String getClassName() {
            return this.className;
        }

        public long getMallocedCount() {
            return this.mallocedCount;
        }

        public long getMallocedBytes() {
            return this.mallocedBytes;
        }

        public long getNonmallocedCount() {
            return this.nonmallocedCount;
        }

        public long getNonmallocedBytes() {
            return this.nonmallocedBytes;
        }
    }

    private class CleanerThunk
    implements Runnable {
        private long nativePtr = 0L;

        @Override
        public void run() {
            if (this.nativePtr != 0L) {
                NativeAllocationRegistry_Delegate.applyFreeFunction(NativeAllocationRegistry.this.freeFunction, this.nativePtr);
                NativeAllocationRegistry.registerNativeFree(NativeAllocationRegistry.this.size);
                COUNTER.getAndAdd(NativeAllocationRegistry.this, -1);
            }
        }

        public void setNativePtr(long nativePtr) {
            this.nativePtr = nativePtr;
        }

        public String toString() {
            return super.toString() + "(freeFunction = 0x" + Long.toHexString(NativeAllocationRegistry.this.freeFunction) + ", nativePtr = 0x" + Long.toHexString(this.nativePtr) + ", size = " + NativeAllocationRegistry.this.size + ")";
        }
    }

    private static class CleanerRunner
    implements Runnable {
        private final Cleaner cleaner;

        public CleanerRunner(Cleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        public void run() {
            this.cleaner.clean();
        }
    }
}

