/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.cxx.ninja;

import com.android.SdkConstants;
import com.android.utils.TokenizedCommandLine;
import com.android.utils.TokenizedCommandLineKt;
import com.android.utils.cxx.CompileCommandsCodecKt;
import com.android.utils.cxx.CompileCommandsEncoder;
import com.android.utils.cxx.collections.DoubleStringBuilder;
import com.android.utils.cxx.io.LexicalFilenameUtilsKt;
import com.android.utils.cxx.ninja.NinjaBuildUnexpandedCommand;
import com.android.utils.cxx.ninja.StreamNinjaBuildCommandsKt;
import com.android.utils.cxx.os.OsBehavior;
import com.android.utils.cxx.os.OsBehaviorKt;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a\u007f\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2U\b\u0002\u0010\u000b\u001aO\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0004\u0018\u00010\fj\u0004\u0018\u0001`\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002\u001a\u0016\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"NORMAL_SHUTDOWN_TIMEOUT_MS", "", "ERROR_SHUTDOWN_TIMEOUT_MS", "writeCompileCommandsJsonBin", "", "ninjaBuildFile", "Ljava/io/File;", "sourcesRoot", "compileCommandsJsonBin", "platform", "", "progress", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "filename", "totalBytes", "bytesRead", "Lcom/android/utils/cxx/io/ProgressCallback;", "stripFlags", "Lcom/android/utils/TokenizedCommandLine;", "sourceFile", "isToolchainTool", "", "exe", "deconflictSourceFiles", "sources", "", "android.sdktools.common"})
@SourceDebugExtension(value={"SMAP\nWriteCompileCommandsJsonBin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WriteCompileCommandsJsonBin.kt\ncom/android/utils/cxx/ninja/WriteCompileCommandsJsonBinKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n669#2,11:261\n*S KotlinDebug\n*F\n+ 1 WriteCompileCommandsJsonBin.kt\ncom/android/utils/cxx/ninja/WriteCompileCommandsJsonBinKt\n*L\n259#1:261,11\n*E\n"})
public final class WriteCompileCommandsJsonBinKt {
    private static final long NORMAL_SHUTDOWN_TIMEOUT_MS = 30000L;
    private static final long ERROR_SHUTDOWN_TIMEOUT_MS = 500L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeCompileCommandsJsonBin(@NotNull File ninjaBuildFile, @NotNull File sourcesRoot, @NotNull File compileCommandsJsonBin, int platform, @Nullable Function3<? super String, ? super Long, ? super Long, Unit> progress) {
        Intrinsics.checkNotNullParameter((Object)ninjaBuildFile, (String)"ninjaBuildFile");
        Intrinsics.checkNotNullParameter((Object)sourcesRoot, (String)"sourcesRoot");
        Intrinsics.checkNotNullParameter((Object)compileCommandsJsonBin, (String)"compileCommandsJsonBin");
        ExecutorService parseExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ExecutorService writeExecutor = Executors.newSingleThreadExecutor();
        OsBehavior os = OsBehaviorKt.createOsBehavior$default(platform, null, null, 6, null);
        List buffers = new ArrayList();
        Ref.ObjectRef error = new Ref.ObjectRef();
        AutoCloseable autoCloseable = new CompileCommandsEncoder(compileCommandsJsonBin, 0, 2, null);
        Throwable throwable = null;
        try {
            CompileCommandsEncoder encoder = (CompileCommandsEncoder)autoCloseable;
            boolean bl = false;
            try {
                StreamNinjaBuildCommandsKt.streamNinjaBuildCommands(ninjaBuildFile, progress, (Function1<? super NinjaBuildUnexpandedCommand, Unit>)((Function1)arg_0 -> WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$lambda$8(parseExecutor, error, os, ninjaBuildFile, buffers, sourcesRoot, writeExecutor, encoder, arg_0)));
                parseExecutor.shutdown();
                parseExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
                writeExecutor.shutdown();
                writeExecutor.awaitTermination(30000L, TimeUnit.MILLISECONDS);
                WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$checkError((Ref.ObjectRef<Throwable>)error, parseExecutor, writeExecutor);
            }
            catch (Throwable e) {
                if (compileCommandsJsonBin.isFile()) {
                    try {
                        compileCommandsJsonBin.delete();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void writeCompileCommandsJsonBin$default(File file, File file2, File file3, int n, Function3 function3, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = SdkConstants.CURRENT_PLATFORM;
        }
        if ((n2 & 0x10) != 0) {
            function3 = null;
        }
        WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin(file, file2, file3, n, (Function3<? super String, ? super Long, ? super Long, Unit>)function3);
    }

    private static final void stripFlags(TokenizedCommandLine $this$stripFlags, String sourceFile) {
        TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, sourceFile, 0, false, false, true, 12, null);
        TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, "-o", 1, false, false, false, 28, null);
        TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, "--output=", 0, true, false, false, 24, null);
        TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, "--output", 1, false, false, false, 28, null);
        TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, "-fcolor-diagnostics", 1, false, false, false, 28, null);
        for (String flag : CompileCommandsCodecKt.getSTRIP_FLAGS_WITH_ARG()) {
            TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, flag, 1, false, false, false, 28, null);
        }
        for (String flag : CompileCommandsCodecKt.getSTRIP_FLAGS_WITH_IMMEDIATE_ARG()) {
            TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, flag, 0, true, false, false, 24, null);
        }
        for (String flag : CompileCommandsCodecKt.getSTRIP_FLAGS_WITHOUT_ARG()) {
            TokenizedCommandLine.removeTokenGroup$default($this$stripFlags, flag, 0, false, false, false, 28, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isToolchainTool(String exe) {
        String[] stringArray = new String[]{"clang", "clang++", "ar"};
        if (!LexicalFilenameUtilsKt.filenameEndsWithIgnoreCase(exe, stringArray)) return false;
        stringArray = new String[]{"exe", ""};
        if (!LexicalFilenameUtilsKt.hasExtensionIgnoreCase((CharSequence)exe, stringArray)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final String deconflictSourceFiles(@NotNull List<String> sources) {
        String string;
        Object object;
        block3: {
            void var3_3;
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Iterable $this$singleOrNull$iv = sources;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!LexicalFilenameUtilsKt.hasExtensionIgnoreCase((CharSequence)it, "pch"))) continue;
                if (found$iv) {
                    object = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        if ((string = (String)object) == null) {
            string = (String)CollectionsKt.first(sources);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeCompileCommandsJsonBin$lambda$9$writeCommand(Ref.ObjectRef<Throwable> error, CompileCommandsEncoder $encoder, File $sourcesRoot, File $ninjaBuildFile, File compiler, File sourceFile, File objectFile, List<String> flags) {
        if (error.element != null) {
            return;
        }
        try {
            $encoder.writeCompileCommand(sourceFile, compiler, flags, $sourcesRoot, objectFile, "");
        }
        catch (Throwable e) {
            File file = $ninjaBuildFile;
            synchronized (file) {
                boolean bl = false;
                Throwable throwable = (Throwable)error.element;
                if (throwable == null) {
                    throwable = e;
                }
                error.element = throwable;
                Unit unit = Unit.INSTANCE;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<int[], DoubleStringBuilder> writeCompileCommandsJsonBin$lambda$9$popBuffer(List<Pair<int[], DoubleStringBuilder>> buffers) {
        Pair pair;
        List<Pair<int[], DoubleStringBuilder>> list = buffers;
        synchronized (list) {
            Pair pair2;
            boolean bl = false;
            if (buffers.isEmpty()) {
                int[] nArray = new int[]{2048};
                pair2 = TuplesKt.to((Object)nArray, (Object)new DoubleStringBuilder());
            } else {
                pair2 = buffers.remove(0);
            }
            pair = pair2;
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean writeCompileCommandsJsonBin$lambda$9$pushBuffer(List<Pair<int[], DoubleStringBuilder>> buffers, Pair<int[], DoubleStringBuilder> buffer) {
        boolean bl;
        List<Pair<int[], DoubleStringBuilder>> list = buffers;
        synchronized (list) {
            boolean bl2 = false;
            bl = buffers.add(buffer);
        }
        return bl;
    }

    private static final void writeCompileCommandsJsonBin$lambda$9$expandCommandThenWrite$lambda$5$lambda$4$lambda$3(File $compiler, File $source, File $objectFile, List $flags, Ref.ObjectRef $error, CompileCommandsEncoder $encoder, File $sourcesRoot, File $ninjaBuildFile) {
        WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$writeCommand((Ref.ObjectRef<Throwable>)$error, $encoder, $sourcesRoot, $ninjaBuildFile, $compiler, $source, $objectFile, $flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeCompileCommandsJsonBin$lambda$9$expandCommandThenWrite(Ref.ObjectRef<Throwable> error, OsBehavior os, File $ninjaBuildFile, List<Pair<int[], DoubleStringBuilder>> buffers, File $sourcesRoot, ExecutorService writeExecutor, CompileCommandsEncoder $encoder, NinjaBuildUnexpandedCommand unexpanded) {
        if (error.element != null) {
            return;
        }
        try {
            Pair<int[], DoubleStringBuilder> pair = WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$popBuffer(buffers);
            int[] commandLineBuffer = (int[])pair.component1();
            DoubleStringBuilder expansionBuffer = (DoubleStringBuilder)pair.component2();
            String expanded = unexpanded.expandWithResponseFile(expansionBuffer);
            for (String subcommand : os.splitCommandLine(expanded)) {
                if (commandLineBuffer.length <= TokenizedCommandLineKt.minimumSizeOfTokenizeCommandLineBuffer(subcommand)) {
                    commandLineBuffer = TokenizedCommandLineKt.allocateTokenizeCommandLineBuffer(subcommand);
                }
                TokenizedCommandLine tokens = new TokenizedCommandLine(subcommand, false, os.getPlatform(), commandLineBuffer);
                boolean matched = false;
                int n = 2;
                for (int i = 0; i < n; ++i) {
                    String token;
                    int it = i;
                    boolean bl = false;
                    if (tokens.removeNth(0) == null) continue;
                    boolean bl2 = false;
                    if (!WriteCompileCommandsJsonBinKt.isToolchainTool(token)) continue;
                    String input = WriteCompileCommandsJsonBinKt.deconflictSourceFiles(unexpanded.getExplicitInputs());
                    WriteCompileCommandsJsonBinKt.stripFlags(tokens, input);
                    File compiler = new File(token);
                    File source = FilesKt.normalize((File)FilesKt.resolve((File)$sourcesRoot, (String)input));
                    File objectFile = new File(unexpanded.getExplicitOutputs().get(0));
                    List<String> flags = tokens.toTokenList();
                    writeExecutor.execute(() -> WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$expandCommandThenWrite$lambda$5$lambda$4$lambda$3(compiler, source, objectFile, flags, error, $encoder, $sourcesRoot, $ninjaBuildFile));
                    matched = true;
                }
                if (!matched) continue;
            }
            WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$pushBuffer(buffers, (Pair<int[], DoubleStringBuilder>)TuplesKt.to((Object)commandLineBuffer, (Object)expansionBuffer));
        }
        catch (Throwable e) {
            File file = $ninjaBuildFile;
            synchronized (file) {
                boolean bl = false;
                Throwable throwable = (Throwable)error.element;
                if (throwable == null) {
                    throwable = e;
                }
                error.element = throwable;
                Unit unit = Unit.INSTANCE;
            }
            throw e;
        }
    }

    private static final void writeCompileCommandsJsonBin$lambda$9$checkError(Ref.ObjectRef<Throwable> error, ExecutorService parseExecutor, ExecutorService writeExecutor) {
        Throwable throwable = (Throwable)error.element;
        if (throwable == null) {
            return;
        }
        Throwable error2 = throwable;
        parseExecutor.shutdownNow();
        writeExecutor.shutdownNow();
        parseExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        writeExecutor.awaitTermination(500L, TimeUnit.MILLISECONDS);
        throw error2;
    }

    private static final void writeCompileCommandsJsonBin$lambda$9$lambda$8$lambda$7(NinjaBuildUnexpandedCommand $this_streamNinjaBuildCommands, Ref.ObjectRef $error, OsBehavior $os, File $ninjaBuildFile, List $buffers, File $sourcesRoot, ExecutorService $writeExecutor, CompileCommandsEncoder $encoder) {
        WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$expandCommandThenWrite((Ref.ObjectRef<Throwable>)$error, $os, $ninjaBuildFile, $buffers, $sourcesRoot, $writeExecutor, $encoder, $this_streamNinjaBuildCommands);
    }

    private static final Unit writeCompileCommandsJsonBin$lambda$9$lambda$8(ExecutorService $parseExecutor, Ref.ObjectRef $error, OsBehavior $os, File $ninjaBuildFile, List $buffers, File $sourcesRoot, ExecutorService $writeExecutor, CompileCommandsEncoder $encoder, NinjaBuildUnexpandedCommand $this$streamNinjaBuildCommands) {
        Intrinsics.checkNotNullParameter((Object)$this$streamNinjaBuildCommands, (String)"$this$streamNinjaBuildCommands");
        if (!((Collection)$this$streamNinjaBuildCommands.getExplicitOutputs()).isEmpty()) {
            String[] stringArray = new String[]{"o", "pch"};
            if (LexicalFilenameUtilsKt.hasExtensionIgnoreCase((CharSequence)$this$streamNinjaBuildCommands.getExplicitOutputs().get(0), stringArray)) {
                $parseExecutor.execute(() -> WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$lambda$8$lambda$7($this$streamNinjaBuildCommands, $error, $os, $ninjaBuildFile, $buffers, $sourcesRoot, $writeExecutor, $encoder));
            }
        }
        WriteCompileCommandsJsonBinKt.writeCompileCommandsJsonBin$lambda$9$checkError((Ref.ObjectRef<Throwable>)$error, $parseExecutor, $writeExecutor);
        return Unit.INSTANCE;
    }
}

