/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.turboComplete.analysis.usage;

import com.intellij.platform.ml.impl.turboComplete.CompletionKind;
import com.intellij.turboComplete.analysis.usage.KindUsageTracker;
import com.intellij.turboComplete.analysis.usage.RecentUsage;
import com.intellij.turboComplete.analysis.usage.ValuePerPeriod;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\r\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/turboComplete/analysis/usage/KindRecentUsageTracker;", "T", "Lcom/intellij/turboComplete/analysis/usage/KindUsageTracker;", "Lcom/intellij/turboComplete/analysis/usage/ValuePerPeriod;", "kind", "Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;", "windowSize", "", "baseTrackerProvider", "Lkotlin/Function1;", "<init>", "(Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;ILkotlin/jvm/functions/Function1;)V", "getKind", "()Lcom/intellij/platform/ml/impl/turboComplete/CompletionKind;", "getBaseTrackerProvider", "()Lkotlin/jvm/functions/Function1;", "recentUsages", "Ljava/util/Queue;", "Lcom/intellij/turboComplete/analysis/usage/RecentUsage;", "recentCreations", "recentUsagesStatistics", "Ljava/lang/Object;", "popCreationAndFollowingActions", "", "trackRecentUsage", "action", "trackCreated", "trackGenerated", "correct", "", "computeSummary", "()Ljava/lang/Object;", "getSummary", "intellij.turboComplete"})
@SourceDebugExtension(value={"SMAP\nKindRecentUsageTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KindRecentUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindRecentUsageTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1863#2,2:65\n*S KotlinDebug\n*F\n+ 1 KindRecentUsageTracker.kt\ncom/intellij/turboComplete/analysis/usage/KindRecentUsageTracker\n*L\n54#1:65,2\n*E\n"})
public final class KindRecentUsageTracker<T>
implements KindUsageTracker<ValuePerPeriod<T>> {
    @NotNull
    private final CompletionKind kind;
    private final int windowSize;
    @NotNull
    private final Function1<CompletionKind, KindUsageTracker<T>> baseTrackerProvider;
    @NotNull
    private final Queue<RecentUsage<T>> recentUsages;
    private int recentCreations;
    @Nullable
    private T recentUsagesStatistics;

    public KindRecentUsageTracker(@NotNull CompletionKind kind, int windowSize, @NotNull Function1<? super CompletionKind, ? extends KindUsageTracker<T>> baseTrackerProvider) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(baseTrackerProvider, (String)"baseTrackerProvider");
        this.kind = kind;
        this.windowSize = windowSize;
        this.baseTrackerProvider = baseTrackerProvider;
        this.recentUsages = new LinkedList();
    }

    @Override
    @NotNull
    public CompletionKind getKind() {
        return this.kind;
    }

    @NotNull
    public final Function1<CompletionKind, KindUsageTracker<T>> getBaseTrackerProvider() {
        return this.baseTrackerProvider;
    }

    private final void popCreationAndFollowingActions() {
        boolean bl = this.recentUsages.peek().isCreation();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = this.recentUsages.remove().isCreation();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        --this.recentCreations;
        while (!((Collection)this.recentUsages).isEmpty() && !this.recentUsages.peek().isCreation()) {
            this.recentUsages.remove();
        }
    }

    private final void trackRecentUsage(RecentUsage<T> action) {
        this.recentUsagesStatistics = null;
        this.recentUsages.add(action);
        if (action.isCreation()) {
            ++this.recentCreations;
        }
        while (this.recentCreations > this.windowSize) {
            this.popCreationAndFollowingActions();
        }
    }

    @Override
    public void trackCreated() {
        this.trackRecentUsage(new RecentUsage(true, KindRecentUsageTracker::trackCreated$lambda$0));
    }

    @Override
    public void trackGenerated(boolean correct) {
        this.trackRecentUsage(new RecentUsage(false, arg_0 -> KindRecentUsageTracker.trackGenerated$lambda$1(correct, arg_0)));
    }

    private final T computeSummary() {
        KindUsageTracker recentUsagesTracker = (KindUsageTracker)this.baseTrackerProvider.invoke((Object)this.getKind());
        Iterable $this$forEach$iv = this.recentUsages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RecentUsage it = (RecentUsage)element$iv;
            boolean bl = false;
            it.getAction().invoke((Object)recentUsagesTracker);
        }
        return recentUsagesTracker.getSummary();
    }

    @Override
    @NotNull
    public ValuePerPeriod<T> getSummary() {
        if (this.recentUsagesStatistics == null) {
            this.recentUsagesStatistics = this.computeSummary();
        }
        T t = this.recentUsagesStatistics;
        Intrinsics.checkNotNull(t);
        return new ValuePerPeriod<T>(this.recentCreations, t);
    }

    private static final Unit trackCreated$lambda$0(KindUsageTracker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.trackCreated();
        return Unit.INSTANCE;
    }

    private static final Unit trackGenerated$lambda$1(boolean $correct, KindUsageTracker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.trackGenerated($correct);
        return Unit.INSTANCE;
    }
}

