/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.cppGameActivity.src;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u00a8\u0006\u0002"}, d2={"nativeLibCpp", "", "intellij.android.wizardTemplate.impl"})
public final class NativeLibCppKt {
    @NotNull
    public static final String nativeLibCpp() {
        return "\n#include <jni.h>\n\n#include <game-activity/native_app_glue/android_native_app_glue.h>\n#include <game-activity/GameActivity.h>\n\n#include \"AndroidOut.h\"\n#include \"Renderer.h\"\n\nextern \"C\" {\n\n/*!\n * Handles commands sent to this Android application\n * @param pApp the app the commands are coming from\n * @param cmd the command to handle\n */\nvoid handle_cmd(android_app *pApp, int32_t cmd) {\n    switch (cmd) {\n        case APP_CMD_INIT_WINDOW:\n            // A new window is created, associate a renderer with it. You may replace this with a\n            // \"game\" class if that suits your needs. Remember to change all instances of userData\n            // if you change the class here as a reinterpret_cast is dangerous this in the\n            // android_main function and the APP_CMD_TERM_WINDOW handler case.\n            pApp->userData = new Renderer(pApp);\n            break;\n        case APP_CMD_TERM_WINDOW:\n            // The window is being destroyed. Use this to clean up your userData to avoid leaking\n            // resources.\n            //\n            // We have to check if userData is assigned just in case this comes in really quickly\n            if (pApp->userData) {\n                //\n                auto *pRenderer = reinterpret_cast<Renderer *>(pApp->userData);\n                pApp->userData = nullptr;\n                delete pRenderer;\n            }\n            break;\n        default:\n            break;\n    }\n}\n\n/*!\n * Enable the motion events you want to handle; not handled events are\n * passed back to OS for further processing. For this example case,\n * only pointer and joystick devices are enabled.\n *\n * @param motionEvent the newly arrived GameActivityMotionEvent.\n * @return true if the event is from a pointer or joystick device,\n *         false for all other input devices.\n */\nbool motion_event_filter_func(const GameActivityMotionEvent *motionEvent) {\n    auto sourceClass = motionEvent->source & AINPUT_SOURCE_CLASS_MASK;\n    return (sourceClass == AINPUT_SOURCE_CLASS_POINTER ||\n            sourceClass == AINPUT_SOURCE_CLASS_JOYSTICK);\n}\n\n/*!\n * This the main entry point for a native activity\n */\nvoid android_main(struct android_app *pApp) {\n    // Can be removed, useful to ensure your code is running\n    aout << \"Welcome to android_main\" << std::endl;\n\n    // Register an event handler for Android events\n    pApp->onAppCmd = handle_cmd;\n\n    // Set input event filters (set it to NULL if the app wants to process all inputs).\n    // Note that for key inputs, this example uses the default default_key_filter()\n    // implemented in android_native_app_glue.c.\n    android_app_set_motion_event_filter(pApp, motion_event_filter_func);\n\n    // This sets up a typical game/event loop. It will run until the app is destroyed.\n    do {\n        // Process all pending events before running game logic.\n        bool done = false;\n        while (!done) {\n            // 0 is non-blocking.\n            int timeout = 0;\n            int events;\n            android_poll_source *pSource;\n            int result = ALooper_pollOnce(timeout, nullptr, &events,\n                                          reinterpret_cast<void**>(&pSource));\n            switch (result) {\n                case ALOOPER_POLL_TIMEOUT:\n                    [[clang::fallthrough]];\n                case ALOOPER_POLL_WAKE:\n                    // No events occurred before the timeout or explicit wake. Stop checking for events.\n                    done = true;\n                    break;\n                case ALOOPER_EVENT_ERROR:\n                    aout << \"ALooper_pollOnce returned an error\" << std::endl;\n                    break;\n                case ALOOPER_POLL_CALLBACK:\n                    break;\n                default:\n                    if (pSource) {\n                        pSource->process(pApp, pSource);\n                    }\n            }\n        }\n\n        // Check if any user data is associated. This is assigned in handle_cmd\n        if (pApp->userData) {\n            // We know that our user data is a Renderer, so reinterpret cast it. If you change your\n            // user data remember to change it here\n            auto *pRenderer = reinterpret_cast<Renderer *>(pApp->userData);\n\n            // Process game input\n            pRenderer->handleInput();\n\n            // Render a frame\n            pRenderer->render();\n        }\n    } while (!pApp->destroyRequested);\n}\n}\n";
    }
}

