/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.sliceProvider.src.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"sliceProviderJava", "", "className", "packageName", "pathPrefix", "intellij.android.wizardTemplate.impl"})
public final class SliceProviderJavaKt {
    @NotNull
    public static final String sliceProviderJava(@NotNull String className, @NotNull String packageName, @NotNull String pathPrefix) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)pathPrefix, (String)"pathPrefix");
        return "\npackage " + packageName + ";\n\nimport android.content.ContentResolver;\nimport android.content.Context;\nimport android.content.Intent;\nimport android.net.Uri;\n\nimport androidx.annotation.NonNull;\nimport androidx.annotation.Nullable;\nimport androidx.slice.Slice;\nimport androidx.slice.SliceProvider;\nimport androidx.slice.builders.ListBuilder;\nimport androidx.slice.builders.ListBuilder.RowBuilder;\nimport androidx.slice.builders.SliceAction;\n\npublic class " + className + " extends SliceProvider {\n    /**\n     * Instantiate any required objects. Return true if the provider was successfully created,\n     * false otherwise.\n     */\n    @Override\n    public boolean onCreateSliceProvider() {\n        return true;\n    }\n\n    /**\n     * Converts URL to content URI (i.e. content://" + packageName + "...)\n     */\n    @Override\n    @NonNull\n    public Uri onMapIntentToUri(@Nullable Intent intent) {\n        // Note: implementing this is only required if you plan on catching URL requests.\n        // This is an example solution.\n        Uri.Builder uriBuilder = new Uri.Builder().scheme(ContentResolver.SCHEME_CONTENT);\n        if (intent == null) return uriBuilder.build();\n        Uri data = intent.getData();\n        if (data != null && data.getPath() != null) {\n            String path = data.getPath().replace(\"" + pathPrefix + "\", \"\");\n            uriBuilder = uriBuilder.path(path);\n        }\n        Context context = getContext();\n        if (context != null) {\n            uriBuilder = uriBuilder.authority(context.getPackageName());\n        }\n        return uriBuilder.build();\n    }\n\n    /**\n     * Construct the Slice and bind data if available.\n     */\n    public Slice onBindSlice(Uri sliceUri) {\n        Context context = getContext();\n        SliceAction activityAction = createActivityAction();\n        if (context == null || activityAction == null) {\n            return null;\n        }\n        if (\"/\".equals(sliceUri.getPath())) {\n            // Path recognized. Customize the Slice using the androidx.slice.builders API.\n            // Note: ANRs and strict mode is enforced here so don\"t do any heavy operations.\n            // Only bind data that is currently available in memory.\n            return new ListBuilder(getContext(), sliceUri, ListBuilder.INFINITY)\n                    .addRow(\n                        new RowBuilder()\n                            .setTitle(\"URI found.\")\n                            .setPrimaryAction(activityAction)\n                    )\n                    .build();\n        } else {\n            // Error: Path not found.\n            return new ListBuilder(getContext(), sliceUri, ListBuilder.INFINITY)\n                    .addRow(\n                        new RowBuilder()\n                            .setTitle(\"URI not found.\")\n                            .setPrimaryAction(activityAction)\n                    )\n                    .build();\n        }\n    }\n\n    private SliceAction createActivityAction() {\n        return null;\n        //Instead of returning null, you should create a SliceAction. Here is an example:\n        /*\n        return SliceAction.create(\n            PendingIntent.getActivity(\n                getContext(), 0, new Intent(getContext(), MyActivityClass.class), 0\n            ),\n            IconCompat.createWithResource(getContext(), R.drawable.ic_launcher_foreground),\n            ListBuilder.ICON_IMAGE,\n            \"Open App\"\n        );\n        */\n    }\n\n    /**\n     * Slice has been pinned to external process. Subscribe to data source if necessary.\n     */\n    @Override\n    public void onSlicePinned(Uri sliceUri) {\n     // When data is received, call context.contentResolver.notifyChange(sliceUri, null) to\n     // trigger " + className + "#onBindSlice(Uri) again.\n    }\n\n    /**\n     * Unsubscribe from data source if necessary.\n     */\n    @Override\n    public void onSliceUnpinned(Uri sliceUri) {\n        // Remove any observers if necessary to avoid memory leaks.\n    }\n}\n";
    }
}

