/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer.checker;

import kotlin.Metadata;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMap;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"checkDefaultParametersInActualRecursive", "", "actual", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "expectActualMap", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "topLevelExpect", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "ir.actualization"})
public final class IrJavaDirectActualizationDefaultParametersInActualKmpCheckerKt {
    private static final void checkDefaultParametersInActualRecursive(IrClass actual, IrExpectActualMap expectActualMap, IrDiagnosticReporter diagnosticsReporter, IrClassSymbol topLevelExpect) {
        for (IrDeclaration member : actual.getDeclarations()) {
            IrDeclaration irDeclaration = member;
            if (irDeclaration instanceof IrFunction) {
                for (IrValueParameter parameter : ((IrFunction)member).getParameters()) {
                    if (!IrUtilsKt.hasDefaultValue(parameter) || IrUtilsKt.isAnnotationClass(actual)) continue;
                    IrFunction irFunction = (IrFunction)member;
                    IrSymbol irSymbol = expectActualMap.getActualToDirectExpect().get(((IrFunction)member).getSymbol());
                    if (irSymbol == null) {
                        irSymbol = topLevelExpect;
                    }
                    IrActualizerUtilsKt.reportJavaDirectActualizationDefaultParametersInActualFunction(diagnosticsReporter, irFunction, irSymbol);
                }
                continue;
            }
            if (!(irDeclaration instanceof IrClass)) continue;
            IrJavaDirectActualizationDefaultParametersInActualKmpCheckerKt.checkDefaultParametersInActualRecursive((IrClass)member, expectActualMap, diagnosticsReporter, topLevelExpect);
        }
    }

    public static final /* synthetic */ void access$checkDefaultParametersInActualRecursive(IrClass actual, IrExpectActualMap expectActualMap, IrDiagnosticReporter diagnosticsReporter, IrClassSymbol topLevelExpect) {
        IrJavaDirectActualizationDefaultParametersInActualKmpCheckerKt.checkDefaultParametersInActualRecursive(actual, expectActualMap, diagnosticsReporter, topLevelExpect);
    }
}

