/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="FlattenStringConcatenationLowering")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "tryToFold", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "constToString", "", "const", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "normalizeUnsignedValue", "", "Companion", "ir.backend.common"})
public final class FlattenStringConcatenationLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private static final Set<FqName> PARENT_NAMES;

    public FlattenStringConcatenationLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (FlattenStringConcatenationLowering.Companion.isStringConcatenationExpression(expression) || expression instanceof IrCall && FlattenStringConcatenationLowering.Companion.isSpecialToStringCall((IrCall)expression)) {
            IrExpression $this$visitExpression_u24lambda_u240 = expression;
            boolean bl = false;
            irExpression = this.tryToFold(BuildersKt.IrStringConcatenationImpl($this$visitExpression_u24lambda_u240.getStartOffset(), $this$visitExpression_u24lambda_u240.getEndOffset(), $this$visitExpression_u24lambda_u240.getType(), FlattenStringConcatenationLowering.Companion.collectStringConcatenationArguments($this$visitExpression_u24lambda_u240)));
        } else {
            irExpression = expression;
        }
        IrExpression transformedExpression = irExpression;
        IrElementTransformerVoidKt.transformChildrenVoid(transformedExpression, this);
        return transformedExpression;
    }

    private final IrExpression tryToFold(IrStringConcatenation $this$tryToFold) {
        List folded = new ArrayList();
        for (IrExpression next : $this$tryToFold.getArguments()) {
            IrExpression last = (IrExpression)CollectionsKt.lastOrNull((List)folded);
            if (!(next instanceof IrConst)) {
                ((Collection)folded).add(next);
                continue;
            }
            if (!(last instanceof IrConst)) {
                ((Collection)folded).add(IrConstImpl.Companion.string(next.getStartOffset(), next.getEndOffset(), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)next)));
                continue;
            }
            folded.set(folded.size() - 1, IrConstImpl.Companion.string(Math.min(((IrConst)last).getStartOffset(), next.getStartOffset()), Math.max(((IrConst)last).getEndOffset(), next.getEndOffset()), this.context.getIrBuiltIns().getStringType(), this.constToString((IrConst)last) + this.constToString((IrConst)next)));
        }
        Object object = CollectionsKt.singleOrNull((List)folded);
        IrConst irConst = object instanceof IrConst ? (IrConst)object : null;
        return irConst != null ? (IrExpression)irConst : (IrExpression)BuildersKt.IrStringConcatenationImpl($this$tryToFold.getStartOffset(), $this$tryToFold.getEndOffset(), $this$tryToFold.getType(), folded);
    }

    private final String constToString(IrConst irConst) {
        return String.valueOf(this.normalizeUnsignedValue(irConst));
    }

    private final Object normalizeUnsignedValue(IrConst irConst) {
        if (IrTypeUtilsKt.isUnsigned(irConst.getType())) {
            IrConstKind kind = irConst.getKind();
            if (kind instanceof IrConstKind.Byte) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
                return UByte.box-impl((byte)UByte.constructor-impl((byte)((Byte)object)));
            }
            if (kind instanceof IrConstKind.Short) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
                return UShort.box-impl((short)UShort.constructor-impl((short)((Short)object)));
            }
            if (kind instanceof IrConstKind.Int) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                return UInt.box-impl((int)UInt.constructor-impl((int)((Integer)object)));
            }
            if (kind instanceof IrConstKind.Long) {
                Object object = irConst.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                return ULong.box-impl((long)ULong.constructor-impl((long)((Long)object)));
            }
        }
        return irConst.getValue();
    }

    static {
        Object[] objectArray = new FqName[]{StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.string.toSafe()};
        PARENT_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0015\u0010\u000b\u001a\u00020\b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0018\u0010\u000e\u001a\u00020\b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0018\u0010\u000f\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0018\u0010\u0010\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/FlattenStringConcatenationLowering$Companion;", "", "<init>", "()V", "PARENT_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "isStringPlusCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isToString", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Z", "isNullableToString", "isToStringCall", "isSpecialToStringCall", "isStringConcatenationExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "collectStringConcatenationArguments", "", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isStringPlusCall(IrCall $this$isStringPlusCall) {
            IrSimpleFunction function = (IrSimpleFunction)$this$isStringPlusCall.getSymbol().getOwner();
            if (!IrUtilsKt.hasShape$default(function, true, false, 0, 1, null, 22, null)) {
                if (!IrUtilsKt.hasShape$default(function, false, true, 0, 1, null, 21, null)) return false;
            }
            if (!IrTypePredicatesKt.isStringClassType(function.getParameters().get(0).getType())) return false;
            if (!IrTypePredicatesKt.isStringClassType(function.getReturnType())) return false;
            if (!Intrinsics.areEqual((Object)function.getName(), (Object)OperatorNameConventions.PLUS)) return false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function);
            if (!CollectionsKt.contains((Iterable)PARENT_NAMES, (Object)(fqName != null ? fqName.parent() : null))) return false;
            return true;
        }

        public final boolean isToString(@NotNull IrSimpleFunction $this$isToString) {
            Intrinsics.checkNotNullParameter((Object)$this$isToString, (String)"<this>");
            return Intrinsics.areEqual((Object)$this$isToString.getName(), (Object)OperatorNameConventions.TO_STRING) && IrUtilsKt.hasShape$default($this$isToString, true, false, 0, 0, null, 30, null) && IrTypePredicatesKt.isString($this$isToString.getReturnType()) && (IrTypePredicatesKt.isAny($this$isToString.getParameters().get(0).getType()) || !((Collection)$this$isToString.getOverriddenSymbols()).isEmpty());
        }

        private final boolean isNullableToString(IrSimpleFunction $this$isNullableToString) {
            IrFunction irFunction = $this$isNullableToString;
            String string = OperatorNameConventions.TO_STRING.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return IrUtilsKt.isTopLevelInPackage(irFunction, string, StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && IrTypePredicatesKt.isString($this$isNullableToString.getReturnType()) && IrUtilsKt.hasShape$default($this$isNullableToString, false, true, 0, 0, null, 29, null) && IrTypePredicatesKt.isNullableAny($this$isNullableToString.getParameters().get(0).getType());
        }

        private final boolean isToStringCall(IrCall $this$isToStringCall) {
            if ($this$isToStringCall.getSuperQualifierSymbol() != null) {
                return false;
            }
            IrSimpleFunction function = (IrSimpleFunction)$this$isToStringCall.getSymbol().getOwner();
            return this.isToString(function) || this.isNullableToString(function);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSpecialToStringCall(IrCall $this$isSpecialToStringCall) {
            if (!this.isToStringCall($this$isSpecialToStringCall)) return false;
            IrExpression irExpression = $this$isSpecialToStringCall.getDispatchReceiver();
            Object object = irExpression;
            if (irExpression == null) return true;
            IrType irType = ((IrExpression)object).getType();
            object = irType;
            if (irType == null) return true;
            if (IrTypePredicatesKt.isPrimitiveType$default((IrType)object, false, 1, null)) return true;
            return false;
        }

        private final boolean isStringConcatenationExpression(IrExpression expression) {
            return expression instanceof IrStringConcatenation || expression instanceof IrCall && this.isStringPlusCall((IrCall)expression);
        }

        private final List<IrExpression> collectStringConcatenationArguments(IrExpression expression) {
            List arguments = new ArrayList();
            IrVisitorsKt.acceptChildrenVoid((IrElement)expression, new IrVisitorVoid(arguments){
                final /* synthetic */ List<IrExpression> $arguments;
                {
                    this.$arguments = $arguments;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitCall(IrCall expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    if (org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isStringConcatenationExpression(FlattenStringConcatenationLowering.Companion, expression) || org.jetbrains.kotlin.backend.common.lower.FlattenStringConcatenationLowering$Companion.access$isToStringCall(FlattenStringConcatenationLowering.Companion, expression)) {
                        IrVisitorsKt.acceptChildrenVoid((IrElement)expression, this);
                    } else {
                        this.$arguments.add(expression);
                    }
                }

                public void visitStringConcatenation(IrStringConcatenation expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    IrVisitorsKt.acceptChildrenVoid((IrElement)expression, this);
                }

                public void visitExpression(IrExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.$arguments.add(expression);
                }
            });
            return arguments;
        }

        public static final /* synthetic */ boolean access$isToStringCall(Companion $this, IrCall $receiver) {
            return $this.isToStringCall($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

