/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.streams.core.trace.CollectionTreeBuilder;
import com.intellij.debugger.streams.core.trace.DebuggerCommandLauncher;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.trace.impl.JavaDebuggerCommandLauncher;
import com.intellij.debugger.streams.trace.impl.JvmValue;
import com.intellij.debugger.streams.ui.impl.PrimitiveValueDescriptor;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/debugger/streams/ui/impl/JavaCollectionTreeBuilder;", "Lcom/intellij/debugger/streams/core/trace/CollectionTreeBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "nodeManager", "Lcom/intellij/debugger/streams/ui/impl/JavaCollectionTreeBuilder$MyNodeManager;", "createXNamedValue", "Lcom/intellij/xdebugger/frame/XNamedValue;", "value", "Lcom/intellij/debugger/streams/core/trace/Value;", "launcher", "Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;", "getKey", "", "container", "Lcom/intellij/xdebugger/frame/XValueContainer;", "nullMarker", "traceElement", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "isSupported", "", "MyNodeManager", "intellij.java.debugger.streams"})
public final class JavaCollectionTreeBuilder
implements CollectionTreeBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final MyNodeManager nodeManager;

    public JavaCollectionTreeBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.nodeManager = new MyNodeManager(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public XNamedValue createXNamedValue(@Nullable Value value, @NotNull DebuggerCommandLauncher launcher) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        JvmValue jvmValue = value instanceof JvmValue ? (JvmValue)value : null;
        com.sun.jdi.Value jvmValue2 = jvmValue != null ? jvmValue.getValue() : null;
        PrimitiveValueDescriptor valueDescriptor = new PrimitiveValueDescriptor(this.project, jvmValue2);
        return (XNamedValue)new InstanceJavaValue((ValueDescriptorImpl)valueDescriptor, ((JavaDebuggerCommandLauncher)launcher).getContext(), (NodeManagerImpl)this.nodeManager);
    }

    @NotNull
    public Object getKey(@NotNull XValueContainer container, @NotNull Object nullMarker) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)nullMarker, (String)"nullMarker");
        com.sun.jdi.Value jvmValue = ((JavaValue)container).getDescriptor().getValue();
        Object object = jvmValue;
        if (object == null) {
            object = nullMarker;
        }
        return object;
    }

    @NotNull
    public Object getKey(@NotNull TraceElement traceElement, @NotNull Object nullMarker) {
        Intrinsics.checkNotNullParameter((Object)traceElement, (String)"traceElement");
        Intrinsics.checkNotNullParameter((Object)nullMarker, (String)"nullMarker");
        Value value = traceElement.getValue();
        JvmValue jvmValue = value instanceof JvmValue ? (JvmValue)value : null;
        com.sun.jdi.Value jvmValue2 = jvmValue != null ? jvmValue.getValue() : null;
        Object object = jvmValue2;
        if (object == null) {
            object = nullMarker;
        }
        return object;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return (XDebuggerEditorsProvider)new JavaDebuggerEditorsProvider();
    }

    public boolean isSupported(@NotNull XValueContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return container instanceof JavaValue;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/streams/ui/impl/JavaCollectionTreeBuilder$MyNodeManager;", "Lcom/intellij/debugger/ui/impl/watch/NodeManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createNode", "Lcom/intellij/debugger/ui/impl/watch/DebuggerTreeNodeImpl;", "descriptor", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "createMessageNode", "Lcom/intellij/debugger/ui/impl/watch/MessageDescriptor;", "message", "", "intellij.java.debugger.streams"})
    private static final class MyNodeManager
    extends NodeManagerImpl {
        public MyNodeManager(@Nullable Project project) {
            super(project, null);
        }

        @NotNull
        public DebuggerTreeNodeImpl createNode(@NotNull NodeDescriptor descriptor, @NotNull EvaluationContext evaluationContext) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(@NotNull MessageDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return new DebuggerTreeNodeImpl(null, (NodeDescriptor)descriptor);
        }

        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new DebuggerTreeNodeImpl(null, (NodeDescriptor)new MessageDescriptor(message));
        }
    }
}

