/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.IntentionUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ConvertLambdaToClosureIntention;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "lambda", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "closureText", "intellij.groovy.psi"})
public final class ConvertLambdaToClosureIntention
extends PsiUpdateModCommandAction<GrLambdaExpression> {
    public ConvertLambdaToClosureIntention(@NotNull GrLambdaExpression lambda) {
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        super((PsiElement)lambda);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("action.convert.lambda.to.closure", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull GrLambdaExpression lambda, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        String string = this.closureText(lambda);
        if (string == null) {
            return;
        }
        String closureText = string;
        GrClosableBlock grClosableBlock = GroovyPsiElementFactory.getInstance(context.project()).createClosureFromText(closureText);
        Intrinsics.checkNotNullExpressionValue((Object)grClosableBlock, (String)"createClosureFromText(...)");
        GrClosableBlock closure = grClosableBlock;
        lambda.replaceWithExpression(closure, false);
    }

    private final String closureText(GrLambdaExpression lambda) {
        GrParameterList grParameterList = lambda.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"getParameterList(...)");
        GrParameterList parameterList = grParameterList;
        GrLambdaBody grLambdaBody = lambda.getBody();
        if (grLambdaBody == null) {
            return null;
        }
        GrLambdaBody body = grLambdaBody;
        StringBuilder closureText = new StringBuilder();
        closureText.append("{");
        if (parameterList.getParametersCount() != 0) {
            String string = parameterList.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            IntentionUtilKt.appendTextBetween(closureText, string, parameterList.getLParen(), parameterList.getRParen());
        }
        IntentionUtilKt.appendElements(closureText, parameterList, body);
        if (body instanceof GrBlockLambdaBody) {
            String string = ((GrBlockLambdaBody)body).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            IntentionUtilKt.appendTextBetween(closureText, string, ((GrBlockLambdaBody)body).getLBrace(), ((GrBlockLambdaBody)body).getRBrace());
        } else {
            closureText.append(body.getText());
        }
        closureText.append("}");
        return closureText.toString();
    }
}

