/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class CreateMethodFromUsageFix
extends GrCreateFromUsageBaseFix
implements IntentionAction {
    public CreateMethodFromUsageFix(@NotNull GrReferenceExpression refExpression) {
        if (refExpression == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(0);
        }
        super(refExpression);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.method.from.usage.family.name", new Object[0]);
        if (string == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.method.from.usage", this.getMethodName());
        if (string == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List<PsiClass> classes;
        if (project == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(5);
        }
        if ((classes = this.getTargetClasses()).isEmpty()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateMethodFromUsageFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        Data data = this.generateMethod(classes.get(0), true);
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, "", data.method.getText());
    }

    @Override
    protected final void invokeImpl(Project project, @NotNull PsiClass targetClass) {
        if (targetClass == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(7);
        }
        Data data = this.generateMethod(targetClass, false);
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)this.getRefExpr(), (Class[])new Class[]{PsiClass.class, PsiMethod.class, PsiFile.class});
        IntentionUtils.createTemplateForMethod(data.paramTypesExpressions, data.method, targetClass, data.constraints, false, context);
    }

    private Data generateMethod(@NotNull PsiClass targetClass, boolean readOnly) {
        if (targetClass == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(8);
        }
        JVMElementFactory factory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        assert (factory != null);
        PsiMethod method = factory.createMethod(this.getMethodName(), (PsiType)PsiTypes.voidType());
        GrReferenceExpression ref2 = this.getRefExpr();
        if (GrStaticChecker.isInStaticContext(ref2, targetClass)) {
            method.getModifierList().setModifierProperty("static", true);
        }
        PsiType[] argTypes = this.getArgumentTypes();
        assert (argTypes != null);
        ChooseTypeExpression[] paramTypesExpressions = this.setupParams(method, argTypes, factory);
        TypeConstraint[] constraints = this.getReturnTypeConstraints();
        PsiGenerationInfo info = OverrideImplementUtil.createGenerationInfo((PsiMethod)method);
        if (!readOnly) {
            info.insert(targetClass, this.findInsertionAnchor((PsiGenerationInfo<PsiMethod>)info, targetClass), false);
        }
        method = (PsiMethod)info.getPsiMember();
        if (this.shouldBeAbstract(targetClass)) {
            method.getBody().delete();
            if (!targetClass.isInterface()) {
                method.getModifierList().setModifierProperty("abstract", true);
            }
        }
        return new Data(paramTypesExpressions, method, constraints);
    }

    protected TypeConstraint @NotNull [] getReturnTypeConstraints() {
        TypeConstraint[] typeConstraintArray = GroovyExpectedTypesProvider.calculateTypeConstraints((GrExpression)this.getRefExpr().getParent());
        if (typeConstraintArray == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(9);
        }
        return typeConstraintArray;
    }

    protected PsiType[] getArgumentTypes() {
        return PsiUtil.getArgumentTypes(this.getRefExpr(), false);
    }

    @NotNull
    protected String getMethodName() {
        String string = this.getRefExpr().getReferenceName();
        if (string == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean shouldBeAbstract(PsiClass aClass) {
        return aClass.isInterface() && !GrTraitUtil.isTrait(aClass);
    }

    @Nullable
    private PsiElement findInsertionAnchor(PsiGenerationInfo<PsiMethod> info, PsiClass targetClass) {
        PsiClass parent;
        Object object = parent = targetClass instanceof GroovyScriptClass ? ((GroovyScriptClass)targetClass).getContainingFile() : targetClass;
        if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)this.getRefExpr(), (boolean)false)) {
            return info.findInsertionAnchor(targetClass, (PsiElement)this.getRefExpr());
        }
        return null;
    }

    private ChooseTypeExpression @NotNull [] setupParams(@NotNull PsiMethod method, PsiType @NotNull [] argTypes, @NotNull JVMElementFactory factory) {
        if (method == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(11);
        }
        if (factory == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(12);
        }
        if (argTypes == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(13);
        }
        PsiParameterList parameterList = method.getParameterList();
        ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
        for (int i2 = 0; i2 < argTypes.length; ++i2) {
            PsiType argType = TypesUtil.unboxPrimitiveTypeWrapper(argTypes[i2]);
            if (argType == null || argType == PsiTypes.nullType()) {
                argType = TypesUtil.getJavaLangObject(this.getRefExpr());
            }
            PsiParameter p = factory.createParameter("o", argType);
            parameterList.add((PsiElement)p);
            TypeConstraint[] constraints = new TypeConstraint[]{SupertypeConstraint.create(argType)};
            boolean isGroovy = method.getLanguage() == GroovyLanguage.INSTANCE;
            paramTypesExpressions[i2] = new ChooseTypeExpression(constraints, method.getManager(), method.getResolveScope(), isGroovy);
        }
        if (paramTypesExpressions == null) {
            CreateMethodFromUsageFix.$$$reportNull$$$0(14);
        }
        return paramTypesExpressions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 9, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateMethodFromUsageFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/CreateMethodFromUsageFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeConstraints";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setupParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateMethod";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupParams";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 9, 10, 14 -> new IllegalStateException(string);
        };
    }

    private static class Data {
        ChooseTypeExpression[] paramTypesExpressions;
        PsiMethod method;
        TypeConstraint[] constraints;

        private Data(ChooseTypeExpression[] paramTypesExpression, PsiMethod method, TypeConstraint[] constraints) {
            this.paramTypesExpressions = paramTypesExpression;
            this.method = method;
            this.constraints = constraints;
        }
    }
}

