/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/IncDecUnaryTransformation;", "Lorg/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation;", "operator", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "needParentheses", "", "methodCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "options", "Lorg/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$Options;", "couldApplyInternal", "apply", "", "intellij.groovy.psi"})
public final class IncDecUnaryTransformation
extends Transformation {
    @NotNull
    private final IElementType operator;

    public IncDecUnaryTransformation(@NotNull IElementType operator) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        this.operator = operator;
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return false;
    }

    @Override
    protected boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        GrExpression grExpression = Transformation.getBase(methodCall);
        if (grExpression == null) {
            return false;
        }
        GrExpression base = grExpression;
        if (!this.checkArgumentsCount(methodCall, 0)) {
            return false;
        }
        PsiElement psiElement = methodCall.getParent();
        GrAssignmentExpression grAssignmentExpression = psiElement instanceof GrAssignmentExpression ? (GrAssignmentExpression)psiElement : null;
        if (grAssignmentExpression == null) {
            return false;
        }
        GrAssignmentExpression assignment = grAssignmentExpression;
        if (assignment.getRValue() != methodCall) {
            return false;
        }
        return EquivalenceChecker.expressionsAreEquivalent(assignment.getLValue(), base);
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        GrExpression grExpression = Transformation.getBase(methodCall);
        if (grExpression == null) {
            return;
        }
        GrExpression base = grExpression;
        PsiElement psiElement = methodCall.getParent();
        GrAssignmentExpression grAssignmentExpression = psiElement instanceof GrAssignmentExpression ? (GrAssignmentExpression)psiElement : null;
        if (grAssignmentExpression == null) {
            return;
        }
        GrAssignmentExpression parent = grAssignmentExpression;
        GrInspectionUtil.replaceExpression(parent, this.operator + base.getText());
    }
}

