/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/BinaryExpressionHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "reference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyCallReference;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "ambiguousMethodMessage", "", "getAmbiguousMethodMessage", "()Ljava/lang/String;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "buildCastFix", "Lorg/jetbrains/plugins/groovy/codeInspection/assignment/GrCastFix;", "argument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ExpressionArgument;", "expectedType", "Lcom/intellij/psi/PsiType;", "highlight", "", "intellij.groovy.psi"})
public final class BinaryExpressionHighlighter
extends CallReferenceHighlighter {
    @NotNull
    private final GrBinaryExpression expression;

    public BinaryExpressionHighlighter(@NotNull GrBinaryExpression expression, @NotNull GroovyCallReference reference, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super(reference, sink);
        this.expression = expression;
    }

    @Override
    @NotNull
    protected String getAmbiguousMethodMessage() {
        String string = GroovyBundle.message("operator.call.is.ambiguous", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected PsiElement getHighlightElement() {
        PsiElement psiElement = this.expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperationToken(...)");
        return psiElement;
    }

    @Nullable
    protected GrCastFix buildCastFix(@NotNull ExpressionArgument argument, @NotNull PsiType expectedType) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        List<Argument> list = this.getReference().getArguments();
        if (list == null) {
            return null;
        }
        List<Argument> arguments2 = list;
        if (!arguments2.contains(argument)) {
            return null;
        }
        Object[] objectArray = new Object[]{expectedType.getPresentableText()};
        String string = GroovyBundle.message("intention.name.cast.operand.to.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String name = string;
        return new GrCastFix(expectedType, argument.getExpression(), true, name);
    }

    public final void highlight() {
        if (PsiUtilKt.isFake(this.expression)) {
            return;
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(this.expression)) {
            return;
        }
        GroovyCallReference groovyCallReference = this.expression.getReference();
        if (groovyCallReference == null) {
            return;
        }
        GroovyCallReference reference = groovyCallReference;
        GroovyResolveResult groovyResolveResult = reference.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        GroovyResolveResult resolveResult = groovyResolveResult;
        if (GroovyTypeCheckVisitorHelper.isOperatorWithSimpleTypes(this.expression, resolveResult)) {
            return;
        }
        this.highlightMethodApplicability();
    }
}

