/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.debugger.GroovyStackFrame;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.stubs.GroovyShortNamesCache;

public class GroovyPositionManager
extends PositionManagerEx {
    private static final Logger LOG = Logger.getInstance(PositionManagerImpl.class);
    private final DebugProcess myDebugProcess;
    private static final Set<FileType> ourFileTypes = Collections.singleton(GroovyFileType.GROOVY_FILE_TYPE);

    public GroovyPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List list;
        if (type == null) {
            GroovyPositionManager.$$$reportNull$$$0(0);
        }
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(1);
        }
        GroovyPositionManager.checkGroovyFile(position);
        try {
            int line;
            List locations;
            if (LOG.isDebugEnabled()) {
                LOG.debug("locationsOfLine: " + type + "; " + position);
            }
            if ((locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (String)"Java", null, (int)(line = position.getLine() + 1))) == null || locations.isEmpty()) {
                throw NoDataException.INSTANCE;
            }
            list = locations;
        }
        catch (AbsentInformationException e) {
            throw NoDataException.INSTANCE;
        }
        if (list == null) {
            GroovyPositionManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
        if (context == null) {
            GroovyPositionManager.$$$reportNull$$$0(3);
        }
        if (frame == null) {
            GroovyPositionManager.$$$reportNull$$$0(4);
        }
        if (location == null) {
            GroovyPositionManager.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            GroovyPositionManager.$$$reportNull$$$0(6);
        }
        return ThreeState.UNSURE;
    }

    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameDescriptorImpl descriptor) {
        if (descriptor == null) {
            GroovyPositionManager.$$$reportNull$$$0(7);
        }
        if (GroovyPositionManager.isInGroovyFile(descriptor.getLocation()) != ThreeState.YES) {
            return null;
        }
        return new GroovyStackFrame(descriptor, true);
    }

    private static ThreeState isInGroovyFile(@Nullable Location location) {
        if (location != null) {
            ReferenceType refType = location.declaringType();
            try {
                LanguageFileType languageFileType;
                String safeName = refType.sourceName();
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(safeName);
                if (fileType == UnknownFileType.INSTANCE) {
                    return ThreeState.UNSURE;
                }
                if (fileType instanceof LanguageFileType && (languageFileType = (LanguageFileType)fileType).getLanguage() == GroovyLanguage.INSTANCE) {
                    return ThreeState.YES;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return ThreeState.NO;
    }

    @Nullable
    private static GroovyPsiElement findReferenceTypeSourceImage(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        if (element == null) {
            return null;
        }
        return GroovyPositionManager.getEnclosingPsiForElement(element);
    }

    private static GroovyPsiElement getEnclosingPsiForElement(PsiElement element) {
        GroovyPsiElement parent;
        while ((parent = (GroovyPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrSwitchExpression.class, GrFunctionalExpression.class, GrTypeDefinition.class})) instanceof GrSwitchElement && PsiUtil.isPlainSwitchStatement((GrSwitchElement)parent)) {
            element = parent;
        }
        return parent;
    }

    @Nullable
    private static PsiClass findEnclosingTypeDefinition(SourcePosition position) {
        PsiFile file = position.getFile();
        if (!(file instanceof GroovyFileBase)) {
            return null;
        }
        PsiElement element = file.findElementAt(position.getOffset());
        do {
            if (!((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrTypeDefinition.class, GroovyFileBase.class})) instanceof GroovyFileBase)) continue;
            return ((GroovyFileBase)element).getScriptClass();
        } while (!(element instanceof GrTypeDefinition) || ((GrTypeDefinition)element).isAnonymous());
        return (GrTypeDefinition)element;
    }

    private static void checkGroovyFile(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(8);
        }
        if (!(position.getFile() instanceof GroovyFileBase)) {
            throw NoDataException.INSTANCE;
        }
    }

    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            GroovyPositionManager.$$$reportNull$$$0(9);
        }
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(10);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPrepareRequest: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        String qName = GroovyPositionManager.getOuterClassName(position);
        if (qName != null) {
            return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, qName);
        }
        qName = GroovyPositionManager.findEnclosingName(position);
        if (qName == null) {
            throw NoDataException.INSTANCE;
        }
        ClassPrepareRequestor waitRequestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                if (!positionManager.locationsOfLine(referenceType, position).isEmpty()) {
                    requestor.processClassPrepare(debuggerProcess, referenceType);
                }
            }
        };
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(waitRequestor, qName + "$*");
    }

    @Nullable
    private static String findEnclosingName(@NotNull SourcePosition position) {
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(11);
        }
        return (String)ReadAction.compute(() -> {
            PsiClass typeDefinition = GroovyPositionManager.findEnclosingTypeDefinition(position);
            if (typeDefinition != null) {
                return GroovyPositionManager.getClassNameForJvm(typeDefinition);
            }
            return GroovyPositionManager.getScriptQualifiedName(position);
        });
    }

    @Nullable
    private static String getOuterClassName(SourcePosition position) {
        return (String)ReadAction.compute(() -> {
            GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
            if (sourceImage instanceof GrTypeDefinition) {
                return GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
            }
            if (sourceImage == null) {
                return GroovyPositionManager.getScriptQualifiedName(position);
            }
            return null;
        });
    }

    @Nullable
    private static String getClassNameForJvm(@NotNull PsiClass typeDefinition) {
        String qname;
        if (typeDefinition == null) {
            GroovyPositionManager.$$$reportNull$$$0(12);
        }
        String suffix = typeDefinition instanceof GrTypeDefinition && ((GrTypeDefinition)typeDefinition).isTrait() ? "$Trait$Helper" : "";
        PsiClass psiClass = typeDefinition.getContainingClass();
        if (psiClass != null) {
            String parent = GroovyPositionManager.getClassNameForJvm(psiClass);
            return parent == null ? null : parent + "$" + typeDefinition.getName() + suffix;
        }
        PsiFile file = typeDefinition.getContainingFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String s;
                String string = s = helper.isAppropriateScriptFile((GroovyFile)file) ? helper.customizeClassName(typeDefinition) : null;
                if (s == null) continue;
                return s;
            }
        }
        return (qname = typeDefinition.getQualifiedName()) == null ? null : qname + suffix;
    }

    @Nullable
    private static String getScriptQualifiedName(@NotNull SourcePosition position) {
        PsiFile file;
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(13);
        }
        if ((file = position.getFile()) instanceof GroovyFile) {
            return GroovyPositionManager.getScriptFQName((GroovyFile)file);
        }
        return null;
    }

    public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
        PsiFile psiFile;
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        if (GroovyPositionManager.isInGroovyFile(location) == ThreeState.NO) {
            throw NoDataException.INSTANCE;
        }
        int lineNumber = this.calcLineIndex(location);
        if (lineNumber < 0) {
            throw NoDataException.INSTANCE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSourcePosition: " + location);
        }
        if ((psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location)) == null) {
            throw NoDataException.INSTANCE;
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    private int calcLineIndex(Location location) {
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return -1;
        }
        return DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
    }

    @Nullable
    private PsiFile getPsiFileByLocation(@NotNull Project project, @Nullable Location location) {
        if (project == null) {
            GroovyPositionManager.$$$reportNull$$$0(14);
        }
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name().replace('/', '.');
        int dollar = originalQName.indexOf(36);
        String runtimeName = dollar >= 0 ? originalQName.substring(0, dollar) : originalQName;
        String qName = GroovyPositionManager.getOriginalQualifiedName(refType, runtimeName);
        GlobalSearchScope searchScope = this.myDebugProcess.getSearchScope();
        GroovyShortNamesCache cache2 = GroovyShortNamesCache.getGroovyShortNamesCache(project);
        try {
            List<PsiClass> classes = cache2.getClassesByFQName(qName, searchScope, true);
            if (classes.isEmpty()) {
                classes = cache2.getClassesByFQName(qName, searchScope, false);
            }
            if (classes.isEmpty()) {
                classes = cache2.getClassesByFQName(qName, GlobalSearchScope.projectScope((Project)project), false);
            }
            if (classes.isEmpty()) {
                classes = cache2.getClassesByFQName(qName, GroovyPositionManager.addModuleContent(searchScope), false);
            }
            if (!classes.isEmpty()) {
                classes.sort(PsiClassUtil.createScopeComparator((GlobalSearchScope)searchScope));
                PsiClass clazz = classes.get(0);
                if (clazz != null) {
                    return clazz.getContainingFile();
                }
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            return null;
        }
        return GroovyPositionManager.getExtraScriptIfNotFound(project, refType, runtimeName, searchScope);
    }

    @Nullable
    private static PsiFile getExtraScriptIfNotFound(@NotNull Project project, @NotNull ReferenceType refType, @NotNull String runtimeName, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            GroovyPositionManager.$$$reportNull$$$0(15);
        }
        if (refType == null) {
            GroovyPositionManager.$$$reportNull$$$0(16);
        }
        if (runtimeName == null) {
            GroovyPositionManager.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            GroovyPositionManager.$$$reportNull$$$0(18);
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            PsiFile file;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (file = helper.getExtraScriptIfNotFound(refType, runtimeName, project, searchScope)) == null) continue;
            return file;
        }
        return null;
    }

    private static GlobalSearchScope addModuleContent(GlobalSearchScope scope) {
        Module module;
        if (scope instanceof ModuleWithDependenciesScope && !(module = ((ModuleWithDependenciesScope)scope).getModule()).isDisposed()) {
            return scope.uniteWith(module.getModuleContentWithDependenciesScope());
        }
        return scope;
    }

    private static String getOriginalQualifiedName(@NotNull ReferenceType refType, @NotNull String runtimeName) {
        if (refType == null) {
            GroovyPositionManager.$$$reportNull$$$0(19);
        }
        if (runtimeName == null) {
            GroovyPositionManager.$$$reportNull$$$0(20);
        }
        for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
            String originalScriptName;
            if (!helper.isAppropriateRuntimeName(runtimeName) || (originalScriptName = helper.getOriginalScriptName(refType, runtimeName)) == null) continue;
            return originalScriptName;
        }
        return runtimeName;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            GroovyPositionManager.$$$reportNull$$$0(21);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses: " + position);
        }
        GroovyPositionManager.checkGroovyFile(position);
        List result2 = (List)ReadAction.compute(() -> {
            GroovyPsiElement sourceImage = GroovyPositionManager.findReferenceTypeSourceImage(position);
            if (sourceImage instanceof GrTypeDefinition && !((GrTypeDefinition)sourceImage).isAnonymous()) {
                String qName = GroovyPositionManager.getClassNameForJvm((GrTypeDefinition)sourceImage);
                if (qName != null) {
                    return this.myDebugProcess.getVirtualMachineProxy().classesByName(qName);
                }
            } else if (sourceImage == null) {
                String scriptName = GroovyPositionManager.getScriptQualifiedName(position);
                if (scriptName != null) {
                    return this.myDebugProcess.getVirtualMachineProxy().classesByName(scriptName);
                }
            } else {
                String enclosingName = GroovyPositionManager.findEnclosingName(position);
                if (enclosingName == null) {
                    return null;
                }
                List outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(enclosingName);
                ArrayList<ReferenceType> result1 = new ArrayList<ReferenceType>(outers.size());
                for (ReferenceType outer : outers) {
                    ReferenceType nested = this.findNested(outer, sourceImage, position);
                    if (nested == null) continue;
                    result1.add(nested);
                }
                return result1;
            }
            return null;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAllClasses = " + result2);
        }
        if (result2 == null) {
            throw NoDataException.INSTANCE;
        }
        List list = result2;
        if (list == null) {
            GroovyPositionManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Nullable
    private static String getScriptFQName(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            GroovyPositionManager.$$$reportNull$$$0(23);
        }
        String packageName = groovyFile.getPackageName();
        String fileName = GroovyPositionManager.getRuntimeScriptName(groovyFile);
        return StringUtil.getQualifiedName((String)packageName, (String)fileName);
    }

    @NotNull
    private static String getRuntimeScriptName(@NotNull GroovyFile groovyFile) {
        if (groovyFile == null) {
            GroovyPositionManager.$$$reportNull$$$0(24);
        }
        if (groovyFile.isScript()) {
            for (ScriptPositionManagerHelper helper : (ScriptPositionManagerHelper[])ScriptPositionManagerHelper.EP_NAME.getExtensions()) {
                String runtimeScriptName;
                if (!helper.isAppropriateScriptFile(groovyFile) || (runtimeScriptName = helper.getRuntimeScriptName(groovyFile)) == null) continue;
                String string = runtimeScriptName;
                if (string == null) {
                    GroovyPositionManager.$$$reportNull$$$0(25);
                }
                return string;
            }
        }
        VirtualFile vFile = groovyFile.getVirtualFile();
        assert (vFile != null);
        String string = vFile.getNameWithoutExtension();
        if (string == null) {
            GroovyPositionManager.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, GroovyPsiElement toFind, SourcePosition classPosition) {
        VirtualMachineProxy vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            List nestedTypes = vmProxy.nestedTypes(fromClass);
            for (ReferenceType nested : nestedTypes) {
                ReferenceType found = this.findNested(nested, toFind, classPosition);
                if (found == null) continue;
                return found;
            }
            try {
                int lineNumber = classPosition.getLine() + 1;
                if (!DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)fromClass, (int)lineNumber).isEmpty()) {
                    return fromClass;
                }
                Iterator iterator2 = DebuggerUtilsAsync.allLineLocationsSync((ReferenceType)fromClass).iterator();
                if (iterator2.hasNext()) {
                    Location location = (Location)iterator2.next();
                    SourcePosition candidateFirstPosition = SourcePosition.createFromLine((PsiFile)toFind.getContainingFile(), (int)(location.lineNumber() - 1));
                    if (toFind.equals(GroovyPositionManager.findReferenceTypeSourceImage(candidateFirstPosition))) {
                        return fromClass;
                    }
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        HashSet<FileType> result2 = new HashSet<FileType>();
        ScriptPositionManagerHelper.EP_NAME.forEachExtensionSafe(ext -> result2.addAll(ext.getAcceptedFileTypes()));
        result2.addAll(ourFileTypes);
        HashSet<FileType> hashSet = result2;
        if (hashSet == null) {
            GroovyPositionManager.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 22, 25, 26, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/debugger/GroovyPositionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeScriptName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 2: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrame";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkGroovyFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassNameForJvm";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScriptQualifiedName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileByLocation";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getExtraScriptIfNotFound";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalQualifiedName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFQName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeScriptName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 22, 25, 26, 27 -> new IllegalStateException(string);
        };
    }
}

