/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.ext.ExtKt;
import android.databinding.tool.reflection.ImportBag;
import android.databinding.tool.reflection.InjectedField;
import android.databinding.tool.reflection.InjectedMethod;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.util.StringUtils;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003J\u0010\u0010@\u001a\u00020;2\u0006\u0010A\u001a\u00020\u000bH\u0002J\u000e\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020\tJ\b\u0010D\u001a\u00020\u0003H\u0016J\b\u0010E\u001a\u00020\u0000H\u0016J\b\u0010F\u001a\u00020\u0000H\u0016J\u0012\u0010G\u001a\u00020\r2\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010I\u001a\u00020\u0000H\u0016J\b\u0010J\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0014\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0016\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u0014\u0010\u0018\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u001b\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR\u0014\u0010\u001c\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u001c\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR\u0014\u0010\"\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u0014\u0010#\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000eR\u0014\u0010$\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u001b\u0010%\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b%\u0010\u000eR\u001b\u0010(\u001a\u00020\u00018VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010'\u001a\u0004\b)\u0010\u0011R\u001b\u0010+\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010'\u001a\u0004\b,\u0010-R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010 R\u001a\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010 R\u001b\u00105\u001a\u0002068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010'\u001a\u0004\b7\u00108\u00a8\u0006K"}, d2={"Landroid/databinding/tool/reflection/InjectedClass;", "Landroid/databinding/tool/reflection/ModelClass;", "mClassName", "", "mSuperClass", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "mMethods", "Ljava/util/ArrayList;", "Landroid/databinding/tool/reflection/InjectedMethod;", "mFields", "Landroid/databinding/tool/reflection/InjectedField;", "isArray", "", "()Z", "componentType", "getComponentType", "()Landroid/databinding/tool/reflection/ModelClass;", "isNullable", "isPrimitive", "isBoolean", "isChar", "isByte", "isShort", "isInt", "isLong", "isFloat", "isDouble", "isGeneric", "typeArguments", "", "getTypeArguments", "()Ljava/util/List;", "isTypeVar", "isWildcard", "isInterface", "isVoid", "isObservable", "isObservable$delegate", "Lkotlin/Lazy;", "superclass", "getSuperclass", "superclass$delegate", "jniDescription", "getJniDescription", "()Ljava/lang/String;", "jniDescription$delegate", "allFields", "Landroid/databinding/tool/reflection/ModelField;", "getAllFields", "allMethods", "Landroid/databinding/tool/reflection/ModelMethod;", "getAllMethods", "typeName", "Lcom/squareup/javapoet/TypeName;", "getTypeName", "()Lcom/squareup/javapoet/TypeName;", "typeName$delegate", "addVariable", "", "name", "type", "imports", "Landroid/databinding/tool/reflection/ImportBag;", "addField", "field", "addMethod", "method", "toJavaCode", "unbox", "box", "isAssignableFrom", "that", "erasure", "toString", "db-compiler"})
public final class InjectedClass
extends ModelClass {
    @NotNull
    private final String mClassName;
    @NotNull
    private final String mSuperClass;
    @NotNull
    private final ArrayList<InjectedMethod> mMethods;
    @NotNull
    private final ArrayList<InjectedField> mFields;
    private final boolean isArray;
    @Nullable
    private final ModelClass componentType;
    private final boolean isNullable;
    private final boolean isPrimitive;
    private final boolean isBoolean;
    private final boolean isChar;
    private final boolean isByte;
    private final boolean isShort;
    private final boolean isInt;
    private final boolean isLong;
    private final boolean isFloat;
    private final boolean isDouble;
    private final boolean isGeneric;
    @Nullable
    private final List<ModelClass> typeArguments;
    private final boolean isTypeVar;
    private final boolean isWildcard;
    private final boolean isInterface;
    private final boolean isVoid;
    @NotNull
    private final Lazy isObservable$delegate;
    @NotNull
    private final Lazy superclass$delegate;
    @NotNull
    private final Lazy jniDescription$delegate;
    @NotNull
    private final Lazy typeName$delegate;

    public InjectedClass(@NotNull String mClassName, @NotNull String mSuperClass) {
        Intrinsics.checkNotNullParameter((Object)mClassName, (String)"mClassName");
        Intrinsics.checkNotNullParameter((Object)mSuperClass, (String)"mSuperClass");
        this.mClassName = mClassName;
        this.mSuperClass = mSuperClass;
        this.mMethods = new ArrayList();
        this.mFields = new ArrayList();
        this.isNullable = true;
        this.isObservable$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> InjectedClass.isObservable_delegate$lambda$0(this));
        this.superclass$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> InjectedClass.superclass_delegate$lambda$1(this));
        this.jniDescription$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> InjectedClass.jniDescription_delegate$lambda$2(this));
        this.typeName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> InjectedClass.typeName_delegate$lambda$3(this));
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    @Nullable
    public ModelClass getComponentType() {
        return this.componentType;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    @Override
    public boolean isBoolean() {
        return this.isBoolean;
    }

    @Override
    public boolean isChar() {
        return this.isChar;
    }

    @Override
    public boolean isByte() {
        return this.isByte;
    }

    @Override
    public boolean isShort() {
        return this.isShort;
    }

    @Override
    public boolean isInt() {
        return this.isInt;
    }

    @Override
    public boolean isLong() {
        return this.isLong;
    }

    @Override
    public boolean isFloat() {
        return this.isFloat;
    }

    @Override
    public boolean isDouble() {
        return this.isDouble;
    }

    @Override
    public boolean isGeneric() {
        return this.isGeneric;
    }

    @Override
    @Nullable
    public List<ModelClass> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public boolean isTypeVar() {
        return this.isTypeVar;
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isVoid() {
        return this.isVoid;
    }

    @Override
    public boolean isObservable() {
        Lazy lazy = this.isObservable$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public ModelClass getSuperclass() {
        Lazy lazy = this.superclass$delegate;
        return (ModelClass)lazy.getValue();
    }

    @Override
    @NotNull
    public String getJniDescription() {
        Lazy lazy = this.jniDescription$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public List<ModelField> getAllFields() {
        return CollectionsKt.plus((Collection)this.getSuperclass().getAllFields(), (Iterable)this.mFields);
    }

    @Override
    @NotNull
    public List<ModelMethod> getAllMethods() {
        return CollectionsKt.plus((Collection)this.getSuperclass().getAllMethods(), (Iterable)this.mMethods);
    }

    @Override
    @NotNull
    public TypeName getTypeName() {
        Lazy lazy = this.typeName$delegate;
        return (TypeName)lazy.getValue();
    }

    public final void addVariable(@NotNull String name, @NotNull String type, @NotNull ImportBag imports) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)imports, (String)"imports");
        String capName = StringUtils.capitalize(name);
        StringBuilder stringBuilder = new StringBuilder().append("set");
        String string = capName;
        Intrinsics.checkNotNull((Object)string);
        String setName = stringBuilder.append(string).toString();
        String getName = "get" + capName;
        this.addMethod(new InjectedMethod(this, false, getName, imports, type, new String[0]));
        String[] stringArray = new String[]{type};
        this.addMethod(new InjectedMethod(this, false, setName, imports, "void", stringArray));
    }

    public final void addField(@NotNull String name, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.addField(new InjectedField(name, type));
    }

    private final void addField(InjectedField field) {
        this.mFields.add(field);
    }

    public final void addMethod(@NotNull InjectedMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.mMethods.add(method);
    }

    @Override
    @NotNull
    public String toJavaCode() {
        return this.mClassName;
    }

    @Override
    @NotNull
    public InjectedClass unbox() {
        return this;
    }

    @Override
    @NotNull
    public InjectedClass box() {
        return this;
    }

    @Override
    public boolean isAssignableFrom(@Nullable ModelClass that) {
        for (ModelClass maybeSuper = that; maybeSuper != null && !maybeSuper.isObject(); maybeSuper = maybeSuper.getSuperclass()) {
            if (!Intrinsics.areEqual((Object)maybeSuper.toJavaCode(), (Object)this.mClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public InjectedClass erasure() {
        return this;
    }

    @NotNull
    public String toString() {
        return "Injected Class: " + this.mClassName;
    }

    private static final boolean isObservable_delegate$lambda$0(InjectedClass this$0) {
        return this$0.getSuperclass().isObservable();
    }

    private static final ModelClass superclass_delegate$lambda$1(InjectedClass this$0) {
        ModelClass modelClass = ModelAnalyzer.Companion.getInstance().findClass(this$0.mSuperClass, null);
        Intrinsics.checkNotNull((Object)modelClass);
        return modelClass;
    }

    private static final String jniDescription_delegate$lambda$2(InjectedClass this$0) {
        return TypeUtil.getInstance().getDescription(this$0);
    }

    private static final TypeName typeName_delegate$lambda$3(InjectedClass this$0) {
        ModelAnalyzer instance = ModelAnalyzer.Companion.getInstance();
        return ExtKt.toTypeName(this$0.mClassName, instance.libTypes);
    }
}

