/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColPosition;
import java.io.File;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.jetbrains.annotations.NotNull;

public class ClangSym {
    @NotNull
    public final String name;
    @NotNull
    public final SourceLocation startLoc;
    @NotNull
    public final SourceLocation endLoc;
    @NotNull
    public final SymbolKind kind;

    @NotNull
    public static ClangSym fromSymbolInformation(@NotNull ClangUrlConverter converter, @NotNull SymbolInformation symInfo) {
        if (converter == null) {
            ClangSym.$$$reportNull$$$0(0);
        }
        if (symInfo == null) {
            ClangSym.$$$reportNull$$$0(1);
        }
        Location loc = symInfo.getLocation();
        File locFile = new File(converter.fromUri(loc.getUri()));
        SourceLocation startLoc = new SourceLocation(locFile, new ClangLineColPosition(loc.getRange().getStart()));
        SourceLocation endLoc = new SourceLocation(locFile, new ClangLineColPosition(loc.getRange().getEnd()));
        return new ClangSym(symInfo.getName(), startLoc, endLoc, symInfo.getKind());
    }

    public ClangSym(@NotNull String name, @NotNull SourceLocation startLoc, @NotNull SourceLocation endLoc, @NotNull SymbolKind kind) {
        if (name == null) {
            ClangSym.$$$reportNull$$$0(2);
        }
        if (startLoc == null) {
            ClangSym.$$$reportNull$$$0(3);
        }
        if (endLoc == null) {
            ClangSym.$$$reportNull$$$0(4);
        }
        if (kind == null) {
            ClangSym.$$$reportNull$$$0(5);
        }
        this.name = name;
        this.startLoc = startLoc;
        this.endLoc = endLoc;
        this.kind = kind;
    }

    public boolean isMacro() {
        return this.kind == SymbolKind.String;
    }

    public String toString() {
        return "ClangSym{name='" + this.name + "', startLoc=" + this.startLoc + ", endLoc=" + this.endLoc + ", kind=" + this.kind + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLoc";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endLoc";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangSym";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fromSymbolInformation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

