/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerCustomTasks;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFlushCustomTasksParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRunBuildDfaParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRunClangTidyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionRunClazyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.IndexerState;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdIndexingTaskId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdIndexerService
extends ClangdLanguageService {
    private static final Logger LOG = Logger.getInstance((String)ClangdIndexerService.class.getName());
    @NotNull
    private final Set<String> myDangerousFiles;
    @NotNull
    private final List<String> myAppLog;
    @NotNull
    private final BackgroundTaskQueue myQueue;
    @Nullable
    private MyIndexingProgressTask myLastTask;
    private volatile boolean myPaused;
    @NotNull
    private volatile IndexerState myState;
    @NotNull
    private final List<Consumer<Boolean>> myPausedListeners;
    @NotNull
    private final List<Consumer<IndexerState>> myStateListeners;
    @NotNull
    private final ScheduledFuture<?> myUnsavedWatcherFuture;

    public ClangdIndexerService(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(0);
        }
        super(context);
        this.myDangerousFiles = new HashSet<String>();
        this.myAppLog = new LinkedList<String>();
        this.myLastTask = null;
        this.myPaused = false;
        this.myState = IndexerState.Idle;
        this.myPausedListeners = new CopyOnWriteArrayList<Consumer<Boolean>>();
        this.myStateListeners = new CopyOnWriteArrayList<Consumer<IndexerState>>();
        this.myQueue = new BackgroundTaskQueue(context.getProject(), ClangdBundle.message("clangd.indexing.message", new Object[0]));
        this.myUnsavedWatcherFuture = this.startUnsavedFilesWatcher(context);
        this.installDangerousFilesListener();
        this.installIndexLoggerIfNeeded();
        this.installIndexingProgressIfNeeded(context);
    }

    public boolean isPaused() {
        return this.myPaused;
    }

    @NotNull
    public IndexerState getState() {
        IndexerState indexerState = this.myState;
        if (indexerState == null) {
            ClangdIndexerService.$$$reportNull$$$0(1);
        }
        return indexerState;
    }

    public void waitUntilIdle(int timeoutMSecs) {
        new WaitFor(timeoutMSecs){

            protected boolean condition() {
                return ClangdIndexerService.this.myState == IndexerState.Idle;
            }
        };
    }

    public void addPausedListener(@NotNull Consumer<Boolean> listener) {
        if (listener == null) {
            ClangdIndexerService.$$$reportNull$$$0(2);
        }
        this.myPausedListeners.add(listener);
    }

    public void addStateListener(@NotNull Consumer<IndexerState> listener) {
        if (listener == null) {
            ClangdIndexerService.$$$reportNull$$$0(3);
        }
        this.myStateListeners.add(listener);
    }

    public void removeStateListener(@NotNull Consumer<IndexerState> listener) {
        if (listener == null) {
            ClangdIndexerService.$$$reportNull$$$0(4);
        }
        this.myStateListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<String> getCopyOfAppLog() {
        List<String> list = this.myAppLog;
        // MONITORENTER : list
        ArrayList<String> arrayList = new ArrayList<String>(this.myAppLog);
        // MONITOREXIT : list
        if (arrayList != null) return arrayList;
        ClangdIndexerService.$$$reportNull$$$0(5);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getCopyOfDangerousFiles() {
        Set<String> set = this.myDangerousFiles;
        // MONITORENTER : set
        HashSet<String> hashSet = new HashSet<String>(this.myDangerousFiles);
        // MONITOREXIT : set
        if (hashSet != null) return hashSet;
        ClangdIndexerService.$$$reportNull$$$0(6);
        return hashSet;
    }

    @NotNull
    public CompletableFuture<String> requestServerState() {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("requestServerState").action(server -> ClangUtils.tie(server.clionRequestServerState(), result)).onSkipped(() -> result.complete("skipped")).onRejected(() -> result.complete("rejected")).requiresRecover(true).create());
        CompletableFuture<String> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Boolean> executeCommand(@NotNull ClangIndexerCommand command) {
        if (command == null) {
            ClangdIndexerService.$$$reportNull$$$0(8);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        Consumer<ClangRemoteWorkspace> handlePause = ws -> {
            if (command.isPause()) {
                ws.setPaused(true);
                this.changePaused(true);
            } else if (command.isResume()) {
                ws.setPaused(false);
                this.changePaused(false);
            }
        };
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction(command.getCommand()).action((server, ws) -> {
            ClangUtils.tie(result, server.clionIndexerCommand(new ClionIndexerCommandParams(command.getCommand(), command.getArgument())));
            handlePause.accept((ClangRemoteWorkspace)ws);
        }).onSkipped(ws -> {
            result.complete(false);
            handlePause.accept((ClangRemoteWorkspace)ws);
        }).onRejected(() -> result.complete(false)).requiresRecover().create());
        CompletableFuture<Boolean> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(9);
        }
        return completableFuture;
    }

    private void changePaused(boolean newValue) {
        this.myPaused = newValue;
        for (Consumer<Boolean> listener : this.myPausedListeners) {
            listener.accept(newValue);
        }
    }

    public <E extends Throwable> void runCustomTasks(@NotNull ClangdIndexerCustomTasks tasks, @NotNull ClangResultConsumer<Void, E> consumer) throws E {
        if (tasks == null) {
            ClangdIndexerService.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            ClangdIndexerService.$$$reportNull$$$0(11);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Scheduled custom tasks: " + tasks);
        }
        assert (tasks.getIndexer() == this);
        AtomicBoolean mayHaveStarted = new AtomicBoolean(false);
        CompletableFuture<Integer> newBatch = this.sendNewCustomTasksBatch();
        try {
            Integer batchId = (Integer)CidrConcurrentUtilsKt.waitCancelAware(newBatch, (String)"sendNewCustomTasksBatch");
            Objects.requireNonNull(batchId);
            for (ClionRunBuildDfaParams dfaParams : tasks.getAllDfaParams(batchId)) {
                CidrConcurrentUtilsKt.waitCancelAware(this.sendAddDfaBuildTasks(dfaParams), (String)"sendAddDfaBuildTasks");
            }
            for (ClionRunClangTidyParams clangTidyParams : tasks.getAllClangTidyParams(batchId)) {
                CidrConcurrentUtilsKt.waitCancelAware(this.sendAddClangTidyTasks(clangTidyParams), (String)"sendAddClangTidyTasks");
            }
            for (ClionRunClazyParams clazyParams : tasks.getAllClazyParams(batchId)) {
                CidrConcurrentUtilsKt.waitCancelAware(this.sendAddClazyTasks(clazyParams), (String)"sendAddClazyTasks");
            }
            mayHaveStarted.set(true);
            CidrConcurrentUtilsKt.waitCancelAware(this.sendFlushCustomTasksBatch(batchId, false), (String)"sendFlushCustomTasksBatch");
        }
        catch (Throwable ex) {
            newBatch.thenAccept(id -> this.sendFlushCustomTasksBatch((int)id, true));
            if (mayHaveStarted.get()) {
                this.executeCommand(ClangIndexerCommand.Companion.getCANCEL());
            }
            tasks.cancel();
            ExceptionUtil.rethrow((Throwable)ex);
        }
        CompletableFuture<Void> masterFuture = tasks.getMasterFuture();
        ClangResultImpl<Void> results = new ClangResultImpl<Void>("runCustomTasks", masterFuture, () -> {
            if (!masterFuture.isDone()) {
                this.executeCommand(ClangIndexerCommand.Companion.getCANCEL());
            }
        });
        ClangdIndexerService.applyConsumer(consumer, results);
    }

    @NotNull
    private CompletableFuture<Integer> sendNewCustomTasksBatch() {
        CompletableFuture<Integer> result = new CompletableFuture<Integer>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("sendNewCustomTasksBatch").action(server -> ClangUtils.tie(result, server.clionNewCustomTasksBatch())).requiresRecover().onSkipped(() -> result.completeExceptionally(new IllegalStateException("Skipped"))).onRejected(() -> result.completeExceptionally(new IllegalStateException("Rejected"))).create());
        CompletableFuture<Integer> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<Object> sendAddDfaBuildTasks(@NotNull ClionRunBuildDfaParams params) {
        if (params == null) {
            ClangdIndexerService.$$$reportNull$$$0(13);
        }
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("sendAddDfaBuildTasks").action(server -> ClangUtils.tie(result, server.clionAddBuildDfaTasks(params))).onSkipped(() -> result.completeExceptionally(new IllegalStateException("Skipped"))).onRejected(() -> result.completeExceptionally(new IllegalStateException("Rejected"))).create());
        CompletableFuture<Object> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<Object> sendAddClangTidyTasks(@NotNull ClionRunClangTidyParams params) {
        if (params == null) {
            ClangdIndexerService.$$$reportNull$$$0(15);
        }
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("sendAddClangTidyTasks").action(server -> ClangUtils.tie(result, server.clionAddClangTidyTasks(params))).onSkipped(() -> result.completeExceptionally(new IllegalStateException("Skipped"))).onRejected(() -> result.completeExceptionally(new IllegalStateException("Rejected"))).create());
        CompletableFuture<Object> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<Object> sendAddClazyTasks(@NotNull ClionRunClazyParams params) {
        if (params == null) {
            ClangdIndexerService.$$$reportNull$$$0(17);
        }
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("sendAddClazyTasks").action(server -> ClangUtils.tie(result, server.clionAddClazyTasks(params))).onSkipped(() -> result.completeExceptionally(new IllegalStateException("Skipped"))).onRejected(() -> result.completeExceptionally(new IllegalStateException("Rejected"))).create());
        CompletableFuture<Object> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(18);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<Object> sendFlushCustomTasksBatch(int id, boolean drop) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("sendFlushCustomTasksBatch").action(server -> ClangUtils.tie(result, server.clionFlushCustomTasksBatch(new ClionFlushCustomTasksParams(id, drop)))).onSkipped(() -> result.completeExceptionally(new IllegalStateException("Skipped"))).onRejected(() -> result.completeExceptionally(new IllegalStateException("Rejected"))).create());
        CompletableFuture<Object> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(19);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Boolean> notifySettingsChanged(@NotNull ClionIndexerParams newParams) {
        if (newParams == null) {
            ClangdIndexerService.$$$reportNull$$$0(20);
        }
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        this.myRequestsPlanner.sendImmediately(ClangInteraction.newInteraction("setMode").action(server -> ClangUtils.tie(result, server.clionSetIndexerOpts(newParams))).onRejected(() -> result.complete(false)).onSkipped(() -> result.complete(false)).requiresRecover().create());
        CompletableFuture<Boolean> completableFuture = result;
        if (completableFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(21);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        this.myUnsavedWatcherFuture.cancel(true);
        ClangStopData clangStopData = super.stop();
        if (clangStopData == null) {
            ClangdIndexerService.$$$reportNull$$$0(22);
        }
        return clangStopData;
    }

    private void installDangerousFilesListener() {
        this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServerFailure() {
                Set<String> set = ClangdIndexerService.this.myDangerousFiles;
                synchronized (set) {
                    ClangdIndexerService.this.getContext().getTelemetry().getGeneralTelemetry().forEachParsedFile((path, stats) -> {
                        if (stats.parseStartedCounter > stats.parseFinishedCounter) {
                            ClangdIndexerService.this.myDangerousFiles.add((String)path);
                        }
                    });
                }
            }
        });
    }

    private void installIndexLoggerIfNeeded() {
        this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            @Override
            public void onIndexingStateChanged(@NotNull IndexerState state) {
                if (state == null) {
                    3.$$$reportNull$$$0(0);
                }
                ClangdIndexerService.this.myState = state;
                for (Consumer<IndexerState> l : ClangdIndexerService.this.myStateListeners) {
                    l.accept(state);
                }
            }

            @Override
            public void onServerFailure() {
                this.onIndexingStateChanged(IndexerState.Idle);
            }

            @Override
            public void onServerShutDown() {
                this.onIndexingStateChanged(IndexerState.Idle);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$3", "onIndexingStateChanged"));
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.getMessageBus().connect(this.getAssociatedDisposable()).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){
            private boolean indexStartedCame = false;
            private int lastReportedPercent = -1;

            @Override
            public void onIndexingStarted(@NotNull ClangdIndexingTaskId taskId) {
                if (taskId == null) {
                    4.$$$reportNull$$$0(0);
                }
                this.indexStartedCame = true;
                this.lastReportedPercent = -1;
            }

            @Override
            public void onIndexingProgress(int percentage, @NlsSafe String message) {
                if (this.indexStartedCame) {
                    ClangdIndexerService.this.addAppLogMessage("Indexing started");
                    this.indexStartedCame = false;
                }
                if (percentage != this.lastReportedPercent) {
                    this.lastReportedPercent = percentage;
                    ClangdIndexerService.this.addAppLogMessage("Progress: " + message + " (" + percentage + "%)");
                }
            }

            @Override
            public void onIndexingFinished(@NotNull List<String> deletedPaths, @NotNull String symbolsDirPath) {
                if (deletedPaths == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (symbolsDirPath == null) {
                    4.$$$reportNull$$$0(2);
                }
                StringBuilder sb = new StringBuilder("Indexing finished! " + deletedPaths.size() + " deleted  (" + symbolsDirPath + ")");
                if (!deletedPaths.isEmpty()) {
                    sb.append("Deleted paths:\n");
                    for (String path : deletedPaths) {
                        sb.append("  ").append(path).append("\n");
                    }
                }
                ClangdIndexerService.this.addAppLogMessage(sb.toString());
            }

            @Override
            public void onIndexingMessage(@NotNull String message) {
                if (message == null) {
                    4.$$$reportNull$$$0(3);
                }
                ClangdIndexerService.this.addAppLogMessage(message);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "taskId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deletedPaths";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbolsDirPath";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingStarted";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingFinished";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingMessage";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAppLogMessage(@NotNull String message) {
        if (message == null) {
            ClangdIndexerService.$$$reportNull$$$0(23);
        }
        List<String> list = this.myAppLog;
        synchronized (list) {
            if (this.myAppLog.size() >= 4096) {
                this.myAppLog.remove(0);
            }
            this.myAppLog.add(message);
        }
    }

    private void installIndexingProgressIfNeeded(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(24);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!ClangdSettings.getInstance(this.myProject).getIndexerShowProgress()) {
            return;
        }
        context.getMessageBus().connect((Disposable)context).subscribe(ClangServerListener.TOPIC, (Object)new ClangServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingStarted(@NotNull ClangdIndexingTaskId taskId) {
                if (taskId == null) {
                    5.$$$reportNull$$$0(0);
                }
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    ClangdIndexerService.this.myQueue.clear();
                    if (ClangdIndexerService.this.myLastTask != null) {
                        ClangdIndexerService.this.myLastTask.myFinished.complete(true);
                        ClangdIndexerService.this.myLastTask = null;
                    }
                    ClangdIndexerService.this.myLastTask = new MyIndexingProgressTask(ClangdIndexerService.this.myProject, ClangdIndexerService.this, taskId);
                    ClangdIndexerService.this.myQueue.run((Task.Backgroundable)ClangdIndexerService.this.myLastTask);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onIndexingProgress(int percentage, @NlsSafe String message) {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null && ClangdIndexerService.this.myLastTask.myAssignedIndicator != null) {
                        Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setFraction((double)percentage / 100.0);
                        Objects.requireNonNull(ClangdIndexerService.this.myLastTask.myAssignedIndicator).setText2(message);
                    }
                }
            }

            @Override
            public void onIndexingCanceled() {
                this.onIndexingFinishedImpl();
            }

            @Override
            public void onIndexingFinished(@NotNull List<String> deletedSymbolsPaths, @NotNull String symbolsDirPath) {
                if (deletedSymbolsPaths == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (symbolsDirPath == null) {
                    5.$$$reportNull$$$0(2);
                }
                this.onIndexingFinishedImpl();
            }

            @Override
            public void onServerFailure() {
                this.onIndexingFinishedImpl();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onIndexingFinishedImpl() {
                BackgroundTaskQueue backgroundTaskQueue = ClangdIndexerService.this.myQueue;
                synchronized (backgroundTaskQueue) {
                    if (ClangdIndexerService.this.myLastTask != null) {
                        ClangdIndexerService.this.myLastTask.myFinished.complete(true);
                        ClangdIndexerService.this.myLastTask = null;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "taskId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deletedSymbolsPaths";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbolsDirPath";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingStarted";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onIndexingFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private ScheduledFuture<?> startUnsavedFilesWatcher(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangdIndexerService.$$$reportNull$$$0(25);
        }
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
            if (!context.isStopped()) {
                Set<String> unsavedUrlsAtIndexer = context.getRemoteWorkspace().getUnsavedFiles();
                ArrayList<VirtualFile> savedFiles = new ArrayList<VirtualFile>();
                for (String unsavedUrl : unsavedUrlsAtIndexer) {
                    VirtualFile vf = context.getIdeFacade().getVirtualFile(unsavedUrl);
                    if (vf == null || context.getIdeFacade().isModified(vf)) continue;
                    savedFiles.add(vf);
                }
                if (!savedFiles.isEmpty()) {
                    LOG.warn("Found " + savedFiles.size() + " unreported saved files");
                    for (VirtualFile savedFile : savedFiles) {
                        this.notifyDocumentSaved(savedFile);
                    }
                }
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            ClangdIndexerService.$$$reportNull$$$0(26);
        }
        return scheduledFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 9, 12, 14, 16, 18, 19, 21, 22, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParams";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyOfAppLog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopyOfDangerousFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "requestServerState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sendNewCustomTasksBatch";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sendAddDfaBuildTasks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sendAddClangTidyTasks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sendAddClazyTasks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "sendFlushCustomTasksBatch";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "notifySettingsChanged";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "startUnsavedFilesWatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPausedListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStateListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeStateListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runCustomTasks";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sendAddDfaBuildTasks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sendAddClangTidyTasks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendAddClazyTasks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifySettingsChanged";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAppLogMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installIndexingProgressIfNeeded";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "startUnsavedFilesWatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 9, 12, 14, 16, 18, 19, 21, 22, 26 -> new IllegalStateException(string);
        };
    }

    private static class MyIndexingProgressTask
    extends Task.Backgroundable {
        private final ClangdIndexingTaskId myTaskId;
        private final ClangdIndexerService myService;
        private final CompletableFuture<Object> myFinished;
        @Nullable
        private volatile ProgressIndicator myAssignedIndicator;

        private MyIndexingProgressTask(@NotNull Project project, @NotNull ClangdIndexerService service, @NotNull ClangdIndexingTaskId taskId) {
            if (project == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(0);
            }
            if (service == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(1);
            }
            if (taskId == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(2);
            }
            super(project, ClangdBundle.message("clangd.indexing.message", new Object[0]), true);
            this.myFinished = new CompletableFuture();
            this.myAssignedIndicator = null;
            this.myService = service;
            this.myTaskId = taskId;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyIndexingProgressTask.$$$reportNull$$$0(3);
            }
            try {
                this.myAssignedIndicator = indicator;
                switch (this.myTaskId) {
                    case preprocessing: {
                        Objects.requireNonNull(this.myAssignedIndicator).setText(ClangdBundle.message("clangd.preprocessing.message", new Object[0]));
                        break;
                    }
                    case indexing: {
                        Objects.requireNonNull(this.myAssignedIndicator).setText(ClangdBundle.message("clangd.indexing.message", new Object[0]));
                    }
                }
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                try {
                    CidrConcurrentUtilsKt.waitCancelAndWriteActionAware(this.myFinished, (String)"indexing future");
                }
                catch (ProcessCanceledException ex) {
                    this.myService.executeCommand(ClangIndexerCommand.Companion.getCANCEL());
                }
                indicator.setFraction(1.0);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService$MyIndexingProgressTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

