/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceHolder;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdLanguageServiceProvider
implements ClangLanguageServiceProvider {
    @NotNull
    private final ClangdLanguageServiceHolder<ClangdLanguageService> myMainHolder;
    @NotNull
    private final ClangdLanguageServiceHolder<ClangdIndexerService> myIndexerHolder;
    @NotNull
    private final ClangdLanguageServiceHolder<ClangdIndexerService> myStatelessIndexerHolder;
    @NotNull
    private final Project myProject;

    public ClangdLanguageServiceProvider(@NotNull Project project) {
        if (project == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(0);
        }
        String clangdModulesPath = ClangdLanguageServiceProvider.getModulesPath(project, ClangLanguageService.Kind.Clangd);
        String indexerModulesPath = ClangdLanguageServiceProvider.getModulesPath(project, ClangLanguageService.Kind.Indexer);
        String statelessIndexerModulesPath = ClangdLanguageServiceProvider.getModulesPath(project, ClangLanguageService.Kind.StatelessIndexer);
        String cpp20ModulesPath = clangdModulesPath + "/cpp20";
        if (!FileUtil.exists((String)clangdModulesPath)) {
            FileUtil.createDirectory((File)new File(clangdModulesPath));
        }
        String indexerCpp20ModulesPath = indexerModulesPath + "/cpp20";
        if (!FileUtil.exists((String)indexerModulesPath)) {
            FileUtil.createDirectory((File)new File(indexerModulesPath));
        }
        String statelessIndexerCpp20ModulesPath = statelessIndexerModulesPath + "/cpp20";
        if (!FileUtil.exists((String)statelessIndexerModulesPath)) {
            FileUtil.createDirectory((File)new File(statelessIndexerModulesPath));
        }
        CidrLogService.LOG.info("clangd modules path: " + clangdModulesPath);
        CidrLogService.LOG.info("clangd cpp20 modules path: " + cpp20ModulesPath);
        this.myMainHolder = new ClangdLanguageServiceHolder("main", project, new File(clangdModulesPath), new File(cpp20ModulesPath), ClangLanguageService.Kind.Clangd);
        this.myIndexerHolder = new ClangdLanguageServiceHolder("indexer", project, new File(indexerModulesPath), new File(indexerCpp20ModulesPath), ClangLanguageService.Kind.Indexer);
        this.myStatelessIndexerHolder = new ClangdLanguageServiceHolder("indexer-stateless", project, new File(statelessIndexerModulesPath), new File(statelessIndexerCpp20ModulesPath), ClangLanguageService.Kind.StatelessIndexer);
        this.myProject = project;
        ClangUtils.subscribeToStyleChanges(this, project);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Override
    @Nullable
    public ClangLanguageService getOrStart() {
        return this.myMainHolder.getOrStart();
    }

    @Override
    @Nullable
    public ClangLanguageService getIfStarted() {
        return this.myMainHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        ClangStopData clangStopData = this.myMainHolder.stop();
        if (clangStopData == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(2);
        }
        return clangStopData;
    }

    @Override
    @Nullable
    public ClangdIndexerService getOrStartIndexer() {
        return this.myIndexerHolder.getOrStart();
    }

    @Override
    @Nullable
    public ClangdIndexerService getIfStartedIndexer() {
        return this.myIndexerHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stopIndexer() {
        ClangStopData clangStopData = this.myIndexerHolder.stop();
        if (clangStopData == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(3);
        }
        return clangStopData;
    }

    @Override
    @Nullable
    public ClangdIndexerService getOrStartStatelessIndexer() {
        return this.myStatelessIndexerHolder.getOrStart();
    }

    @Override
    @Nullable
    public ClangdIndexerService getIfStartedStatelessIndexer() {
        return this.myStatelessIndexerHolder.getIfStarted();
    }

    @Override
    @NotNull
    public ClangStopData stopStatelessIndexer() {
        ClangStopData clangStopData = this.myStatelessIndexerHolder.stop();
        if (clangStopData == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(4);
        }
        return clangStopData;
    }

    @NotNull
    static String getModulesPath(@NotNull Project project, @NotNull ClangLanguageService.Kind kind) {
        if (project == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(6);
        }
        String propertyName = kind == ClangLanguageService.Kind.StatelessIndexer ? "STATELESS_MODULES_PATH" : "MODULES_PATH";
        Object clangdModulesPath = System.getProperty(propertyName);
        if (clangdModulesPath == null && (clangdModulesPath = System.getenv(propertyName)) == null) {
            String dir = System.getProperty("caches_dir");
            Object object = clangdModulesPath = dir == null ? PathManager.getSystemPath() + "/caches/" : dir;
        }
        if (!((String)clangdModulesPath).endsWith("/")) {
            clangdModulesPath = (String)clangdModulesPath + "/";
        }
        String dirName = kind == ClangLanguageService.Kind.StatelessIndexer ? "stateless_clangd_modules" : "clangd_modules";
        Object object = clangdModulesPath = (String)clangdModulesPath + dirName + "/" + project.getLocationHash();
        if (object == null) {
            ClangdLanguageServiceProvider.$$$reportNull$$$0(7);
        }
        return object;
    }

    public void dispose() {
        this.myMainHolder.forceStop();
        this.myIndexerHolder.forceStop();
        this.myStatelessIndexerHolder.forceStop();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdLanguageServiceProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stopIndexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stopStatelessIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModulesPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

