/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangMessagesFilter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionCapabilities;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionInitializeParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionModuleMappingParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionDidChangeTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionIndexerStartParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionInitializationOptions;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionModeParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReloadIndexParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionSetCDBParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.IndexerWindowClientCapabilities;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTReadRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangChangeNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangOpenNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadGraphNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReloadIndexNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangReparseNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAccessor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangSetCDBNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangdFatalError;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ExtendedServerInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeLensCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemKindCapabilities;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.DocumentLinkCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelpCapabilities;
import org.eclipse.lsp4j.SymbolCapabilities;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolKindCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangServerAccessorImpl
implements ClangServerAccessor {
    private static final long CLANGD_STARTUP_TIMEOUT = ApplicationManager.getApplication().isUnitTestMode() ? 60000L : 3600000L;
    private static final Logger LOG = Logger.getInstance((String)ClangServerAccessorImpl.class.getName());
    @NotNull
    private final ClangDaemonContext myContext;
    private final boolean myRunSynchronously;
    private final ReentrantLock myRunSynchronouslyLock;
    @NotNull
    private final ClangRemoteWorkspace myRemoteWorkspace;
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final StateHolder myStateHolder;
    @Nullable
    private volatile ClangdFatalError myLastFatalError;

    public ClangServerAccessorImpl(@NotNull ClangDaemonContext context, boolean runSynchronously) {
        if (context == null) {
            ClangServerAccessorImpl.$$$reportNull$$$0(0);
        }
        this.myRunSynchronouslyLock = new ReentrantLock(true);
        this.myStateHolder = new StateHolder();
        this.myLastFatalError = null;
        this.myContext = context;
        this.myRemoteWorkspace = context.getRemoteWorkspace();
        this.myRunSynchronously = runSynchronously;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("CLang Server Accessor [" + context.getDescriptor() + "]"));
    }

    @Override
    public boolean isRunningSynchronously() {
        return this.myRunSynchronously;
    }

    @Override
    @Nullable
    public ClangdFatalError getFatalError() {
        return this.myLastFatalError;
    }

    @Override
    @NotNull
    public ClangStopData shutDown() {
        State whenPostedState = this.myStateHolder.get();
        if (whenPostedState.stage == State.Stage.Initializing && this.myStateHolder.next(whenPostedState, new State(State.Stage.None, null))) {
            ClangStopData clangStopData = ClangStopData.EMPTY;
            if (clangStopData == null) {
                ClangServerAccessorImpl.$$$reportNull$$$0(1);
            }
            return clangStopData;
        }
        CompletableFuture realStopData = new CompletableFuture();
        ClangStopData stopData = new ClangStopData((CompletableFuture<Integer>)realStopData.thenCompose(sd -> sd.exitCode), () -> {
            ClangStopData sd = (ClangStopData)CidrConcurrentUtilsKt.getIfCompletedNormally((CompletableFuture)realStopData);
            if (sd != null) {
                sd.killRunnable.run();
            }
        });
        this.post(ClangInteraction.newInteraction("ShutDown").action(server -> {
            State whenExecutedState = this.myStateHolder.get();
            if (whenExecutedState.isStopped()) {
                realStopData.complete(ClangStopData.EMPTY);
                return;
            }
            realStopData.complete(Session.stopSession(whenExecutedState.session, false));
        }).onSkipped(() -> realStopData.complete(ClangStopData.EMPTY)).onRejected(() -> realStopData.complete(ClangStopData.EMPTY)).create());
        ClangStopData clangStopData = stopData;
        if (clangStopData == null) {
            ClangServerAccessorImpl.$$$reportNull$$$0(2);
        }
        return clangStopData;
    }

    @Override
    @NotNull
    public ClangStopData stop() {
        boolean terminated;
        State state;
        while (!this.myStateHolder.next(state = this.myStateHolder.get(), new State(State.Stage.Stopped, null))) {
        }
        Session session = state.session;
        this.myExecutorService.shutdown();
        if (session == null) {
            ClangStopData clangStopData = ClangStopData.EMPTY;
            if (clangStopData == null) {
                ClangServerAccessorImpl.$$$reportNull$$$0(3);
            }
            return clangStopData;
        }
        try {
            terminated = this.myExecutorService.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            terminated = false;
        }
        if (!terminated) {
            LOG.warn("Failed to wait until all the tasks are terminated");
        }
        ClangStopData clangStopData = Session.stopSession(session, false);
        if (clangStopData == null) {
            ClangServerAccessorImpl.$$$reportNull$$$0(4);
        }
        return clangStopData;
    }

    @Override
    @Nullable
    public ServerCapabilities getCapabilities() {
        Session session = this.myStateHolder.get().session;
        try {
            return session != null ? session.serverCapabilities.get() : null;
        }
        catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public ServerConnection getServerConnection() {
        Session session = this.myStateHolder.get().session;
        return session != null ? session.connection : null;
    }

    @Override
    @Nullable
    public Endpoint getRemoteEndpoint() {
        Session session = this.myStateHolder.get().session;
        if (session != null) {
            ClangClientServerProvider.ClientServerEndpoints endpoints = session.endpoints;
            return endpoints.getServer().getRemoteEndpoint();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CompletableFuture<Boolean> post(@NotNull ClangInteraction request) {
        if (request == null) {
            ClangServerAccessorImpl.$$$reportNull$$$0(5);
        }
        if (this.myStateHolder.get().isStopped()) {
            return null;
        }
        ServerTask task = new ServerTask(request);
        if (this.myRunSynchronously) {
            this.myRunSynchronouslyLock.lock();
            try {
                task.run();
                CompletableFuture<Boolean> completableFuture = task.getFuture();
                return completableFuture;
            }
            finally {
                this.myRunSynchronouslyLock.unlock();
            }
        }
        try {
            this.myExecutorService.execute(task);
            return task.getFuture();
        }
        catch (RejectedExecutionException ex) {
            request.onRejected();
            return null;
        }
    }

    private static void logServerException(@Nullable Throwable throwable) {
        if (throwable != null) {
            if (ClangServerAccessorImpl.isCrashedServerException(throwable)) {
                LOG.warn("Looks like server has crashed: " + throwable.getMessage());
            } else {
                LOG.warn(throwable);
            }
        }
    }

    private static boolean isCrashedServerException(@NotNull Throwable thr) {
        if (thr == null) {
            ClangServerAccessorImpl.$$$reportNull$$$0(6);
        }
        return JsonRpcException.indicatesStreamClosed((Throwable)thr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shutDown";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "post";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCrashedServerException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class StateHolder {
        @NotNull
        private State myState = new State(State.Stage.None, null);

        private StateHolder() {
        }

        @NotNull
        private synchronized State get() {
            State state = this.myState;
            if (state == null) {
                StateHolder.$$$reportNull$$$0(0);
            }
            return state;
        }

        private synchronized boolean next(@NotNull State expected, @NotNull State next) {
            if (expected == null) {
                StateHolder.$$$reportNull$$$0(1);
            }
            if (next == null) {
                StateHolder.$$$reportNull$$$0(2);
            }
            if (expected == this.myState) {
                this.myState = next;
                return true;
            }
            return false;
        }

        private synchronized boolean nextOrDie(@NotNull State expected, @NotNull State next) {
            if (expected == null) {
                StateHolder.$$$reportNull$$$0(3);
            }
            if (next == null) {
                StateHolder.$$$reportNull$$$0(4);
            }
            if (!this.next(expected, next)) {
                Session.stopSession(next.session, true);
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$StateHolder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expected";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "next";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$StateHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "next";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "nextOrDie";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class State {
        public final Stage stage;
        @Nullable
        public final Session session;

        private State(Stage stage, @Nullable Session session) {
            this.stage = stage;
            this.session = session;
        }

        private boolean isStopped() {
            return this.stage == Stage.Stopped;
        }

        static enum Stage {
            None,
            Initializing,
            Running,
            Stopped;

        }
    }

    private static final class Session {
        @NotNull
        final ServerConnection connection;
        @NotNull
        final ClangClientServerProvider.ClientServerEndpoints endpoints;
        @NotNull
        final CompletableFuture<ExtendedServerInfo> serverInfo;
        @NotNull
        final CompletableFuture<ServerCapabilities> serverCapabilities;
        @NotNull
        final HealthMonitor healthMonitor;
        @NotNull
        final CompletableFuture<String> earlyErrors;
        @NotNull
        private final AtomicBoolean myIsStopped;
        private volatile boolean myIsShutDown;

        private Session(@NotNull ServerConnection connection, @NotNull ClangClientServerProvider.ClientServerEndpoints endpoints, @NotNull HealthMonitor healthMonitor) {
            if (connection == null) {
                Session.$$$reportNull$$$0(0);
            }
            if (endpoints == null) {
                Session.$$$reportNull$$$0(1);
            }
            if (healthMonitor == null) {
                Session.$$$reportNull$$$0(2);
            }
            this.serverInfo = new CompletableFuture();
            this.serverCapabilities = new CompletableFuture();
            this.earlyErrors = new CompletableFuture();
            this.myIsStopped = new AtomicBoolean(false);
            this.connection = connection;
            this.endpoints = endpoints;
            this.healthMonitor = healthMonitor;
        }

        boolean isInitialized() {
            try {
                return this.serverCapabilities.isDone() && !this.serverCapabilities.isCompletedExceptionally() && this.serverCapabilities.get() != null;
            }
            catch (InterruptedException | ExecutionException ex) {
                return false;
            }
        }

        boolean isActive() {
            return this.connection.isActive();
        }

        boolean isShutDown() {
            return this.myIsShutDown;
        }

        @Nullable
        static Session startSession(@NotNull ClangDaemonContext context) throws FatalErrorException {
            Either<ServerConnection, ClangdFatalError> connOrError;
            if (context == null) {
                Session.$$$reportNull$$$0(3);
            }
            if ((connOrError = context.getConnectionProvider().create(context)).isRight()) {
                throw new FatalErrorException((ClangdFatalError)((Object)connOrError.getRight()), "Failed to create connection: " + ((ClangdFatalError)((Object)connOrError.getRight())).name());
            }
            ServerConnection connection = (ServerConnection)connOrError.getLeft();
            HealthMonitor healthMonitor = new HealthMonitor(context.getCrashHandler());
            EarlyErrorsListener earlyErrorsListener = new EarlyErrorsListener();
            ClangClientServerProvider.ClientServerEndpoints endpoints = context.getClientServerProvider().bind(context, connection, new ConnectionErrorsLogger(context.getDescriptor(), connection, healthMonitor, context.getMessagesFilter(), earlyErrorsListener), new ConnectionOutgoingLogger(context, healthMonitor), new ConnectionIncomingLogger(context, healthMonitor));
            if (endpoints == null) {
                connection.stop();
                String errors = earlyErrorsListener.takeErrors();
                throw new FatalErrorException(ClangdFatalError.FailedToInitialize, "Failed to bind client and server to a process: " + errors);
            }
            Session session = new Session(connection, endpoints, healthMonitor);
            InitializeParams initParams = Session.createInitParams(context);
            if (initParams == null) {
                ClangUtils.warnClangd(LOG, "Project is already disposed or doesn't have base directory.");
                earlyErrorsListener.takeErrors();
                Session.stopSession(session, true);
                return null;
            }
            try {
                ((CompletableFuture)endpoints.getServer().initialize(initParams).thenCompose(res -> Session.onInitializeResult(context, endpoints, res))).whenComplete((res, ex) -> {
                    session.earlyErrors.complete(earlyErrorsListener.takeErrors());
                    if (ex != null) {
                        session.serverInfo.completeExceptionally((Throwable)ex);
                        session.serverCapabilities.completeExceptionally((Throwable)ex);
                    } else {
                        try {
                            session.serverInfo.complete(res != null ? ExtendedServerInfo.create(res.getServerInfo()) : null);
                            session.serverCapabilities.complete(res != null ? res.getCapabilities() : null);
                        }
                        catch (IllegalArgumentException iae) {
                            session.serverInfo.complete(res != null ? ExtendedServerInfo.createFallback() : null);
                            session.serverCapabilities.complete(res != null ? res.getCapabilities() : null);
                            CidrLogService.logOnce((Level)Level.SEVERE, (String)iae.getMessage(), (Throwable)iae);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                String errors = earlyErrorsListener.takeErrors();
                session.earlyErrors.complete(errors);
                Session.stopSession(session, true);
                throw new FatalErrorException(ClangdFatalError.FailedToInitialize, "Exception during startup: " + errors, throwable);
            }
            return session;
        }

        @NotNull
        static ClangStopData stopSession(@Nullable Session session, boolean killServer) {
            if (session == null) {
                ClangStopData clangStopData = ClangStopData.EMPTY;
                if (clangStopData == null) {
                    Session.$$$reportNull$$$0(4);
                }
                return clangStopData;
            }
            if (!session.myIsStopped.compareAndSet(false, true)) {
                return new ClangStopData(session.connection.getStopFuture(), () -> session.connection.kill());
            }
            session.serverInfo.complete(null);
            session.serverCapabilities.complete(null);
            session.earlyErrors.complete(null);
            if (session.connection.isActive()) {
                try {
                    session.endpoints.getServer().shutdown();
                    session.endpoints.getServer().exit();
                    session.myIsShutDown = true;
                }
                catch (Throwable thr) {
                    session.connection.stop();
                    LOG.warn(thr);
                }
            }
            session.healthMonitor.stopMonitoring();
            Disposer.dispose((Disposable)session.endpoints);
            if (killServer) {
                session.connection.stop();
            }
            return new ClangStopData(session.connection.getStopFuture(), () -> session.connection.kill());
        }

        @NotNull
        private static CompletableFuture<InitializeResult> onInitializeResult(@NotNull ClangDaemonContext context, @NotNull ClangClientServerProvider.ClientServerEndpoints endpoints, @Nullable InitializeResult res) {
            if (context == null) {
                Session.$$$reportNull$$$0(5);
            }
            if (endpoints == null) {
                Session.$$$reportNull$$$0(6);
            }
            if (res == null) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                if (completableFuture == null) {
                    Session.$$$reportNull$$$0(7);
                }
                return completableFuture;
            }
            Object experimental = res.getCapabilities().getExperimental();
            FatalErrorException error = Session.checkDaemonVersion(context, experimental);
            if (error != null) {
                CompletableFuture<InitializeResult> Res = new CompletableFuture<InitializeResult>();
                Res.completeExceptionally(error);
                CompletableFuture<InitializeResult> completableFuture = Res;
                if (completableFuture == null) {
                    Session.$$$reportNull$$$0(8);
                }
                return completableFuture;
            }
            String modulesPath = context.getUrlConverter().path2ClangdPath(new File(context.getClangdModulesPath()), false);
            if (context.isAnyIndexer()) {
                ClangdSettings settings = ClangdSettings.getInstance(context.getProject());
                boolean skipBodies = settings.getIndexerSkipBodies();
                boolean skipImplicitInstantiations = settings.getIndexerSkipImplicitInstantiations();
                int modulesCacheMb = settings.getIndexerModulesCacheMb();
                int indexingThreadsNum = settings.getIndexingThreadsNum();
                boolean restrictUpdatingThreads = settings.getIndexerRestrictUpdatingThreads();
                boolean showDebugMessages = settings.getIndexerShowDebugMessages();
                boolean useModules = settings.getIndexerUseModules();
                ClionIndexerParams clionIndexerParams = new ClionIndexerParams(modulesPath, skipBodies, skipImplicitInstantiations, modulesCacheMb, indexingThreadsNum, restrictUpdatingThreads, showDebugMessages, useModules);
                ClionIndexerStartParams clionIndexerStartParams = new ClionIndexerStartParams(!context.isStatelessIndexer());
                ClangServer server = endpoints.getServer();
                CompletionStage completionStage = ((CompletableFuture)server.clionSetIndexerOpts(clionIndexerParams).thenCompose(any -> server.clionIndexerStart(clionIndexerStartParams))).thenApply(any -> res);
                if (completionStage == null) {
                    Session.$$$reportNull$$$0(9);
                }
                return completionStage;
            }
            ClionModeParams clionModeParams = new ClionModeParams(modulesPath, true);
            CompletionStage completionStage = endpoints.getServer().clionModeOn(clionModeParams).thenApply(any -> res);
            if (completionStage == null) {
                Session.$$$reportNull$$$0(10);
            }
            return completionStage;
        }

        @Nullable
        private static FatalErrorException checkDaemonVersion(@NotNull ClangDaemonContext context, @Nullable Object experimental) {
            if (context == null) {
                Session.$$$reportNull$$$0(11);
            }
            ClangdFatalError error = null;
            Object errorMessage = null;
            Integer daemonVersion = Session.getDaemonVersion(experimental);
            if (daemonVersion == null) {
                errorMessage = "Cannot get clion-clangd version. Is this a clion-clangd?";
                error = ClangdFatalError.NotACLionClangd;
            } else if (daemonVersion.intValue() != context.getCLionDaemonVersion()) {
                errorMessage = "Version of clion-clangd is " + daemonVersion + ", but expected version is " + context.getCLionDaemonVersion();
                error = ClangdFatalError.MismatchedVersion;
            }
            if (error != null) {
                assert (errorMessage != null);
                if (context.isCustomClangdUsed()) {
                    String customClangdMessage = "You are using custom clangd, check option \"CLANGD_PATH\". Did you forget to update it?";
                    errorMessage = PluginManagerCore.isRunningFromSources() ? (String)errorMessage + "<br><br>DEVELOPER NOTICE:<br>" + customClangdMessage : (String)errorMessage + "<br>" + customClangdMessage;
                } else if (PluginManagerCore.isRunningFromSources()) {
                    errorMessage = (String)errorMessage + "<br><br>DEVELOPER NOTICE:<br>Probably you need to execute `DownloadCLionDependencies` run configuration.";
                }
            }
            return error != null ? new FatalErrorException(error, (String)errorMessage) : null;
        }

        @Nullable
        private static Integer getDaemonVersion(@Nullable Object experimental) {
            Object daemonVersion;
            if (experimental instanceof JsonObject) {
                JsonObject asJson = (JsonObject)experimental;
                JsonElement daemonVersion2 = asJson.get("clionDaemon");
                if (daemonVersion2 instanceof JsonPrimitive) {
                    JsonPrimitive asPrimitive = (JsonPrimitive)daemonVersion2;
                    return asPrimitive.getAsInt();
                }
            } else if (experimental instanceof Map && (daemonVersion = ((Map)experimental).get("clionDaemon")) instanceof Number) {
                return ((Number)daemonVersion).intValue();
            }
            return null;
        }

        @Nullable
        private static InitializeParams createInitParams(@NotNull ClangDaemonContext context) {
            String baseDirPath;
            if (context == null) {
                Session.$$$reportNull$$$0(12);
            }
            if ((baseDirPath = context.getProject().getBasePath()) == null) {
                return null;
            }
            CLionInitializeParams initParams = new CLionInitializeParams(Registry.is((String)"clion.clang.clangd.disable.mangler"));
            initParams.setProcessId(Integer.parseInt(OSProcessUtil.getApplicationPid()));
            ArrayList<WorkspaceFolder> workspaceFolders = new ArrayList<WorkspaceFolder>();
            workspaceFolders.add(new WorkspaceFolder(context.getUrlConverter().toUri(new File(baseDirPath), false)));
            initParams.setWorkspaceFolders(workspaceFolders);
            WorkspaceClientCapabilities workspaceClientCapabilities = new WorkspaceClientCapabilities();
            workspaceClientCapabilities.setApplyEdit(Boolean.TRUE);
            workspaceClientCapabilities.setExecuteCommand(new ExecuteCommandCapabilities(Boolean.TRUE));
            ArrayList symbolKinds = new ArrayList();
            Collections.addAll(symbolKinds, SymbolKind.values());
            SymbolKindCapabilities symbolKindCapabilities = new SymbolKindCapabilities(symbolKinds);
            workspaceClientCapabilities.setSymbol(new SymbolCapabilities(symbolKindCapabilities));
            workspaceClientCapabilities.setWorkspaceFolders(Boolean.TRUE);
            TextDocumentClientCapabilities textDocumentClientCapabilities = new TextDocumentClientCapabilities();
            textDocumentClientCapabilities.setCodeAction(new CodeActionCapabilities());
            textDocumentClientCapabilities.setCodeLens(new CodeLensCapabilities());
            ArrayList allKinds = new ArrayList();
            Collections.addAll(allKinds, CompletionItemKind.values());
            CLionCompletionCapabilities completion = new CLionCompletionCapabilities(new CompletionItemKindCapabilities(allKinds));
            completion.setCompletionItem(new CompletionItemCapabilities(Boolean.TRUE));
            completion.setEditsNearCursor(true);
            textDocumentClientCapabilities.setCompletion((CompletionCapabilities)completion);
            textDocumentClientCapabilities.setDefinition(new DefinitionCapabilities());
            textDocumentClientCapabilities.setDocumentHighlight(new DocumentHighlightCapabilities());
            textDocumentClientCapabilities.setDocumentLink(new DocumentLinkCapabilities());
            textDocumentClientCapabilities.setDocumentSymbol(new DocumentSymbolCapabilities());
            textDocumentClientCapabilities.setFormatting(new FormattingCapabilities());
            textDocumentClientCapabilities.setHover(new HoverCapabilities(Arrays.asList("markdown", "plaintext"), Boolean.valueOf(false)));
            textDocumentClientCapabilities.setOnTypeFormatting(null);
            textDocumentClientCapabilities.setRangeFormatting(new RangeFormattingCapabilities());
            textDocumentClientCapabilities.setReferences(new ReferencesCapabilities());
            textDocumentClientCapabilities.setRename(new RenameCapabilities());
            textDocumentClientCapabilities.setSignatureHelp(new SignatureHelpCapabilities());
            textDocumentClientCapabilities.setSynchronization(new SynchronizationCapabilities(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true)));
            ClientCapabilities clientCapabilities = new ClientCapabilities(workspaceClientCapabilities, textDocumentClientCapabilities, null);
            if (context.isAnyIndexer()) {
                IndexerWindowClientCapabilities windowClientCapabilities = new IndexerWindowClientCapabilities();
                windowClientCapabilities.setWorkDoneProgress(context.isAnyIndexer());
                windowClientCapabilities.setImplicitWorkDoneProgressCreate(true);
                clientCapabilities.setWindow((WindowClientCapabilities)windowClientCapabilities);
            }
            initParams.setCapabilities(clientCapabilities);
            String modulesPath = context.getUrlConverter().path2ClangdPath(new File(context.getClangdModulesPath()), false);
            initParams.setInitializationOptions(new ClionInitializationOptions(modulesPath));
            return initParams;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endpoints";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "healthMonitor";
                    break;
                }
                case 3: 
                case 5: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$Session";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$Session";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stopSession";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "onInitializeResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "startSession";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onInitializeResult";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "checkDaemonVersion";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createInitParams";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }

        private static class EarlyErrorsListener
        implements Consumer<String> {
            private volatile boolean myIsActive = true;
            @NotNull
            private final StringBuffer myErrors = new StringBuffer();
            private int myCounter = 0;

            private EarlyErrorsListener() {
            }

            @Override
            public void accept(String s) {
                if (this.myIsActive) {
                    this.myErrors.append(s).append('\n');
                    if (++this.myCounter > 1024) {
                        this.myIsActive = false;
                        LOG.error("Failed to cancel EarlyErrorsListener?");
                    }
                }
            }

            String takeErrors() {
                this.myIsActive = false;
                return this.myErrors.toString();
            }
        }
    }

    private final class ServerTask
    implements Runnable {
        @NotNull
        private final ClangInteraction myRequest;
        @NotNull
        private final CompletableFuture<Boolean> myFuture;

        private ServerTask(ClangInteraction request) {
            if (request == null) {
                ServerTask.$$$reportNull$$$0(0);
            }
            this.myFuture = new CompletableFuture();
            this.myRequest = request;
        }

        @NotNull
        private CompletableFuture<Boolean> getFuture() {
            CompletableFuture<Boolean> completableFuture = this.myFuture;
            if (completableFuture == null) {
                ServerTask.$$$reportNull$$$0(1);
            }
            return completableFuture;
        }

        @Override
        public void run() {
            this.runCancellable(() -> {
                boolean wasSent = false;
                try {
                    AtomicBoolean wasStopped = new AtomicBoolean();
                    Session session = this.getActiveSession(wasStopped);
                    if (wasStopped.get()) {
                        this.myRequest.onRejected();
                        assert (session == null) : "Why service was stopped, but there is a session?";
                        ClangUtils.warnClangd(LOG, "Request '" + this.myRequest.getName() + "' was skipped because the server was stopped.");
                        return;
                    }
                    if (session == null) {
                        this.myRequest.onSkipped(ClangServerAccessorImpl.this.myRemoteWorkspace);
                        ClangUtils.warnClangd(LOG, "Request '" + this.myRequest.getName() + "' was skipped because the server is down. Recovery for the request is " + (this.myRequest.requiresRecover() ? "required." : "not required."));
                        return;
                    }
                    this.runWithSession(session);
                    wasSent = true;
                }
                catch (Throwable ex) {
                    ClangServerAccessorImpl.logServerException(ex);
                    this.myRequest.onRejected();
                }
                finally {
                    this.myFuture.complete(wasSent);
                }
            });
        }

        private void runCancellable(@NotNull Runnable task) {
            if (task == null) {
                ServerTask.$$$reportNull$$$0(2);
            }
            try {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)ClangServerAccessorImpl.this.myContext, (Runnable)task);
            }
            catch (Throwable thr) {
                this.myRequest.onRejected();
                this.myFuture.complete(false);
            }
        }

        private void runWithSession(@NotNull Session session) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(3);
            }
            try {
                session.healthMonitor.serverTaskStarted();
                this.prepareForRequest(session);
                this.myRequest.send(session.endpoints.getServer(), ClangServerAccessorImpl.this.myRemoteWorkspace);
            }
            finally {
                session.healthMonitor.serverTaskEnded();
            }
        }

        private void prepareForRequest(@NotNull Session session) {
            int version;
            FileRecoveryData data;
            String url;
            if (session == null) {
                ServerTask.$$$reportNull$$$0(4);
            }
            if (this.myRequest instanceof ClangASTReadRequest && !ClangServerAccessorImpl.this.myRemoteWorkspace.isParsed(url = ((ClangASTReadRequest)this.myRequest).getAstFileUrl()) && (data = FileRecoveryData.create(url, ClangServerAccessorImpl.this.myRemoteWorkspace)) != null && (version = ClangServerAccessorImpl.this.myRemoteWorkspace.apply(url, wf -> wf.getOrDefault(RemoteWorkspaceFile.VERSION)).intValue()) == 0) {
                HashMap recovered = new HashMap();
                this.recoverReparse(session, data, version + 1, recovered);
                this.applyRecovered(data.url, recovered);
            }
        }

        @Nullable
        private Session getActiveSession(AtomicBoolean wasStopped) {
            State state = ClangServerAccessorImpl.this.myStateHolder.get();
            wasStopped.set(false);
            if (state.isStopped()) {
                wasStopped.set(true);
                return null;
            }
            if (state.session != null && state.session.isActive()) {
                return state.session;
            }
            return this.myRequest.requiresRecover() || ClangServerAccessorImpl.this.myContext.isRegularIndexer() ? this.recover(state) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Session recover(@NotNull State oldState) {
            if (oldState == null) {
                ServerTask.$$$reportNull$$$0(5);
            }
            Session oldSession = oldState.session;
            assert (oldSession == null || !oldSession.isActive());
            if (oldState.stage == State.Stage.Initializing) {
                return null;
            }
            if (ClangServerAccessorImpl.this.myLastFatalError != null) {
                return null;
            }
            State initState = new State(State.Stage.Initializing, null);
            if (!ClangServerAccessorImpl.this.myStateHolder.next(oldState, initState)) {
                return null;
            }
            Session newSession = null;
            try {
                Session.stopSession(oldSession, true);
                newSession = Session.startSession(ClangServerAccessorImpl.this.myContext);
                if (newSession != null) {
                    this.waitForServer(initState, newSession, CLANGD_STARTUP_TIMEOUT);
                    assert (newSession.isInitialized());
                    this.startHealthMonitor(newSession);
                    this.attachStopHandler(newSession);
                    this.update(newSession);
                    if (ClangServerAccessorImpl.this.myStateHolder.nextOrDie(initState, new State(State.Stage.Running, newSession))) {
                        this.reportServerRunning(newSession);
                        Session session = newSession;
                        return session;
                    }
                    ClangUtils.warnClangd(LOG, "Failed to swap sessions, most likely service was stopped earlier");
                }
            }
            catch (TimeoutException ex) {
                Session.stopSession(newSession, true);
                LOG.warn("Clangd server restarts too slow", (Throwable)ex);
            }
            catch (Throwable thr) {
                Session.stopSession(newSession, true);
                if (!this.handleFatalError(thr)) {
                    LOG.warn("Failed to restart server", thr);
                }
            }
            finally {
                ClangServerAccessorImpl.this.myStateHolder.next(initState, new State(State.Stage.None, null));
            }
            return null;
        }

        private boolean handleFatalError(@NotNull Throwable thr) {
            FatalErrorException ex;
            if (thr == null) {
                ServerTask.$$$reportNull$$$0(6);
            }
            if ((ex = FatalErrorException.dynCast(thr)) == null) {
                return false;
            }
            if (ex.getFatalError() != ClangServerAccessorImpl.this.myLastFatalError) {
                ClangServerAccessorImpl.this.myLastFatalError = ex.getFatalError();
                if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!ClangServerAccessorImpl.this.myContext.isStopped()) {
                            Notifications.Bus.notify((Notification)new ClangDaemonNotification(ex.getMessage()), (Project)ClangServerAccessorImpl.this.myContext.getProject());
                        }
                    });
                }
                LOG.warn("Failed to restart server", thr);
            }
            return true;
        }

        private void waitForServer(@NotNull State initState, @NotNull Session session, long timeoutMs) throws TimeoutException, FatalErrorException {
            if (initState == null) {
                ServerTask.$$$reportNull$$$0(7);
            }
            if (session == null) {
                ServerTask.$$$reportNull$$$0(8);
            }
            assert (initState.stage == State.Stage.Initializing);
            long start = System.currentTimeMillis();
            CompletableFuture<Void> initFuture = CompletableFuture.allOf(session.serverCapabilities, session.serverInfo);
            while (!initFuture.isDone()) {
                try {
                    initFuture.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException exception) {
                }
                catch (Throwable thr) {
                    throw new FatalErrorException(ClangdFatalError.FailedToInitialize, "Failed to initialize server: " + thr.getMessage());
                }
                if (ClangServerAccessorImpl.this.myStateHolder.get() != initState) {
                    throw new IllegalStateException("Probably the clangd server was stopped before it is initialized");
                }
                if (System.currentTimeMillis() - start <= timeoutMs) continue;
                throw new TimeoutException("Waiting for clangd server to start up takes more than " + timeoutMs + "ms.");
            }
            if (!session.isInitialized()) {
                String errorsMsg = session.earlyErrors.getNow("capabilities are null");
                throw new FatalErrorException(ClangdFatalError.FailedToInitialize, "Failed to initialize server: " + errorsMsg);
            }
            ExtendedServerInfo info = (ExtendedServerInfo)CidrConcurrentUtilsKt.getIfCompletedNormally(session.serverInfo);
            if (info != null) {
                LOG.info("started " + info);
            }
        }

        private void startHealthMonitor(@NotNull Session session) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(9);
            }
            if (!Registry.is((String)"clion.clang.clangd.healthmonitor")) {
                return;
            }
            if (ClangServerAccessorImpl.this.myContext.getProject().getUserData(ClangDaemonContext.DISABLE_HEALTH_MONITOR) != null) {
                return;
            }
            session.healthMonitor.startMonitoring(() -> {
                @NonNls Object message = "HealthMonitor: deadlock in clangd? Had to kill and restart the server.";
                String stacktrace = ClangLanguageServiceUtils.getNativeStacktrace(session.connection);
                message = (String)message + "\nStacktrace:\n" + stacktrace;
                session.connection.kill();
                LOG.error((String)message);
            });
        }

        private void attachStopHandler(@NotNull Session session) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(10);
            }
            session.connection.getStopFuture().thenAccept(value -> {
                boolean isThisCrash = !ClangServerAccessorImpl.this.myContext.isStopped() && !session.isShutDown();
                boolean isThisShutDown = !ClangServerAccessorImpl.this.myContext.isStopped() && session.isShutDown();
                LOG.info("Received stop signal for " + ClangServerAccessorImpl.this.myContext.getDescriptor() + " (isThisCrash = " + isThisCrash + ", isThisShutDown = " + isThisShutDown + ")");
                ClangServerAccessorImpl.this.myContext.getLocalWorkspace().completePendingParses();
                ClangCrashHandler guard = ClangServerAccessorImpl.this.myContext.getCrashHandler();
                if (isThisCrash) {
                    guard.onServerFailure();
                } else {
                    guard.onServerStop();
                }
                ClangServerAccessorImpl.this.myContext.getCustomRequests().completeAllRequestsOnCrash();
                session.healthMonitor.stopMonitoring();
                ClangServerAccessorImpl.this.myContext.getTelemetry().getPreambleTelemetry().cleanupPreambleFilesAsync();
                if (!ClangServerAccessorImpl.this.myContext.isStopped()) {
                    ClangServerAccessorImpl.this.myContext.getIdeFacade().sendMessageLater(() -> {
                        if (ClangServerAccessorImpl.this.myContext.canPublishMessage()) {
                            LOG.info("Informing listeners about the stop signal (isThisCrash = " + isThisCrash + ", isThisShutDown = " + isThisShutDown + ")");
                            if (isThisCrash) {
                                ((ClangServerListener)ClangServerAccessorImpl.this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onServerFailure();
                            } else if (isThisShutDown) {
                                ((ClangServerListener)ClangServerAccessorImpl.this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onServerShutDown();
                            }
                        }
                    });
                }
            });
        }

        private void reportServerRunning(@NotNull Session session) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(11);
            }
            ClangServerAccessorImpl.this.myContext.getIdeFacade().sendMessageLater(() -> {
                if (ClangServerAccessorImpl.this.myContext.canPublishMessage()) {
                    ((ClangServerListener)ClangServerAccessorImpl.this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onServerRunning();
                }
            });
        }

        private void update(@NotNull Session newSession) {
            if (newSession == null) {
                ServerTask.$$$reportNull$$$0(12);
            }
            List<String> remoteUrls = ClangServerAccessorImpl.this.myRemoteWorkspace.getRegisteredUrls();
            ArrayList<FileRecoveryData> toProcess = new ArrayList<FileRecoveryData>(remoteUrls.size());
            String indexUri = ClangServerAccessorImpl.this.myRemoteWorkspace.getLoadedIndexParams();
            String graphUri = ClangServerAccessorImpl.this.myRemoteWorkspace.getLoadedGraphUri();
            Iterable<ClionSetCDBParams> cdbs = ClangServerAccessorImpl.this.myRemoteWorkspace.getCDBs();
            CLionModuleMappingParams cpp20ModuleMapping = ClangServerAccessorImpl.this.myRemoteWorkspace.getCpp20ModuleMapping();
            boolean isPaused = ClangServerAccessorImpl.this.myRemoteWorkspace.isPaused();
            ClangServerAccessorImpl.this.myRemoteWorkspace.modify(remoteUrls, mapOfFiles -> {
                for (RemoteWorkspaceFile wf : mapOfFiles.values()) {
                    FileRecoveryData recoveryData = FileRecoveryData.create(wf);
                    if (recoveryData != null) {
                        toProcess.add(recoveryData);
                        continue;
                    }
                    ClangUtils.traceClangd(LOG, "File " + wf.getUrl() + " will not be recovered because it has no remote version.");
                }
                ClangServerAccessorImpl.this.myRemoteWorkspace.clear();
            });
            toProcess.sort(Comparator.comparingInt(recoveryData -> recoveryData.isOpened ? 1 : 0));
            for (FileRecoveryData data : toProcess) {
                HashMap recovered = new HashMap();
                if (data.isOpened) {
                    this.recoverOpen(newSession, data, 0, recovered);
                } else if (!data.wasSaved) {
                    this.recoverChange(newSession, data, 0, recovered);
                }
                ServerTask.recoverCompilationCommand(data, recovered);
                this.applyRecovered(data.url, recovered);
            }
            if (indexUri != null) {
                this.recoverIndex(newSession, indexUri);
            }
            if (graphUri != null) {
                this.recoverGraph(newSession, graphUri);
            }
            this.recoverCDB(newSession, cdbs);
            if (cpp20ModuleMapping != null) {
                this.recoverCpp20ModuleMapping(newSession, cpp20ModuleMapping);
            }
            if (ClangServerAccessorImpl.this.myContext.isAnyIndexer()) {
                this.recoverIsPaused(newSession, isPaused);
            }
        }

        private void applyRecovered(@NotNull String url, @NotNull Map<WorkspaceFile.Key<?>, Object> recovered) {
            if (url == null) {
                ServerTask.$$$reportNull$$$0(13);
            }
            if (recovered == null) {
                ServerTask.$$$reportNull$$$0(14);
            }
            if (!recovered.isEmpty()) {
                ClangServerAccessorImpl.this.myRemoteWorkspace.modify(url, wf -> {
                    for (Map.Entry recoveredEntry : recovered.entrySet()) {
                        wf.put((WorkspaceFile.Key)recoveredEntry.getKey(), recoveredEntry.getValue());
                    }
                });
            }
        }

        private void recoverOpen(@NotNull Session session, @NotNull FileRecoveryData data, int customVersion, @NotNull Map<WorkspaceFile.Key<?>, Object> recovered) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(15);
            }
            if (data == null) {
                ServerTask.$$$reportNull$$$0(16);
            }
            if (recovered == null) {
                ServerTask.$$$reportNull$$$0(17);
            }
            assert (customVersion >= 0) : "Recovery is not reliable";
            assert (data.fileContent != null) : "No content in opened file?";
            ClangOpenNotification.OpenData openRequestData = ClangOpenNotification.doPrepare(ClangServerAccessorImpl.this.myContext, data.url, customVersion, data.fileContent, data.wasSaved);
            if (ClangOpenNotification.doSend(session.endpoints.getServer(), openRequestData)) {
                recovered.put(RemoteWorkspaceFile.IS_OPENED, true);
                recovered.put(RemoteWorkspaceFile.VERSION, customVersion);
                recovered.put(RemoteWorkspaceFile.OP_CLASS, ClangOpenNotification.class);
                recovered.put(RemoteWorkspaceFile.CONTENT, data.fileContent);
                recovered.put(RemoteWorkspaceFile.IS_SAVED, data.wasSaved);
            }
        }

        private void recoverReparse(@NotNull Session session, @NotNull FileRecoveryData data, int customVersion, @NotNull Map<WorkspaceFile.Key<?>, Object> recovered) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(18);
            }
            if (data == null) {
                ServerTask.$$$reportNull$$$0(19);
            }
            if (recovered == null) {
                ServerTask.$$$reportNull$$$0(20);
            }
            assert (customVersion >= 0);
            if (data.cc == null) {
                return;
            }
            if (!ClangRequestsHelper.isAllowedByGuard(ClangServerAccessorImpl.this.myContext, data.url)) {
                return;
            }
            ClionWantDiagnostics wantDiagnostics = ClionWantDiagnostics.fromValue(data.cc.getWantDiagnostics());
            assert (wantDiagnostics != null);
            ClionReparseTextDocumentParams newCC = new ClionReparseTextDocumentParams(new VersionedTextDocumentIdentifier(data.cc.getTextDocument().getUri(), Integer.valueOf(customVersion)), data.cc.getCompilationCommand(), data.cc.getClangTidyOptions(), data.cc.getUnusedIncludesInspectionMode(), data.cc.getClazyOptions(), wantDiagnostics, data.cc.getDFAOptions(), data.cc.getPreambleVersion());
            ClangReparseNotification.ReparseData reparseData = new ClangReparseNotification.ReparseData(ClangServerAccessorImpl.this.myContext, data.url, newCC);
            if (ClangReparseNotification.doSend(session.endpoints.getServer(), reparseData)) {
                recovered.put(RemoteWorkspaceFile.VERSION, customVersion);
                recovered.put(RemoteWorkspaceFile.OP_CLASS, ClangReparseNotification.class);
                recovered.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, newCC);
                recovered.put(RemoteWorkspaceFile.IS_PARSED, true);
            }
        }

        private void recoverChange(@NotNull Session session, @NotNull FileRecoveryData data, int customVersion, @NotNull Map<WorkspaceFile.Key<?>, Object> recovered) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(21);
            }
            if (data == null) {
                ServerTask.$$$reportNull$$$0(22);
            }
            if (recovered == null) {
                ServerTask.$$$reportNull$$$0(23);
            }
            assert (customVersion >= 0) : "Recovery is not reliable!";
            assert (data.fileContent != null);
            VersionedTextDocumentIdentifier versionedDocId = new VersionedTextDocumentIdentifier();
            versionedDocId.setUri(ClangServerAccessorImpl.this.myContext.getUrlConverter().toUriFromUrl(data.url));
            versionedDocId.setVersion(Integer.valueOf(customVersion));
            TextDocumentContentChangeEvent changeEvent = new TextDocumentContentChangeEvent();
            changeEvent.setText(data.fileContent);
            boolean success = ClangChangeNotification.doSend(session.endpoints.getServer(), new ClionDidChangeTextDocumentParams(versionedDocId, Collections.singletonList(changeEvent), false, customVersion));
            if (success) {
                recovered.put(RemoteWorkspaceFile.VERSION, customVersion);
                recovered.put(RemoteWorkspaceFile.OP_CLASS, ClangChangeNotification.class);
                recovered.put(RemoteWorkspaceFile.CONTENT, data.fileContent);
                recovered.put(RemoteWorkspaceFile.IS_SAVED, false);
            }
        }

        private static void recoverCompilationCommand(@NotNull FileRecoveryData data, @NotNull Map<WorkspaceFile.Key<?>, Object> recovered) {
            if (data == null) {
                ServerTask.$$$reportNull$$$0(24);
            }
            if (recovered == null) {
                ServerTask.$$$reportNull$$$0(25);
            }
            if (data.cc != null) {
                recovered.put(RemoteWorkspaceFile.REMOTE_COMPILATION_COMMAND, data.cc);
            }
        }

        private void recoverIndex(@NotNull Session session, @NotNull String indexUri) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(26);
            }
            if (indexUri == null) {
                ServerTask.$$$reportNull$$$0(27);
            }
            TextDocumentIdentifier id = new TextDocumentIdentifier(indexUri);
            ClionReloadIndexParams params = new ClionReloadIndexParams(Collections.emptyList(), id);
            new ClangReloadIndexNotification(params).send(session.endpoints.getServer(), ClangServerAccessorImpl.this.myRemoteWorkspace);
        }

        private void recoverGraph(@NotNull Session session, @NotNull String graphUri) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(28);
            }
            if (graphUri == null) {
                ServerTask.$$$reportNull$$$0(29);
            }
            new ClangReloadGraphNotification(new TextDocumentIdentifier(graphUri)).send(session.endpoints.getServer(), ClangServerAccessorImpl.this.myRemoteWorkspace);
        }

        private void recoverCDB(@NotNull Session session, @NotNull Iterable<ClionSetCDBParams> cdbs) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(30);
            }
            if (cdbs == null) {
                ServerTask.$$$reportNull$$$0(31);
            }
            for (ClionSetCDBParams params : cdbs) {
                new ClangSetCDBNotification(params).sendNotification(session.endpoints.getServer(), ClangServerAccessorImpl.this.myRemoteWorkspace);
            }
        }

        private void recoverCpp20ModuleMapping(@NotNull Session session, @NotNull CLionModuleMappingParams params) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(32);
            }
            if (params == null) {
                ServerTask.$$$reportNull$$$0(33);
            }
            session.endpoints.getServer().clionModuleMappingsChanged(params);
            ClangServerAccessorImpl.this.myRemoteWorkspace.setCpp20ModuleMapping(params);
        }

        private void recoverIsPaused(@NotNull Session session, boolean isPaused) {
            if (session == null) {
                ServerTask.$$$reportNull$$$0(34);
            }
            if (isPaused) {
                session.endpoints.getServer().clionIndexerCommand(new ClionIndexerCommandParams("pause", ""));
                ClangServerAccessorImpl.this.myRemoteWorkspace.setPaused(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$ServerTask";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 18: 
                case 21: 
                case 26: 
                case 28: 
                case 30: 
                case 32: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldState";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thr";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initState";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSession";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 14: 
                case 17: 
                case 20: 
                case 23: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recovered";
                    break;
                }
                case 16: 
                case 19: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexUri";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graphUri";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cdbs";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$ServerTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runCancellable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runWithSession";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareForRequest";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "recover";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleFatalError";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForServer";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "startHealthMonitor";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "attachStopHandler";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "reportServerRunning";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "applyRecovered";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverOpen";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverReparse";
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverChange";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverCompilationCommand";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverIndex";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverGraph";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverCDB";
                    break;
                }
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverCpp20ModuleMapping";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "recoverIsPaused";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FatalErrorException
    extends Exception {
        @NotNull
        private final ClangdFatalError myFatalError;

        private FatalErrorException(@NotNull ClangdFatalError fatalError, @NotNull String msg) {
            if (fatalError == null) {
                FatalErrorException.$$$reportNull$$$0(0);
            }
            if (msg == null) {
                FatalErrorException.$$$reportNull$$$0(1);
            }
            super(msg);
            this.myFatalError = fatalError;
        }

        private FatalErrorException(@NotNull ClangdFatalError fatalError, @NotNull String msg, @NotNull Throwable cause) {
            if (fatalError == null) {
                FatalErrorException.$$$reportNull$$$0(2);
            }
            if (msg == null) {
                FatalErrorException.$$$reportNull$$$0(3);
            }
            if (cause == null) {
                FatalErrorException.$$$reportNull$$$0(4);
            }
            super(msg, cause);
            this.myFatalError = fatalError;
        }

        @NotNull
        private ClangdFatalError getFatalError() {
            ClangdFatalError clangdFatalError = this.myFatalError;
            if (clangdFatalError == null) {
                FatalErrorException.$$$reportNull$$$0(5);
            }
            return clangdFatalError;
        }

        @Nullable
        private static FatalErrorException dynCast(@NotNull Throwable thr) {
            if (thr == null) {
                FatalErrorException.$$$reportNull$$$0(6);
            }
            if (thr instanceof FatalErrorException) {
                return (FatalErrorException)thr;
            }
            if (thr.getCause() instanceof FatalErrorException) {
                return (FatalErrorException)thr.getCause();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalError";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "msg";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cause";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$FatalErrorException";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$FatalErrorException";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFatalError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "dynCast";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ConnectionOutgoingLogger
    extends AbstractConnectionLogger {
        private ConnectionOutgoingLogger(@NotNull ClangDaemonContext context, @NotNull HealthMonitor healthMonitor) {
            if (context == null) {
                ConnectionOutgoingLogger.$$$reportNull$$$0(0);
            }
            if (healthMonitor == null) {
                ConnectionOutgoingLogger.$$$reportNull$$$0(1);
            }
            super(context, healthMonitor);
        }

        public void consume(Message message) throws MessageIssueException, JsonRpcException {
            this.myHealthMonitor.notifyOutgoing();
            if (ClangDebugLevel.isTraceOrMore()) {
                String messageContent = message.toString();
                if (!this.myContext.getMessagesFilter().matchesBlockedCommunication(messageContent)) {
                    ClangUtils.traceClangd(LOG, "Outgoing: " + messageContent);
                } else {
                    ClangUtils.traceClangd(LOG, "blocked outgoing message");
                }
            }
            this.notifyListeners(message, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "healthMonitor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$ConnectionOutgoingLogger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ConnectionIncomingLogger
    extends AbstractConnectionLogger {
        private ConnectionIncomingLogger(@NotNull ClangDaemonContext context, @NotNull HealthMonitor healthMonitor) {
            if (context == null) {
                ConnectionIncomingLogger.$$$reportNull$$$0(0);
            }
            if (healthMonitor == null) {
                ConnectionIncomingLogger.$$$reportNull$$$0(1);
            }
            super(context, healthMonitor);
        }

        public void consume(Message message) throws MessageIssueException, JsonRpcException {
            this.myHealthMonitor.notifyIncoming();
            if (ClangDebugLevel.isTraceOrMore()) {
                String messageContent = message.toString();
                if (!this.myContext.getMessagesFilter().matchesBlockedCommunication(messageContent)) {
                    ClangUtils.traceClangd(LOG, "Incoming: " + messageContent);
                } else {
                    ClangUtils.traceClangd(LOG, "blocked incoming message");
                }
            }
            this.notifyListeners(message, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "healthMonitor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$ConnectionIncomingLogger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AbstractConnectionLogger
    implements MessageConsumer {
        @NotNull
        protected final ClangDaemonContext myContext;
        @NotNull
        protected final HealthMonitor myHealthMonitor;

        AbstractConnectionLogger(@NotNull ClangDaemonContext context, @NotNull HealthMonitor healthMonitor) {
            if (context == null) {
                AbstractConnectionLogger.$$$reportNull$$$0(0);
            }
            if (healthMonitor == null) {
                AbstractConnectionLogger.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myHealthMonitor = healthMonitor;
        }

        protected final void notifyListeners(@NotNull Message message, boolean isIncoming) {
            if (message == null) {
                AbstractConnectionLogger.$$$reportNull$$$0(2);
            }
            this.myContext.getIdeFacade().sendMessageLater(() -> {
                if (this.myContext.canPublishMessage()) {
                    ((ClangServerListener)this.myContext.getMessageBus().syncPublisher(ClangServerListener.TOPIC)).onMessage(message, isIncoming);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "healthMonitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$AbstractConnectionLogger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyListeners";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ConnectionErrorsLogger
    implements Consumer<String> {
        @NotNull
        private final String myDescriptor;
        @NotNull
        private final ServerConnection myConnection;
        @NotNull
        private final HealthMonitor myHealthMonitor;
        @NotNull
        private final ClangMessagesFilter myMessagesFilter;
        @NotNull
        private final Consumer<String> myListener;
        private StringBuilder myStackDumpBuilder;
        private boolean myInsideStackDump;

        private ConnectionErrorsLogger(@NotNull String descriptor, @NotNull ServerConnection connection, @NotNull HealthMonitor healthMonitor, @NotNull ClangMessagesFilter messagesFilter, @NotNull Consumer<String> listener) {
            if (descriptor == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(0);
            }
            if (connection == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(1);
            }
            if (healthMonitor == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(2);
            }
            if (messagesFilter == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(3);
            }
            if (listener == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(4);
            }
            this.myStackDumpBuilder = new StringBuilder();
            this.myInsideStackDump = false;
            this.myDescriptor = descriptor;
            this.myConnection = connection;
            this.myHealthMonitor = healthMonitor;
            this.myMessagesFilter = messagesFilter;
            this.myListener = listener;
        }

        @Override
        public void accept(String line) {
            this.myHealthMonitor.notifyIncoming();
            if (StringUtil.isEmpty((String)line)) {
                return;
            }
            this.myListener.accept(line);
            if (line.contains("---Stack Dump Begin---")) {
                this.myInsideStackDump = true;
            } else if (line.contains("---Stack Dump End---")) {
                LOG.warn("clangd crash dump:\n" + this.myStackDumpBuilder);
                this.myInsideStackDump = false;
                this.myStackDumpBuilder = new StringBuilder();
                if (this.myConnection.isActive()) {
                    LOG.warn("clangd has crashed but is active for now, scheduling destroy.");
                    ScheduledFuture<?> scheduledShutdown = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                        if (this.myConnection.isActive()) {
                            LOG.warn("Destroying clangd.");
                            this.myConnection.kill();
                        }
                    }, 2000L, TimeUnit.MILLISECONDS);
                    this.myConnection.getStopFuture().thenAccept(exitCode -> scheduledShutdown.cancel(true));
                }
            } else if (this.myInsideStackDump) {
                this.myStackDumpBuilder.append(line).append('\n');
            } else if (ClangDebugLevel.isWarnOrMore() && !this.myMessagesFilter.matchesBlockedError(line)) {
                String descriptor = "main".contentEquals(this.myDescriptor) ? "" : "[" + this.myDescriptor + "]";
                LOG.warn("clangd" + descriptor + ": " + line);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "healthMonitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messagesFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$ConnectionErrorsLogger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HealthMonitor {
        private static final long CHECK_INTERVAL_MS = 45000L;
        @NotNull
        private final ClangCrashHandler myGuard;
        @NotNull
        private final AtomicInteger myInteractionsCounter;
        @NotNull
        private final AtomicInteger myServerTaskId;
        private volatile boolean myWerePendingInteractions;
        private volatile int myLastServerTaskId;
        @Nullable
        private volatile Runnable myKillCallback;
        @Nullable
        private volatile ScheduledFuture<?> myCancelFuture;

        HealthMonitor(@NotNull ClangCrashHandler guard) {
            if (guard == null) {
                HealthMonitor.$$$reportNull$$$0(0);
            }
            this.myInteractionsCounter = new AtomicInteger(0);
            this.myServerTaskId = new AtomicInteger(0);
            this.myGuard = guard;
        }

        void serverTaskStarted() {
            this.myServerTaskId.incrementAndGet();
        }

        void serverTaskEnded() {
            this.myServerTaskId.incrementAndGet();
        }

        void notifyOutgoing() {
            this.myInteractionsCounter.incrementAndGet();
        }

        void notifyIncoming() {
            this.myInteractionsCounter.incrementAndGet();
        }

        void checkHealth() {
            int serverTaskId = this.myServerTaskId.get();
            boolean isServerTaskInFlight = serverTaskId % 2 != 0;
            boolean hasPendingInteractions = this.myGuard.hasPendingInteractions();
            if (this.myWerePendingInteractions && hasPendingInteractions && this.myInteractionsCounter.get() == 0 && isServerTaskInFlight && serverTaskId == this.myLastServerTaskId) {
                Runnable killCallback = this.myKillCallback;
                assert (killCallback != null) : "Callback must not be null at this moment!";
                killCallback.run();
            } else {
                this.myWerePendingInteractions = hasPendingInteractions;
                this.myLastServerTaskId = serverTaskId;
                this.myInteractionsCounter.set(0);
            }
        }

        void startMonitoring(@NotNull Runnable killCallback) {
            if (killCallback == null) {
                HealthMonitor.$$$reportNull$$$0(1);
            }
            assert (this.myKillCallback == null) : "Why there is already a callback?";
            assert (this.myCancelFuture == null) : "Why there is already a monitor future?";
            this.myKillCallback = killCallback;
            this.myCancelFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::checkHealth, 45000L, 45000L, TimeUnit.MILLISECONDS);
        }

        void stopMonitoring() {
            ScheduledFuture<?> cancelFuture = this.myCancelFuture;
            if (cancelFuture != null) {
                cancelFuture.cancel(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "guard";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "killCallback";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$HealthMonitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startMonitoring";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FileRecoveryData {
        @NotNull
        public final String url;
        public final int version;
        public final boolean isOpened;
        @Nullable
        public final String fileContent;
        @Nullable
        public final ClionReparseTextDocumentParams cc;
        public final boolean wasSaved;

        private FileRecoveryData(@NotNull String url, int version, boolean isOpened, @Nullable String fileContent, @Nullable ClionReparseTextDocumentParams cc, boolean wasSaved) {
            if (url == null) {
                FileRecoveryData.$$$reportNull$$$0(0);
            }
            this.url = url;
            this.version = version;
            this.isOpened = isOpened;
            this.fileContent = fileContent;
            this.cc = cc;
            this.wasSaved = wasSaved;
        }

        @Nullable
        static FileRecoveryData create(@NotNull String url, @NotNull ClangRemoteWorkspace ws) {
            if (url == null) {
                FileRecoveryData.$$$reportNull$$$0(1);
            }
            if (ws == null) {
                FileRecoveryData.$$$reportNull$$$0(2);
            }
            return ws.apply(url, wf -> FileRecoveryData.create(wf));
        }

        @Nullable
        static FileRecoveryData create(@NotNull RemoteWorkspaceFile wf) {
            int version;
            if (wf == null) {
                FileRecoveryData.$$$reportNull$$$0(3);
            }
            if ((version = wf.getOrDefault(RemoteWorkspaceFile.VERSION).intValue()) < 0) {
                return null;
            }
            boolean isOpened = wf.getOrDefault(RemoteWorkspaceFile.IS_OPENED);
            String fileContent = wf.getOrDefault(RemoteWorkspaceFile.CONTENT);
            ClionReparseTextDocumentParams cc = wf.getReparseParams();
            boolean isSaved = wf.getOrDefault(RemoteWorkspaceFile.IS_SAVED);
            return new FileRecoveryData(wf.getUrl(), version, isOpened, fileContent, cc, isSaved);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ws";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wf";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangServerAccessorImpl$FileRecoveryData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

