/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangdCoroutineService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProviderListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.ClangScanLog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ClangScanEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.InitialScanFinishedEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanDocumentEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanFileSystemEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanIndexEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.ScanPathEvent;
import com.jetbrains.cidr.lang.daemon.clang.clangd.startup.scan.events.UpdateFromWorkspaceEvent;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\t\u001a\u00020\u000bJ\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\t\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR!\u0010\u0012\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangProjectScanStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "myQueueProcessor", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/startup/scan/events/ClangScanEvent;", "kotlin.jvm.PlatformType", "isInitialScanFinished", "Lcom/intellij/openapi/util/Ref;", "", "Lcom/intellij/openapi/util/Ref;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "TEST_SCAN_ACTIVITY_EXECUTED", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/annotations/NotNull;", "executeAndWait", "connectClangServerListener", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "doExecute", "dispose", "waitForQueueProcessor", "doScan", "scanEvent", "intellij.c.clangd"})
public final class ClangProjectScanStartupActivity
implements ProjectActivity,
Disposable {
    @NotNull
    private final QueueProcessor<ClangScanEvent> myQueueProcessor = new QueueProcessor(arg_0 -> ClangProjectScanStartupActivity.myQueueProcessor$lambda$1(arg_0 -> ClangProjectScanStartupActivity.myQueueProcessor$lambda$0(this, arg_0), arg_0));
    private Ref<Boolean> isInitialScanFinished = Ref.create((Object)false);
    @NotNull
    private final Key<Unit> TEST_SCAN_ACTIVITY_EXECUTED;

    public ClangProjectScanStartupActivity() {
        Key key = Key.create((String)"TEST_CLANG_SCAN_ACTIVITY_EXECUTED");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.TEST_SCAN_ACTIVITY_EXECUTED = key;
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Unit.INSTANCE;
        }
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(project);
        if (service == null) {
            MessageBusConnection connection = project.getMessageBus().connect();
            Topic<ClangLanguageServiceProviderListener> topic = ClangLanguageServiceProviderListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)new ClangLanguageServiceProviderListener(this, project, connection){
                final /* synthetic */ ClangProjectScanStartupActivity this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ MessageBusConnection $connection;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$connection = $connection;
                }

                public void onServiceStarted(ClangLanguageService service) {
                    Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                    ClangProjectScanStartupActivity.access$connectClangServerListener(this.this$0, service, this.$project);
                    this.$connection.disconnect();
                }
            });
        } else {
            this.doExecute(project);
        }
        return Unit.INSTANCE;
    }

    @TestOnly
    public final void executeAndWait(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.getUserData(this.TEST_SCAN_ACTIVITY_EXECUTED) != null) {
            ClangUtils.LOG.warn("Skipped running ClangProjectScanStartupActivity again");
            return;
        }
        project.putUserData(this.TEST_SCAN_ACTIVITY_EXECUTED, (Object)Unit.INSTANCE);
        this.doExecute(project);
        this.waitForQueueProcessor();
    }

    public final boolean isInitialScanFinished() {
        Object object = this.isInitialScanFinished.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private final void connectClangServerListener(ClangLanguageService service, Project project) {
        CoroutineScope coroutineScope = ClangdCoroutineService.Companion.getInstance(project).getCoroutineScope();
        SimpleMessageBusConnection connection = service.getMessageBus().connect(coroutineScope);
        Topic<ClangServerListener> topic = ClangServerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ClangServerListener(this, project, connection){
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$connection = $connection;
            }

            public void onServerRunning() {
                ClangProjectScanStartupActivity.access$doExecute(this.this$0, this.$project);
                this.$connection.disconnect();
            }
        });
    }

    private final void doExecute(Project project) {
        ClangScanLog.LOG.debug("Executing ClangProjectScanStartupActivity");
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        CoroutineScope coroutineScope = ClangdCoroutineService.Companion.getInstance(project).getCoroutineScope();
        Disposable disposable = CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope);
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myQueueProcessor.add((Object)new ScanFileSystemEvent(project));
        this.myQueueProcessor.add((Object)new ScanIndexEvent(project));
        this.myQueueProcessor.add((Object)new InitialScanFinishedEvent(this.isInitialScanFinished, project));
        if (DumbService.Companion.getInstance(project).isDumb()) {
            DumbService.Companion.getInstance(project).runWhenSmart(() -> ClangProjectScanStartupActivity.doExecute$lambda$2(this, project));
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkFileListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (!this.$project.isDisposed()) {
                    for (VFileEvent vFileEvent : events) {
                        ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new ScanPathEvent(vFileEvent, this.$project));
                    }
                }
            }
        });
        Topic topic2 = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new OCWorkspaceListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void workspaceChanged(OCWorkspaceListener.OCWorkspaceEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.$project.isDisposed()) {
                    ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new UpdateFromWorkspaceEvent(this.$project));
                }
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.$project.isDisposed()) {
                    ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new ScanDocumentEvent(event, this.$project));
                }
            }
        }, (Disposable)this);
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ ClangProjectScanStartupActivity this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void exitDumbMode() {
                if (!this.$project.isDisposed()) {
                    ClangProjectScanStartupActivity.access$getMyQueueProcessor$p(this.this$0).add((Object)new ScanIndexEvent(this.$project));
                }
            }
        });
    }

    public void dispose() {
        this.myQueueProcessor.clear();
    }

    @TestOnly
    public final void waitForQueueProcessor() {
        this.myQueueProcessor.waitFor();
    }

    private final void doScan(ClangScanEvent scanEvent) {
        if (((Boolean)ReadAction.compute(() -> ClangProjectScanStartupActivity.doScan$lambda$3(scanEvent))).booleanValue()) {
            return;
        }
        scanEvent.scan();
    }

    private static final Unit myQueueProcessor$lambda$0(ClangProjectScanStartupActivity this$0, ClangScanEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this$0.doScan(e);
        return Unit.INSTANCE;
    }

    private static final void myQueueProcessor$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void doExecute$lambda$2(ClangProjectScanStartupActivity this$0, Project $project) {
        this$0.myQueueProcessor.add((Object)new ScanIndexEvent($project));
    }

    private static final Boolean doScan$lambda$3(ClangScanEvent $scanEvent) {
        return $scanEvent.getProject().isDisposed();
    }

    public static final /* synthetic */ void access$connectClangServerListener(ClangProjectScanStartupActivity $this, ClangLanguageService service, Project project) {
        $this.connectClangServerListener(service, project);
    }

    public static final /* synthetic */ void access$doExecute(ClangProjectScanStartupActivity $this, Project project) {
        $this.doExecute(project);
    }

    public static final /* synthetic */ QueueProcessor access$getMyQueueProcessor$p(ClangProjectScanStartupActivity $this) {
        return $this.myQueueProcessor;
    }
}

