/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AddSuperCallFix;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.ModCommandLintQuickFix;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/lint/common/AndroidLintMissingSuperCallInspection;", "Lcom/android/tools/idea/lint/common/AndroidLintInspectionBase;", "<init>", "()V", "getQuickFixes", "", "Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "message", "", "fixData", "Lcom/android/tools/lint/detector/api/LintFix;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix;)[Lcom/android/tools/idea/lint/common/LintIdeQuickFix;", "intellij.lint"})
public final class AndroidLintMissingSuperCallInspection
extends AndroidLintInspectionBase {
    public AndroidLintMissingSuperCallInspection() {
        super(LintBundle.Companion.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (fixData != null) {
            PsiMethod psiMethod = LintFix.Companion.getMethod(fixData, "method");
            if (psiMethod != null) {
                PsiMethod method = psiMethod;
                boolean bl = false;
                LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[]{new ModCommandLintQuickFix((ModCommandAction)new AddSuperCallFix(startElement, method))};
                return lintIdeQuickFixArray;
            }
        }
        LintIdeQuickFix[] lintIdeQuickFixArray = super.getQuickFixes(startElement, endElement, message, fixData);
        Intrinsics.checkNotNullExpressionValue((Object)lintIdeQuickFixArray, (String)"getQuickFixes(...)");
        return lintIdeQuickFixArray;
    }
}

