/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.gradle.dcl.lang.DeclarativeLanguage;
import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.toml.lang.TomlLanguage;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J*\u0010\u001e\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintQuickFix;", "Lcom/intellij/modcommand/ModCommandQuickFix;", "Lcom/intellij/codeInspection/SuppressQuickFix;", "id", "", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "label", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "isSuppressAll", "getName", "getFamilyName", "perform", "Lcom/intellij/modcommand/ModCommand;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyFix", "Lcom/intellij/modcommand/ActionContext;", "handleXml", "", "handleJava", "handleGroovy", "handleToml", "handleDeclarative", "addNoInspectionComment", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "commentPrefix", "handleFile", "handleKotlin", "handleKotlinScript", "Companion", "intellij.lint"})
public final class SuppressLintQuickFix
extends ModCommandQuickFix
implements SuppressQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String label;
    @NotNull
    private static final String NO_INSPECTION_PREFIX = "noinspection ";

    public SuppressLintQuickFix(@NotNull String id, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.label = Companion.displayName(element, this.id);
    }

    public /* synthetic */ SuppressLintQuickFix(String string, PsiElement psiElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        this(string, psiElement);
    }

    public boolean isAvailable(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    public boolean isSuppressAll() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.label;
    }

    @NotNull
    public String getFamilyName() {
        return "Suppress";
    }

    @NotNull
    public ModCommand perform(@NotNull com.intellij.openapi.project.Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getStartElement(...)");
        ActionContext actionContext = ActionContext.from((ProblemDescriptor)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)actionContext, (String)"from(...)");
        return this.applyFix(psiElement, actionContext);
    }

    @NotNull
    public final ModCommand applyFix(@NotNull PsiElement element, @NotNull ActionContext context) {
        ModCommand modCommand;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Language language = element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            modCommand = SuppressLintQuickFix.applyFix$simplePsiUpdater(element, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>((Object)this){

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SuppressLintQuickFix.access$handleJava((SuppressLintQuickFix)((Object)this.receiver), p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
            modCommand = SuppressLintQuickFix.applyFix$simplePsiUpdater(element, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>((Object)this){

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SuppressLintQuickFix.access$handleXml((SuppressLintQuickFix)((Object)this.receiver), p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE)) {
            modCommand = SuppressLintQuickFix.applyFix$simplePsiUpdater(element, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>((Object)this){

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SuppressLintQuickFix.access$handleGroovy((SuppressLintQuickFix)((Object)this.receiver), p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            modCommand = SuppressLintQuickFix.applyFix$simplePsiUpdater(element, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>((Object)this){

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SuppressLintQuickFix.access$handleKotlin((SuppressLintQuickFix)((Object)this.receiver), p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)language, (Object)TomlLanguage.INSTANCE)) {
            modCommand = SuppressLintQuickFix.applyFix$simplePsiUpdater(element, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>((Object)this){

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SuppressLintQuickFix.access$handleToml((SuppressLintQuickFix)((Object)this.receiver), p0);
                }
            }));
        } else if (Intrinsics.areEqual((Object)language, (Object)DeclarativeLanguage.Companion.getINSTANCE())) {
            modCommand = SuppressLintQuickFix.applyFix$simplePsiUpdater(element, (Function1<? super PsiElement, Unit>)((Function1)new Function1<PsiElement, Unit>((Object)this){

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    SuppressLintQuickFix.access$handleDeclarative((SuppressLintQuickFix)((Object)this.receiver), p0);
                }
            }));
        } else {
            if (element instanceof PsiFile) {
                this.handleFile((PsiFile)element);
            }
            ModCommand modCommand2 = ModCommand.nop();
            Intrinsics.checkNotNull((Object)modCommand2);
            modCommand = modCommand2;
        }
        return modCommand;
    }

    private final void handleXml(PsiElement element) throws IncorrectOperationException {
        XmlFile xmlFile;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        if (tag instanceof XmlFile) {
            xmlFile = (XmlFile)tag;
        } else {
            PsiFile psiFile = tag.getContainingFile();
            xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            if (xmlFile == null) {
                return;
            }
        }
        XmlFile file = xmlFile;
        String lintId = Companion.getLintId(this.id);
        SuppressLintQuickFix.Companion.addSuppressAttribute(file, tag, lintId);
    }

    private final void handleJava(PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement = SuppressLintQuickFix.Companion.findJavaSuppressElement(element);
        if (psiElement == null) {
            return;
        }
        PsiElement container = psiElement;
        com.intellij.openapi.project.Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        com.intellij.openapi.project.Project project2 = project;
        if (container instanceof PsiImportStatementBase) {
            int offset = element.getTextOffset();
            com.intellij.openapi.project.Project project3 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            PsiFile psiFile = ((PsiImportStatementBase)container).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            SuppressLintQuickFix.addNoInspectionComment$default(this, project3, psiFile, offset, null, 8, null);
        } else if (container instanceof PsiModifierListOwner) {
            String lintId = StringsKt.removePrefix((String)this.id, (CharSequence)"AndroidLint");
            SuppressLintQuickFix.Companion.addSuppressAnnotation(project2, container, (PsiModifierListOwner)container, lintId);
        }
    }

    private final void handleGroovy(PsiElement element) throws IncorrectOperationException {
        PsiFile psiFile;
        if (element instanceof PsiFile) {
            psiFile = (PsiFile)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        PsiFile file = psiFile;
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        com.intellij.openapi.project.Project project2 = project;
        int offset = element.getTextOffset();
        SuppressLintQuickFix.addNoInspectionComment$default(this, project2, file, offset, null, 8, null);
    }

    private final void handleToml(PsiElement element) throws IncorrectOperationException {
        PsiFile psiFile;
        if (element instanceof PsiFile) {
            psiFile = (PsiFile)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        PsiFile file = psiFile;
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        com.intellij.openapi.project.Project project2 = project;
        int offset = element.getTextOffset();
        this.addNoInspectionComment(project2, file, offset, "#");
    }

    private final void handleDeclarative(PsiElement element) throws IncorrectOperationException {
        PsiFile psiFile;
        if (element instanceof PsiFile) {
            psiFile = (PsiFile)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        PsiFile file = psiFile;
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        com.intellij.openapi.project.Project project2 = project;
        int offset = element.getTextOffset();
        SuppressLintQuickFix.addNoInspectionComment$default(this, project2, file, offset, null, 8, null);
    }

    private final void addNoInspectionComment(com.intellij.openapi.project.Project project, PsiFile file, int offset, String commentPrefix) {
        int nonSpace;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((com.intellij.openapi.project.Project)project);
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        Document document2 = document;
        int line = document2.getLineNumber(offset);
        int lineStart = document2.getLineStartOffset(line);
        if (lineStart > 0) {
            int prevLineStart = document2.getLineStartOffset(line - 1);
            int prevLineEnd = document2.getLineEndOffset(line - 1);
            String string = document2.getText(new TextRange(prevLineStart, prevLineEnd));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String prevLine = string;
            int index = StringsKt.indexOf$default((CharSequence)prevLine, (String)NO_INSPECTION_PREFIX, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                document2.insertString(prevLineStart + index + 13, (CharSequence)(Companion.getLintId(this.id) + ","));
                return;
            }
        }
        String string = document2.getText(new TextRange(lineStart, offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String linePrefix = string;
        for (nonSpace = 0; nonSpace < linePrefix.length() && Character.isWhitespace(linePrefix.charAt(nonSpace)); ++nonSpace) {
        }
        String string2 = Companion.getLintId(this.id);
        String string3 = linePrefix.substring(0, nonSpace);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        document2.insertString(lineStart + nonSpace, (CharSequence)(commentPrefix + NO_INSPECTION_PREFIX + string2 + "\n" + string3));
        documentManager.commitDocument(document2);
    }

    static /* synthetic */ void addNoInspectionComment$default(SuppressLintQuickFix suppressLintQuickFix, com.intellij.openapi.project.Project project, PsiFile psiFile, int n, String string, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string = "//";
        }
        suppressLintQuickFix.addNoInspectionComment(project, psiFile, n, string);
    }

    private final void handleFile(PsiFile file) throws IncorrectOperationException {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            File dir;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
            File binaryFile = file2;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
            if (module != null && (dir = LintIdeProject.Companion.getLintProjectDirectory(module)) != null) {
                com.intellij.openapi.project.Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                com.intellij.openapi.project.Project project2 = project;
                LintIdeClient client = LintIdeSupport.createClient$default(LintIdeSupport.Companion.get(), project2, null, 2, null);
                Project lintProject = client.getProject(dir, dir);
                Configuration configuration = client.getConfiguration(lintProject, null);
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getConfiguration(...)");
                Configuration configuration2 = configuration;
                configuration2.ignore(this.id, binaryFile);
            }
        }
    }

    private final void handleKotlin(PsiElement element) throws IncorrectOperationException {
        if (SuppressLintQuickFix.Companion.isKotlinScript(element)) {
            this.handleKotlinScript(element);
            return;
        }
        PsiElement psiElement = SuppressLintQuickFix.Companion.findKotlinSuppressElement(element);
        if (psiElement == null) {
            return;
        }
        PsiElement target = psiElement;
        if (target instanceof KtModifierListOwner) {
            String argument = "\"" + Companion.getLintId(this.id) + "\"";
            AnnotationModificationUtilsKt.addAnnotation$default((KtModifierListOwner)((KtModifierListOwner)target), (ClassId)ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)ClassContext.Companion.getInternalName(SuppressLintQuickFix.Companion.getAnnotationClass(element)), (boolean)false, (int)2, null), (String)argument, null, (boolean)false, (String)(AnnotateQuickFixKt.isNewLineNeededForAnnotation((KtElement)target) ? "\n" : " "), arg_0 -> SuppressLintQuickFix.handleKotlin$lambda$1(argument, arg_0), (int)12, null);
        } else {
            int offset = element.getTextOffset();
            PsiFile file = target.getContainingFile();
            com.intellij.openapi.project.Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Intrinsics.checkNotNull((Object)file);
            SuppressLintQuickFix.addNoInspectionComment$default(this, project, file, offset, null, 8, null);
        }
    }

    private final void handleKotlinScript(PsiElement element) throws IncorrectOperationException {
        PsiFile psiFile;
        if (element instanceof PsiFile) {
            psiFile = (PsiFile)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        PsiFile file = psiFile;
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        com.intellij.openapi.project.Project project2 = project;
        int offset = element.getTextOffset();
        SuppressLintQuickFix.addNoInspectionComment$default(this, project2, file, offset, null, 8, null);
    }

    private static final void applyFix$simplePsiUpdater$lambda$0(Function1 $applyFixFun, PsiElement e, ModPsiUpdater modPsiUpdater) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)modPsiUpdater, (String)"<unused var>");
        $applyFixFun.invoke((Object)e);
    }

    private static final ModCommand applyFix$simplePsiUpdater(PsiElement $element, Function1<? super PsiElement, Unit> applyFixFun) {
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)$element, (arg_0, arg_1) -> SuppressLintQuickFix.applyFix$simplePsiUpdater$lambda$0(applyFixFun, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    private static final boolean handleKotlin$lambda$1(String $argument, KtAnnotationEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return SuppressLintQuickFix.Companion.addArgumentToAnnotation(entry, $argument);
    }

    public static final /* synthetic */ void access$handleJava(SuppressLintQuickFix $this, PsiElement element) {
        $this.handleJava(element);
    }

    public static final /* synthetic */ void access$handleXml(SuppressLintQuickFix $this, PsiElement element) {
        $this.handleXml(element);
    }

    public static final /* synthetic */ void access$handleGroovy(SuppressLintQuickFix $this, PsiElement element) {
        $this.handleGroovy(element);
    }

    public static final /* synthetic */ void access$handleKotlin(SuppressLintQuickFix $this, PsiElement element) {
        $this.handleKotlin(element);
    }

    public static final /* synthetic */ void access$handleToml(SuppressLintQuickFix $this, PsiElement element) {
        $this.handleToml(element);
    }

    public static final /* synthetic */ void access$handleDeclarative(SuppressLintQuickFix $this, PsiElement element) {
        $this.handleDeclarative(element);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J,\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\f\u0010!\u001a\u00020\u001c*\u00020\bH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\f\u0010#\u001a\u00020\u001c*\u00020\bH\u0002J\u0018\u0010$\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintQuickFix$Companion;", "", "<init>", "()V", "NO_INSPECTION_PREFIX", "", "getAnnotationClass", "context", "Lcom/intellij/psi/PsiElement;", "getLintId", "intentionId", "addSuppressAttribute", "", "file", "Lcom/intellij/psi/xml/XmlFile;", "element", "Lcom/intellij/psi/xml/XmlTag;", "id", "addSuppressAnnotation", "project", "Lcom/intellij/openapi/project/Project;", "container", "modifierOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "createNewAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "annotation", "addArgumentToAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "argument", "findJavaSuppressElement", "isKotlinScript", "findKotlinSuppressElement", "isSuppressLintTarget", "displayName", "inspectionId", "intellij.lint"})
    @SourceDebugExtension(value={"SMAP\nSuppressLintQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuppressLintQuickFix.kt\ncom/android/tools/idea/lint/common/SuppressLintQuickFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,447:1\n2632#2,3:448\n196#3:451\n196#3:452\n*S KotlinDebug\n*F\n+ 1 SuppressLintQuickFix.kt\ncom/android/tools/idea/lint/common/SuppressLintQuickFix$Companion\n*L\n382#1:448,3\n397#1:451\n398#1:452\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAnnotationClass(PsiElement context) {
            Module module;
            com.intellij.openapi.project.Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            com.intellij.openapi.project.Project project2 = project;
            Module module2 = module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            GlobalSearchScope scope = module2 != null ? module2.getModuleWithDependenciesAndLibrariesScope(false) : null;
            return scope != null && JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project2).findClass("android.annotation.SuppressLint", scope) != null ? "android.annotation.SuppressLint" : (Intrinsics.areEqual((Object)context.getLanguage(), (Object)KotlinLanguage.INSTANCE) ? "kotlin.Suppress" : "java.lang.SuppressWarnings");
        }

        @NotNull
        public final String getLintId(@NotNull String intentionId) {
            Intrinsics.checkNotNullParameter((Object)intentionId, (String)"intentionId");
            return StringsKt.removePrefix((String)intentionId, (CharSequence)"AndroidLint");
        }

        private final void addSuppressAttribute(XmlFile file, XmlTag element, String id) throws IncorrectOperationException {
            String string;
            XmlAttribute attribute = element.getAttribute("ignore", "http://schemas.android.com/tools");
            if (attribute == null || attribute.getValue() == null) {
                string = id;
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                Splitter splitter = Splitter.on((char)',').trimResults();
                String string2 = attribute.getValue();
                Intrinsics.checkNotNull((Object)string2);
                for (String existing : splitter.split((CharSequence)string2)) {
                    if (Intrinsics.areEqual((Object)existing, (Object)id)) continue;
                    ids.add(existing);
                }
                ids.add(id);
                CollectionsKt.sort((List)ids);
                String string3 = Joiner.on((char)',').join((Iterable)ids);
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            }
            String value = string;
            LintIdeSupport.Companion.get().ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
            element.setAttribute("ignore", "http://schemas.android.com/tools", value);
        }

        private final void addSuppressAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiModifierListOwner modifierOwner, String id) throws IncorrectOperationException {
            String annotationName = this.getAnnotationClass(container);
            String[] stringArray = new String[]{annotationName};
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])stringArray);
            PsiAnnotation newAnnotation = this.createNewAnnotation(project, container, annotation, id);
            if (newAnnotation != null) {
                if (annotation != null && !(annotation instanceof SyntheticElement)) {
                    v0 = annotation.replace((PsiElement)newAnnotation);
                } else {
                    PsiModifierList psiModifierList = modifierOwner.getModifierList();
                    if (psiModifierList == null) {
                        return;
                    }
                    PsiModifierList ownerModifierList = psiModifierList;
                    PsiNameValuePair[] psiNameValuePairArray = newAnnotation.getParameterList().getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"getAttributes(...)");
                    PsiNameValuePair[] attributes = psiNameValuePairArray;
                    PsiAnnotation psiAnnotation = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)annotationName, (PsiNameValuePair[])attributes, (PsiAnnotationOwner)((PsiAnnotationOwner)ownerModifierList));
                    if (psiAnnotation != null) {
                        PsiAnnotation it = psiAnnotation;
                        boolean bl = false;
                        v0 = JavaCodeStyleManager.getInstance((com.intellij.openapi.project.Project)project).shortenClassReferences((PsiElement)it);
                    } else {
                        v0 = null;
                    }
                }
            }
        }

        private final PsiAnnotation createNewAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiAnnotation annotation, String id) {
            if (annotation != null) {
                String currentSuppressedId = "\"" + id + "\"";
                String annotationText = annotation.getText();
                Intrinsics.checkNotNull((Object)annotationText);
                if (!StringsKt.contains$default((CharSequence)annotationText, (CharSequence)"{", (boolean)false, (int)2, null)) {
                    PsiNameValuePair[] psiNameValuePairArray = annotation.getParameterList().getAttributes();
                    Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"getAttributes(...)");
                    PsiNameValuePair[] attributes = psiNameValuePairArray;
                    if (attributes.length == 1) {
                        String suppressedWarnings = attributes[0].getText();
                        Intrinsics.checkNotNull((Object)suppressedWarnings);
                        return StringsKt.contains$default((CharSequence)suppressedWarnings, (CharSequence)currentSuppressedId, (boolean)false, (int)2, null) ? null : JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText("@" + this.getAnnotationClass(container) + "({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
                    }
                } else {
                    int curlyBraceIndex = StringsKt.lastIndexOf$default((CharSequence)annotationText, (char)'}', (int)0, (boolean)false, (int)6, null);
                    if (curlyBraceIndex > 0) {
                        String string = annotationText.substring(0, curlyBraceIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String oldSuppressWarning = string;
                        return StringsKt.contains$default((CharSequence)oldSuppressWarning, (CharSequence)currentSuppressedId, (boolean)false, (int)2, null) ? null : JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
                    }
                }
            } else {
                return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText("@" + this.getAnnotationClass(container) + "(\"" + id + "\")", container);
            }
            return null;
        }

        private final boolean addArgumentToAnnotation(KtAnnotationEntry entry, String argument) {
            KtValueArgumentList args = entry.getValueArgumentList();
            com.intellij.openapi.project.Project project = entry.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            KtValueArgumentList newArgList = psiFactory.createCallArguments("(" + argument + ")");
            if (args == null) {
                entry.addAfter((PsiElement)newArgList, entry.getLastChild());
            } else if (args.getArguments().isEmpty()) {
                args.replace((PsiElement)newArgList);
            } else {
                boolean bl;
                block8: {
                    List list = args.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                    Iterable $this$none$iv = list;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtValueArgument it = (KtValueArgument)element$iv;
                            boolean bl2 = false;
                            if (!it.textMatches((CharSequence)argument)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
                }
            }
            return true;
        }

        private final PsiElement findJavaSuppressElement(PsiElement element) {
            PsiElement psiElement;
            PsiModifierListOwner psiModifierListOwner = AnnotateQuickFixKt.findJavaAnnotationTarget(element);
            if (psiModifierListOwner != null) {
                psiElement = (PsiElement)psiModifierListOwner;
            } else {
                PsiElement $this$getParentOfType$iv;
                PsiElement psiElement2 = element;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                PsiImportStatementBase psiImportStatementBase = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiImportStatementBase.class, (boolean)strict$iv);
                if (psiImportStatementBase != null) {
                    psiElement = (PsiElement)psiImportStatementBase;
                } else {
                    $this$getParentOfType$iv = element;
                    strict$iv = false;
                    $i$f$getParentOfType = false;
                    psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiPackageStatement.class, (boolean)strict$iv);
                }
            }
            return psiElement;
        }

        private final boolean isKotlinScript(PsiElement $this$isKotlinScript) {
            Object object = $this$isKotlinScript.getContainingFile();
            return object != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)".kts", (boolean)false, (int)2, null) : false;
        }

        private final PsiElement findKotlinSuppressElement(PsiElement element) {
            return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, arg_0 -> Companion.findKotlinSuppressElement$lambda$3(Companion::findKotlinSuppressElement$lambda$2, arg_0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSuppressLintTarget(PsiElement $this$isSuppressLintTarget) {
            if ($this$isSuppressLintTarget instanceof KtDeclaration) {
                PsiElement psiElement = $this$isSuppressLintTarget;
                KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                if ((ktProperty != null ? LintIdeUtilsKt.hasBackingField(ktProperty) : true) && !($this$isSuppressLintTarget instanceof KtFunctionLiteral) && !($this$isSuppressLintTarget instanceof KtDestructuringDeclaration)) {
                    if (!($this$isSuppressLintTarget instanceof KtClassInitializer)) return true;
                }
            }
            if ($this$isSuppressLintTarget instanceof KtImportDirective) return true;
            if (!($this$isSuppressLintTarget instanceof KtPackageDirective)) return false;
            return true;
        }

        @NotNull
        public final String displayName(@Nullable PsiElement element, @NotNull String inspectionId) {
            Object object;
            Language language;
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            String id = this.getLintId(inspectionId);
            PsiElement psiElement = element;
            Object object2 = language = psiElement != null ? psiElement.getLanguage() : null;
            if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
                Object[] objectArray = new Object[]{id};
                object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.attr", objectArray);
            } else if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
                PsiElement target = this.findJavaSuppressElement(element);
                if (target instanceof PsiModifierListOwner) {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.annotation", objectArray);
                } else {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
                }
            } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
                PsiElement target = this.findKotlinSuppressElement(element);
                if (this.isKotlinScript(element)) {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
                } else if (target instanceof KtDeclaration) {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.annotation", objectArray);
                } else {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
                }
            } else if (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE)) {
                Object[] objectArray = new Object[]{id};
                object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
            } else if (Intrinsics.areEqual((Object)language, (Object)DeclarativeLanguage.Companion.getINSTANCE())) {
                Object[] objectArray = new Object[]{id};
                object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
            } else {
                object = "Suppress " + id;
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean findKotlinSuppressElement$lambda$2(PsiElement parent) {
            Intrinsics.checkNotNull((Object)parent);
            if (!Companion.isSuppressLintTarget(parent)) return false;
            if (!(parent instanceof KtElement)) return true;
            KtElement ktElement = (KtElement)parent;
            if (ktElement == null) return true;
            KtExpressionWithLabel ktExpressionWithLabel = Lint.firstLabelableParent((KtElement)ktElement);
            if (ktExpressionWithLabel != null) return false;
            return true;
        }

        private static final boolean findKotlinSuppressElement$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

