/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.annotations.concurrency.Slow;
import com.android.build.attribution.KnownGradlePluginsService;
import com.android.build.attribution.KnownGradlePluginsServiceKt;
import com.android.build.attribution.data.GradlePluginsData;
import com.android.tools.idea.downloads.DownloadService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ResourceUtil;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R \u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8W@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/KnownGradlePluginsServiceImpl;", "Lcom/android/tools/idea/downloads/DownloadService;", "Lcom/android/build/attribution/KnownGradlePluginsService;", "downloader", "Lcom/intellij/util/download/FileDownloader;", "cachePath", "Ljava/io/File;", "<init>", "(Lcom/intellij/util/download/FileDownloader;Ljava/io/File;)V", "()V", "value", "Lcom/android/build/attribution/data/GradlePluginsData;", "gradlePluginsData", "getGradlePluginsData", "()Lcom/android/build/attribution/data/GradlePluginsData;", "asyncRefresh", "", "loadFromFile", "url", "Ljava/net/URL;", "intellij.android.build-attribution"})
public final class KnownGradlePluginsServiceImpl
extends DownloadService
implements KnownGradlePluginsService {
    @NotNull
    private GradlePluginsData gradlePluginsData;

    public KnownGradlePluginsServiceImpl(@NotNull FileDownloader downloader, @NotNull File cachePath) {
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)cachePath, (String)"cachePath");
        super(downloader, "Known gradle plugins info", KnownGradlePluginsServiceKt.access$getFALLBACK_URL$p(), cachePath, "plugins.json");
        this.gradlePluginsData = GradlePluginsData.Companion.getEmptyData();
        this.asyncRefresh();
    }

    public KnownGradlePluginsServiceImpl() {
        DownloadableFileService $this$_init__u24lambda_u240 = DownloadableFileService.getInstance();
        KnownGradlePluginsServiceImpl knownGradlePluginsServiceImpl = this;
        boolean bl = false;
        FileDownloader fileDownloader = $this$_init__u24lambda_u240.createDownloader(CollectionsKt.listOf((Object)$this$_init__u24lambda_u240.createFileDescription("https://dl.google.com/android/studio/metadata/known_gradle_plugins.json", "plugins_temp.json")), "Known gradle plugins info");
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"createDownloader(...)");
        knownGradlePluginsServiceImpl(fileDownloader, KnownGradlePluginsServiceKt.access$getCACHE_PATH$p());
    }

    @Override
    @Slow
    @NotNull
    public GradlePluginsData getGradlePluginsData() {
        this.refreshSynchronously();
        return this.gradlePluginsData;
    }

    @Override
    public void asyncRefresh() {
        this.refresh(null, null);
    }

    public void loadFromFile(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String string = ResourceUtil.loadText((InputStream)URLUtil.openStream((URL)url));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String jsonString = string;
            this.gradlePluginsData = GradlePluginsData.Companion.loadFromJson(jsonString);
        }
        catch (IOException e) {
            Logger.getInstance(KnownGradlePluginsServiceImpl.class).error("Error while trying to load plugins file", (Throwable)e);
        }
    }
}

