/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.BuildDescriptor;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.text.DateFormatUtil;
import java.util.Comparator;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/build/attribution/ui/OpenBuildAnalyzerResultsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nOpenBuildAnalyzerResultsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenBuildAnalyzerResultsAction.kt\ncom/android/build/attribution/ui/OpenBuildAnalyzerResultsAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1062#2:79\n*S KotlinDebug\n*F\n+ 1 OpenBuildAnalyzerResultsAction.kt\ncom/android/build/attribution/ui/OpenBuildAnalyzerResultsAction\n*L\n53#1:79\n*E\n"})
public final class OpenBuildAnalyzerResultsAction
extends AnAction {
    public OpenBuildAnalyzerResultsAction() {
        super("Show Results Analysis of Previous Builds");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (!((Boolean)StudioFlags.BUILD_ANALYZER_HISTORY.get()).booleanValue() || project == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        BuildAnalyzerStorageManager buildAnalyzerStorageManager = BuildAnalyzerStorageManager.Companion.getInstance(project2);
        Iterable iterable = CollectionsKt.toList((Iterable)buildAnalyzerStorageManager.getListOfHistoricBuildDescriptors());
        boolean $i$f$sortedByDescending = false;
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BuildDescriptor it = (BuildDescriptor)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getBuildFinishedTimestamp());
                it = (BuildDescriptor)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getBuildFinishedTimestamp()));
            }
        })).setTitle("Build Analysis Results").setItemChosenCallback(arg_0 -> OpenBuildAnalyzerResultsAction.actionPerformed$lambda$2(arg_0 -> OpenBuildAnalyzerResultsAction.actionPerformed$lambda$1(project2, arg_0), arg_0)).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> OpenBuildAnalyzerResultsAction.actionPerformed$lambda$4(OpenBuildAnalyzerResultsAction::actionPerformed$lambda$3, arg_0, arg_1, arg_2))).createPopup().showInFocusCenter();
    }

    private static final Unit actionPerformed$lambda$1(Project $project, BuildDescriptor buildDescriptor) {
        BuildAttributionUiManager.Companion.getInstance($project).showBuildAnalysisReportById(buildDescriptor.getBuildSessionID());
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit actionPerformed$lambda$3(JBLabel label2, BuildDescriptor buildDescriptor, int n) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        String totalBuildTimeSec = BuildAttributionUIUtilKt.durationStringHtml(buildDescriptor.getTotalBuildTimeMs());
        String briefId = StringsKt.substringBefore$default((String)buildDescriptor.getBuildSessionID(), (char)'-', null, (int)2, null);
        String string = DateFormatUtil.formatDateTime((long)buildDescriptor.getBuildFinishedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(...)");
        String formattedTime = string;
        label2.setText(StringsKt.trimMargin$default((String)("\n            |<html>\n              |<body>\n                |Build duration: " + totalBuildTimeSec + "\n                |&emsp&emsp<font color=\"gray\">" + briefId + "</font>\n                |<br>\n                |" + formattedTime + "\n              |</body>\n            |</html>\n          "), null, (int)1, null));
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$4(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }
}

