/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.controllers;

import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J8\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00130\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/build/attribution/ui/controllers/ConfigurationCacheTestBuildFlowRunner;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "testConfigurationCacheBuildRequest", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "runningFirstConfigurationCacheBuild", "", "getRunningFirstConfigurationCacheBuild", "()Z", "setRunningFirstConfigurationCacheBuild", "(Z)V", "isTestConfigurationCacheBuild", "request", "startTestBuildsFlow", "", "originalBuildRequestData", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request$RequestData;", "isFeatureConsideredStable", "confirmationDialogHeader", "", "runFirstConfigurationCacheTestBuildWithConfirmation", "showFinalSuccessMessage", "scheduleRebuildWithCCOptionAndRunOnSuccess", "firstBuild", "onBuildFailure", "Lkotlin/Function1;", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleInvocationResult;", "onSuccess", "Lkotlin/Function0;", "showFailureMessage", "result", "Companion", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheTestBuildFlowRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheTestBuildFlowRunner.kt\ncom/android/build/attribution/ui/controllers/ConfigurationCacheTestBuildFlowRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class ConfigurationCacheTestBuildFlowRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private GradleBuildInvoker.Request testConfigurationCacheBuildRequest;
    private boolean runningFirstConfigurationCacheBuild;
    @NotNull
    private final String confirmationDialogHeader;

    public ConfigurationCacheTestBuildFlowRunner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.confirmationDialogHeader = "Configuration Cache Compatibility Assessment";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getRunningFirstConfigurationCacheBuild() {
        return this.runningFirstConfigurationCacheBuild;
    }

    public final void setRunningFirstConfigurationCacheBuild(boolean bl) {
        this.runningFirstConfigurationCacheBuild = bl;
    }

    public final boolean isTestConfigurationCacheBuild(@NotNull GradleBuildInvoker.Request request) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GradleBuildInvoker.Request request2 = this.testConfigurationCacheBuildRequest;
        if (request2 != null) {
            GradleBuildInvoker.Request it = request2;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)request);
        } else {
            bl = false;
        }
        return bl;
    }

    public final void startTestBuildsFlow(@NotNull GradleBuildInvoker.Request.RequestData originalBuildRequestData, boolean isFeatureConsideredStable) {
        Intrinsics.checkNotNullParameter((Object)originalBuildRequestData, (String)"originalBuildRequestData");
        this.runFirstConfigurationCacheTestBuildWithConfirmation(originalBuildRequestData, isFeatureConsideredStable);
    }

    private final void runFirstConfigurationCacheTestBuildWithConfirmation(GradleBuildInvoker.Request.RequestData originalBuildRequestData, boolean isFeatureConsideredStable) {
        ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> ConfigurationCacheTestBuildFlowRunner.runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4(this, originalBuildRequestData, isFeatureConsideredStable));
    }

    private final void showFinalSuccessMessage(boolean isFeatureConsideredStable, GradleBuildInvoker.Request.RequestData originalBuildRequestData) {
        ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> ConfigurationCacheTestBuildFlowRunner.showFinalSuccessMessage$lambda$5(isFeatureConsideredStable, this, originalBuildRequestData));
    }

    public final void scheduleRebuildWithCCOptionAndRunOnSuccess(@NotNull GradleBuildInvoker.Request.RequestData originalBuildRequestData, boolean firstBuild, @NotNull Function1<? super GradleInvocationResult, Unit> onBuildFailure, @NotNull Function0<Unit> onSuccess2) {
        GradleBuildInvoker.Request request;
        Intrinsics.checkNotNullParameter((Object)originalBuildRequestData, (String)"originalBuildRequestData");
        Intrinsics.checkNotNullParameter(onBuildFailure, (String)"onBuildFailure");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        this.testConfigurationCacheBuildRequest = request = new GradleBuildInvoker.Request.Builder(this.project, originalBuildRequestData, null).setCommandLineArguments(CollectionsKt.plus((Collection)originalBuildRequestData.getCommandLineArguments(), (Object)"--configuration-cache")).build();
        this.runningFirstConfigurationCacheBuild = firstBuild;
        ListenableFuture<GradleInvocationResult> future2 = GradleBuildInvoker.Companion.getInstance(this.project).executeTasks(request);
        Futures.addCallback(future2, (FutureCallback)((FutureCallback)new FutureCallback<GradleInvocationResult>(this, onSuccess2, onBuildFailure){
            final /* synthetic */ ConfigurationCacheTestBuildFlowRunner this$0;
            final /* synthetic */ Function0<Unit> $onSuccess;
            final /* synthetic */ Function1<GradleInvocationResult, Unit> $onBuildFailure;
            {
                this.this$0 = $receiver;
                this.$onSuccess = $onSuccess;
                this.$onBuildFailure = $onBuildFailure;
            }

            public void onSuccess(GradleInvocationResult result2) {
                this.this$0.setRunningFirstConfigurationCacheBuild(false);
                ConfigurationCacheTestBuildFlowRunner.access$setTestConfigurationCacheBuildRequest$p(this.this$0, null);
                GradleInvocationResult gradleInvocationResult = result2;
                Intrinsics.checkNotNull((Object)gradleInvocationResult);
                if (gradleInvocationResult.isBuildSuccessful()) {
                    this.$onSuccess.invoke();
                } else {
                    this.$onBuildFailure.invoke((Object)result2);
                }
            }

            public void onFailure(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.this$0.setRunningFirstConfigurationCacheBuild(false);
                ConfigurationCacheTestBuildFlowRunner.access$setTestConfigurationCacheBuildRequest$p(this.this$0, null);
                if (!(t instanceof CancellationException)) {
                    Logger.getInstance((String)"Build Analyzer").error("Unexpected error on running Configuration Cache trial build.", t);
                }
            }
        }), (Executor)MoreExecutors.directExecutor());
    }

    private final void showFailureMessage(GradleInvocationResult result2) {
        ActionsKt.invokeLater((ModalityState)ModalityState.nonModal(), () -> ConfigurationCacheTestBuildFlowRunner.showFailureMessage$lambda$6(result2, this));
    }

    private static final Unit runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4$lambda$3$lambda$2$lambda$1(ConfigurationCacheTestBuildFlowRunner this$0, boolean $isFeatureConsideredStable, GradleBuildInvoker.Request.RequestData $originalBuildRequestData) {
        this$0.showFinalSuccessMessage($isFeatureConsideredStable, $originalBuildRequestData);
        return Unit.INSTANCE;
    }

    private static final Unit runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4$lambda$3$lambda$2(ConfigurationCacheTestBuildFlowRunner this$0, GradleBuildInvoker.Request.RequestData $originalBuildRequestData, boolean $isFeatureConsideredStable) {
        this$0.scheduleRebuildWithCCOptionAndRunOnSuccess($originalBuildRequestData, false, (Function1<? super GradleInvocationResult, Unit>)((Function1)new Function1<GradleInvocationResult, Unit>((Object)this$0){

            public final void invoke(GradleInvocationResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ConfigurationCacheTestBuildFlowRunner.access$showFailureMessage((ConfigurationCacheTestBuildFlowRunner)this.receiver, p0);
            }
        }), (Function0<Unit>)((Function0)() -> ConfigurationCacheTestBuildFlowRunner.runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4$lambda$3$lambda$2$lambda$1(this$0, $isFeatureConsideredStable, $originalBuildRequestData)));
        return Unit.INSTANCE;
    }

    private static final Unit runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4$lambda$3(ConfigurationCacheTestBuildFlowRunner this$0, GradleBuildInvoker.Request.RequestData $originalBuildRequestData, boolean $isFeatureConsideredStable) {
        ActionsKt.invokeLater$default(null, () -> ConfigurationCacheTestBuildFlowRunner.runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4$lambda$3$lambda$2(this$0, $originalBuildRequestData, $isFeatureConsideredStable), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4(ConfigurationCacheTestBuildFlowRunner this$0, GradleBuildInvoker.Request.RequestData $originalBuildRequestData, boolean $isFeatureConsideredStable) {
        String[] stringArray = new String[]{"Run Builds", Messages.getCancelButton()};
        int confirmationResult = Messages.showIdeaMessageDialog((Project)this$0.project, (String)"This test will rerun the latest build twice to check that Gradle can serialize the task graph\nand then reuse it from the cache. The builds will run in the background and they will fail\nwith details if any incompatibilities are detected.", (String)this$0.confirmationDialogHeader, (String[])stringArray, (int)0, (Icon)Messages.getInformationIcon(), null);
        if (confirmationResult == 0) {
            this$0.scheduleRebuildWithCCOptionAndRunOnSuccess($originalBuildRequestData, true, (Function1<? super GradleInvocationResult, Unit>)((Function1)new Function1<GradleInvocationResult, Unit>((Object)this$0){

                public final void invoke(GradleInvocationResult p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ConfigurationCacheTestBuildFlowRunner.access$showFailureMessage((ConfigurationCacheTestBuildFlowRunner)this.receiver, p0);
                }
            }), (Function0<Unit>)((Function0)() -> ConfigurationCacheTestBuildFlowRunner.runFirstConfigurationCacheTestBuildWithConfirmation$lambda$4$lambda$3(this$0, $originalBuildRequestData, $isFeatureConsideredStable)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit showFinalSuccessMessage$lambda$5(boolean $isFeatureConsideredStable, ConfigurationCacheTestBuildFlowRunner this$0, GradleBuildInvoker.Request.RequestData $originalBuildRequestData) {
        String[] stringArray;
        String message = $isFeatureConsideredStable ? "Both trial builds with Configuration cache on were successful. You can turn on\nConfiguration cache in gradle.properties.\n\nNote: We only tested a basic scenario for your build compatibility with Configuration cache,\nthere may be more hidden incompatibilities with different tasks\u2019 runs in the future." : "Both trial builds with Configuration cache on were successful. You can turn on\nConfiguration cache in gradle.properties.\n\nNote: Configuration cache is an experimental feature of Gradle and there may be\nincompatibilities with different tasks\u2019 runs in the future.";
        int confirmationResult = Messages.showIdeaMessageDialog((Project)this$0.project, (String)message, (String)this$0.confirmationDialogHeader, (String[])(stringArray = new String[]{"Enable Configuration Cache", Messages.getCancelButton()}), (int)0, (Icon)Messages.getInformationIcon(), null);
        if (confirmationResult == 0) {
            StudioProvidedInfo.Companion.turnOnConfigurationCacheInProperties(this$0.project, $originalBuildRequestData, $isFeatureConsideredStable);
        }
        return Unit.INSTANCE;
    }

    private static final Unit showFailureMessage$lambda$6(GradleInvocationResult $result, ConfigurationCacheTestBuildFlowRunner this$0) {
        String[] stringArray;
        if ($result.isBuildCancelled()) {
            stringArray = new String[]{Messages.getOkButton()};
            Messages.showIdeaMessageDialog((Project)this$0.project, (String)"Build was cancelled.", (String)this$0.confirmationDialogHeader, (String[])stringArray, (int)0, (Icon)Messages.getInformationIcon(), null);
        }
        stringArray = new String[]{Messages.getOkButton()};
        Messages.showIdeaMessageDialog((Project)this$0.project, (String)"Build failed. Please, check build output for a detailed report of incompatibilities detected by Gradle.", (String)this$0.confirmationDialogHeader, (String[])stringArray, (int)0, (Icon)Messages.getErrorIcon(), null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setTestConfigurationCacheBuildRequest$p(ConfigurationCacheTestBuildFlowRunner $this, GradleBuildInvoker.Request request) {
        $this.testConfigurationCacheBuildRequest = request;
    }

    public static final /* synthetic */ void access$showFailureMessage(ConfigurationCacheTestBuildFlowRunner $this, GradleInvocationResult result2) {
        $this.showFailureMessage(result2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/attribution/ui/controllers/ConfigurationCacheTestBuildFlowRunner$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/build/attribution/ui/controllers/ConfigurationCacheTestBuildFlowRunner;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.build-attribution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigurationCacheTestBuildFlowRunner getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ConfigurationCacheTestBuildFlowRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ConfigurationCacheTestBuildFlowRunner)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

