/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.model.TaskDetailsPageType;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreeNode;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TasksTreeStructure;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010:\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020\u0017H\u0016J\u0012\u0010<\u001a\u00020\u000f2\b\u0010=\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u000204H\u0016J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020+H\u0016J$\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\nH\u0016J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u000204H\u0016J\b\u0010I\u001a\u00020\u000fH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R/\u0010\b\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u00118FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R$\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00105\u001a\u0002042\u0006\u0010*\u001a\u000204@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b6\u00107R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/build/attribution/ui/model/TasksDataPageModelImpl;", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;)V", "getReportData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "modelUpdatedListeners", "", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "treeStructureChanged", "", "listenersCount", "", "getListenersCount$annotations", "()V", "getListenersCount", "()I", "selectedGrouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "getSelectedGrouping", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "treeHeaderText", "", "getTreeHeaderText", "()Ljava/lang/String;", "totalTimeString", "getTotalTimeString", "filteredTimeString", "getFilteredTimeString", "treeRoot", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getTreeRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "selectedNode", "Lcom/android/build/attribution/ui/model/TasksTreeNode;", "getSelectedNode", "()Lcom/android/build/attribution/ui/model/TasksTreeNode;", "value", "Lcom/android/build/attribution/ui/model/TasksFilter;", "filter", "getFilter", "()Lcom/android/build/attribution/ui/model/TasksFilter;", "setFilter", "(Lcom/android/build/attribution/ui/model/TasksFilter;)V", "isEmpty", "()Z", "modelChanged", "Lcom/android/build/attribution/ui/model/TasksPageId;", "selectedPageId", "setSelectedPageId", "(Lcom/android/build/attribution/ui/model/TasksPageId;)V", "treeStructure", "Lcom/android/build/attribution/ui/model/TasksTreeStructure;", "selectGrouping", "newSelectedGrouping", "selectNode", "tasksTreeNode", "selectPageById", "tasksPageId", "applyFilter", "newFilter", "addModelUpdatedListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "getNodeDescriptorById", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "pageId", "notifyModelChanges", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTasksDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/TasksDataPageModelImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,436:1\n1863#2,2:437\n*S KotlinDebug\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/TasksDataPageModelImpl\n*L\n218#1:437,2\n*E\n"})
public final class TasksDataPageModelImpl
implements TasksDataPageModel {
    @NotNull
    private final BuildAttributionReportUiData reportData;
    @NotNull
    private final List<Function1<Boolean, Unit>> modelUpdatedListeners;
    @NotNull
    private TasksFilter filter;
    private boolean modelChanged;
    private boolean treeStructureChanged;
    @NotNull
    private TasksPageId selectedPageId;
    @NotNull
    private final TasksTreeStructure treeStructure;

    /*
     * WARNING - void declaration
     */
    public TasksDataPageModelImpl(@NotNull BuildAttributionReportUiData reportData) {
        void $this$treeStructure_u24lambda_u240;
        TasksTreeStructure tasksTreeStructure;
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        this.reportData = reportData;
        this.modelUpdatedListeners = new CopyOnWriteArrayList();
        this.filter = TasksFilter.Companion.getDEFAULT();
        this.selectedPageId = TasksPageId.Companion.emptySelection(this.getDefaultGrouping());
        TasksTreeStructure tasksTreeStructure2 = tasksTreeStructure = new TasksTreeStructure(this.getReportData());
        TasksDataPageModelImpl tasksDataPageModelImpl = this;
        boolean bl = false;
        $this$treeStructure_u24lambda_u240.updateStructure(this.getSelectedGrouping(), this.getFilter());
        tasksDataPageModelImpl.treeStructure = tasksTreeStructure;
    }

    @Override
    @NotNull
    public BuildAttributionReportUiData getReportData() {
        return this.reportData;
    }

    public final int getListenersCount() {
        return this.modelUpdatedListeners.size();
    }

    @VisibleForTesting
    public static /* synthetic */ void getListenersCount$annotations() {
    }

    @Override
    @NotNull
    public TasksDataPageModel.Grouping getSelectedGrouping() {
        return this.selectedPageId.getGrouping();
    }

    @Override
    @NotNull
    public String getTreeHeaderText() {
        return this.treeStructure.getTreeStats().getFiltersAreApplied() ? "Tasks duration - Total: " + this.getTotalTimeString() + ", Filtered: " + this.getFilteredTimeString() : "Tasks duration: " + this.getTotalTimeString();
    }

    private final String getTotalTimeString() {
        return BuildAttributionUIUtilKt.durationString(this.treeStructure.getTreeStats().getTotalTasksTimeMs());
    }

    private final String getFilteredTimeString() {
        return BuildAttributionUIUtilKt.durationString(this.treeStructure.getTreeStats().getFilteredTasksTimeMs());
    }

    @Override
    @NotNull
    public DefaultMutableTreeNode getTreeRoot() {
        return this.treeStructure.getTreeRoot();
    }

    @Override
    @Nullable
    public TasksTreeNode getSelectedNode() {
        return this.treeStructure.getPageIdToNode().get(this.selectedPageId);
    }

    @Override
    @NotNull
    public TasksFilter getFilter() {
        return this.filter;
    }

    private void setFilter(TasksFilter value2) {
        this.filter = value2;
        this.treeStructure.updateStructure(this.getSelectedGrouping(), value2);
        this.treeStructureChanged = true;
        this.modelChanged = true;
    }

    @Override
    public boolean isEmpty() {
        return this.getReportData().getCriticalPathTasks().getSize() == 0;
    }

    private final void setSelectedPageId(TasksPageId value2) {
        TasksPageId newSelectedPageId;
        TasksDataPageModel.Grouping newSelectedGrouping = value2.getGrouping();
        if (newSelectedGrouping != this.selectedPageId.getGrouping()) {
            this.treeStructure.updateStructure(newSelectedGrouping, this.getFilter());
            this.treeStructureChanged = true;
            this.modelChanged = true;
        }
        TasksPageId tasksPageId = newSelectedPageId = this.treeStructure.getPageIdToNode().containsKey(value2) ? value2 : TasksPageId.Companion.emptySelection(newSelectedGrouping);
        if (!Intrinsics.areEqual((Object)newSelectedPageId, (Object)this.selectedPageId)) {
            this.selectedPageId = newSelectedPageId;
            this.modelChanged = true;
        }
    }

    @Override
    public void selectGrouping(@NotNull TasksDataPageModel.Grouping newSelectedGrouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)newSelectedGrouping), (String)"newSelectedGrouping");
        TasksPageId currentPageId = this.selectedPageId;
        TasksPageId newSelectedPageId = currentPageId.getPageType() == TaskDetailsPageType.PLUGIN_DETAILS && newSelectedGrouping == TasksDataPageModel.Grouping.BY_PLUGIN || currentPageId.getPageType() == TaskDetailsPageType.TASK_CATEGORY_DETAILS && newSelectedGrouping == TasksDataPageModel.Grouping.BY_TASK_CATEGORY ? TasksPageId.Companion.emptySelection(newSelectedGrouping) : TasksPageId.copy$default(currentPageId, newSelectedGrouping, null, null, 6, null);
        this.setSelectedPageId(newSelectedPageId);
        this.notifyModelChanges();
    }

    @Override
    public void selectNode(@Nullable TasksTreeNode tasksTreeNode) {
        TasksDataPageModel.Grouping currentGrouping = this.getSelectedGrouping();
        Object object = tasksTreeNode;
        if (object == null || (object = ((TasksTreeNode)object).getDescriptor()) == null || (object = ((TasksTreePresentableNodeDescriptor)object).getPageId()) == null) {
            object = TasksPageId.Companion.emptySelection(currentGrouping);
        }
        this.setSelectedPageId((TasksPageId)object);
        this.notifyModelChanges();
    }

    @Override
    public void selectPageById(@NotNull TasksPageId tasksPageId) {
        Intrinsics.checkNotNullParameter((Object)tasksPageId, (String)"tasksPageId");
        this.setSelectedPageId(tasksPageId);
        this.notifyModelChanges();
    }

    @Override
    public void applyFilter(@NotNull TasksFilter newFilter) {
        Intrinsics.checkNotNullParameter((Object)newFilter, (String)"newFilter");
        this.setFilter(newFilter);
        this.notifyModelChanges();
    }

    @Override
    public void addModelUpdatedListener(@NotNull Disposable disposable, @NotNull Function1<? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.modelUpdatedListeners.add(listener2);
        Disposer.register((Disposable)disposable, () -> TasksDataPageModelImpl.addModelUpdatedListener$lambda$1(this, listener2));
    }

    @Override
    @Nullable
    public TasksTreePresentableNodeDescriptor getNodeDescriptorById(@NotNull TasksPageId pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        TasksTreeNode tasksTreeNode = this.treeStructure.getPageIdToNode().get(pageId);
        return tasksTreeNode != null ? tasksTreeNode.getDescriptor() : null;
    }

    private final void notifyModelChanges() {
        if (this.modelChanged) {
            Iterable $this$forEach$iv = this.modelUpdatedListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)this.treeStructureChanged);
            }
            this.treeStructureChanged = false;
            this.modelChanged = false;
        }
    }

    @Override
    @NotNull
    public List<TasksDataPageModel.Grouping> getAvailableGroupings() {
        return TasksDataPageModel.super.getAvailableGroupings();
    }

    @Override
    @NotNull
    public TasksDataPageModel.Grouping getDefaultGrouping() {
        return TasksDataPageModel.super.getDefaultGrouping();
    }

    private static final void addModelUpdatedListener$lambda$1(TasksDataPageModelImpl this$0, Function1 $listener) {
        this$0.modelUpdatedListeners.remove($listener);
    }
}

