/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.chart;

import com.android.build.attribution.ui.view.chart.ChartDrawableElement;
import com.android.build.attribution.ui.view.chart.ChartValueProvider;
import com.android.build.attribution.ui.view.chart.TimeDistributionTreeChartCalculationModel$refreshModel$;
import com.android.build.attribution.ui.view.chart.TimeDistributionTreeChartKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003HIJB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010<\u001a\u00020=H\u0002J\u000e\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020\u0007J\b\u0010@\u001a\u00020=H\u0007J\u0018\u0010A\u001a\u00020=2\b\u0010B\u001a\u0004\u0018\u00010\u00062\u0006\u0010C\u001a\u00020DJ\u0014\u0010E\u001a\b\u0018\u00010\fR\u00020\u00002\u0006\u0010F\u001a\u00020GR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0018\u00010\fR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0016\u001a\u00060\u0017R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u001a\u001a\u00060\u001bR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001a\u0010'\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010!\"\u0004\b)\u0010#R\u001a\u0010*\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#R\u001a\u0010-\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010!\"\u0004\b/\u0010#R\u001a\u00100\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010!\"\u0004\b2\u0010#R\u001a\u00103\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010!\"\u0004\b5\u0010#R\u001a\u00106\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010!\"\u0004\b8\u0010#R\u001a\u00109\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010!\"\u0004\b;\u0010#\u00a8\u0006K"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "", "treeModel", "Ljavax/swing/tree/TreeModel;", "treePathToCoordinates", "Lkotlin/Function1;", "Ljavax/swing/tree/TreePath;", "Ljava/awt/Rectangle;", "<init>", "(Ljavax/swing/tree/TreeModel;Lkotlin/jvm/functions/Function1;)V", "chartItems", "", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;", "getChartItems", "()Ljava/util/List;", "setChartItems", "(Ljava/util/List;)V", "hoveredItem", "getHoveredItem", "()Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;", "setHoveredItem", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;)V", "mergedItemsBar", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$MergedItemsBar;", "getMergedItemsBar", "()Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$MergedItemsBar;", "selectionArea", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartSelectionArea;", "getSelectionArea", "()Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartSelectionArea;", "rowColorBulletSizeScaledPx", "", "getRowColorBulletSizeScaledPx", "()I", "setRowColorBulletSizeScaledPx", "(I)V", "leftLineBreakingPointScaledPx", "getLeftLineBreakingPointScaledPx", "setLeftLineBreakingPointScaledPx", "rightLineBreakingPointScaledPx", "getRightLineBreakingPointScaledPx", "setRightLineBreakingPointScaledPx", "stackLeftBorderScaledPx", "getStackLeftBorderScaledPx", "setStackLeftBorderScaledPx", "stackWidthScaledPx", "getStackWidthScaledPx", "setStackWidthScaledPx", "selectionRightPointScaledPx", "getSelectionRightPointScaledPx", "setSelectionRightPointScaledPx", "stackBottomMarginScaledPx", "getStackBottomMarginScaledPx", "setStackBottomMarginScaledPx", "stackBarsSpacingScaledPx", "getStackBarsSpacingScaledPx", "setStackBarsSpacingScaledPx", "minStackBarSizeScaledPx", "getMinStackBarSizeScaledPx", "setMinStackBarSizeScaledPx", "calculateScaledConstantValues", "", "recalculateCoordinates", "visibleRect", "refreshModel", "refreshSelectionArea", "selectedPath", "isFocused", "", "itemByCoordinates", "p", "Ljava/awt/Point;", "ChartSelectionArea", "ChartRowItem", "MergedItemsBar", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTimeDistributionTreeChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeDistributionTreeChart.kt\ncom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n1863#2,2:454\n1557#2:458\n1628#2,3:459\n295#2,2:462\n477#3:456\n1#4:457\n*S KotlinDebug\n*F\n+ 1 TimeDistributionTreeChart.kt\ncom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel\n*L\n229#1:454,2\n250#1:458\n250#1:459,3\n270#1:462,2\n244#1:456\n*E\n"})
public final class TimeDistributionTreeChartCalculationModel {
    @NotNull
    private final TreeModel treeModel;
    @NotNull
    private final Function1<TreePath, Rectangle> treePathToCoordinates;
    @NotNull
    private List<ChartRowItem> chartItems;
    @Nullable
    private ChartRowItem hoveredItem;
    @NotNull
    private final MergedItemsBar mergedItemsBar;
    @NotNull
    private final ChartSelectionArea selectionArea;
    private int rowColorBulletSizeScaledPx;
    private int leftLineBreakingPointScaledPx;
    private int rightLineBreakingPointScaledPx;
    private int stackLeftBorderScaledPx;
    private int stackWidthScaledPx;
    private int selectionRightPointScaledPx;
    private int stackBottomMarginScaledPx;
    private int stackBarsSpacingScaledPx;
    private int minStackBarSizeScaledPx;

    public TimeDistributionTreeChartCalculationModel(@NotNull TreeModel treeModel, @NotNull Function1<? super TreePath, ? extends Rectangle> treePathToCoordinates) {
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter(treePathToCoordinates, (String)"treePathToCoordinates");
        this.treeModel = treeModel;
        this.treePathToCoordinates = treePathToCoordinates;
        this.chartItems = CollectionsKt.emptyList();
        this.mergedItemsBar = new MergedItemsBar();
        this.selectionArea = new ChartSelectionArea();
        this.refreshModel();
    }

    @NotNull
    public final List<ChartRowItem> getChartItems() {
        return this.chartItems;
    }

    public final void setChartItems(@NotNull List<ChartRowItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.chartItems = list;
    }

    @Nullable
    public final ChartRowItem getHoveredItem() {
        return this.hoveredItem;
    }

    public final void setHoveredItem(@Nullable ChartRowItem chartRowItem) {
        this.hoveredItem = chartRowItem;
    }

    @NotNull
    public final MergedItemsBar getMergedItemsBar() {
        return this.mergedItemsBar;
    }

    @NotNull
    public final ChartSelectionArea getSelectionArea() {
        return this.selectionArea;
    }

    public final int getRowColorBulletSizeScaledPx() {
        return this.rowColorBulletSizeScaledPx;
    }

    public final void setRowColorBulletSizeScaledPx(int n) {
        this.rowColorBulletSizeScaledPx = n;
    }

    public final int getLeftLineBreakingPointScaledPx() {
        return this.leftLineBreakingPointScaledPx;
    }

    public final void setLeftLineBreakingPointScaledPx(int n) {
        this.leftLineBreakingPointScaledPx = n;
    }

    public final int getRightLineBreakingPointScaledPx() {
        return this.rightLineBreakingPointScaledPx;
    }

    public final void setRightLineBreakingPointScaledPx(int n) {
        this.rightLineBreakingPointScaledPx = n;
    }

    public final int getStackLeftBorderScaledPx() {
        return this.stackLeftBorderScaledPx;
    }

    public final void setStackLeftBorderScaledPx(int n) {
        this.stackLeftBorderScaledPx = n;
    }

    public final int getStackWidthScaledPx() {
        return this.stackWidthScaledPx;
    }

    public final void setStackWidthScaledPx(int n) {
        this.stackWidthScaledPx = n;
    }

    public final int getSelectionRightPointScaledPx() {
        return this.selectionRightPointScaledPx;
    }

    public final void setSelectionRightPointScaledPx(int n) {
        this.selectionRightPointScaledPx = n;
    }

    public final int getStackBottomMarginScaledPx() {
        return this.stackBottomMarginScaledPx;
    }

    public final void setStackBottomMarginScaledPx(int n) {
        this.stackBottomMarginScaledPx = n;
    }

    public final int getStackBarsSpacingScaledPx() {
        return this.stackBarsSpacingScaledPx;
    }

    public final void setStackBarsSpacingScaledPx(int n) {
        this.stackBarsSpacingScaledPx = n;
    }

    public final int getMinStackBarSizeScaledPx() {
        return this.minStackBarSizeScaledPx;
    }

    public final void setMinStackBarSizeScaledPx(int n) {
        this.minStackBarSizeScaledPx = n;
    }

    private final void calculateScaledConstantValues() {
        this.rowColorBulletSizeScaledPx = JBUIScale.scale((int)10);
        this.stackLeftBorderScaledPx = JBUIScale.scale((int)100);
        this.stackWidthScaledPx = JBUIScale.scale((int)100);
        this.selectionRightPointScaledPx = JBUIScale.scale((int)203);
        this.stackBottomMarginScaledPx = JBUIScale.scale((int)20);
        this.stackBarsSpacingScaledPx = JBUIScale.scale((int)1);
        this.minStackBarSizeScaledPx = JBUIScale.scale((int)4);
        this.leftLineBreakingPointScaledPx = this.rowColorBulletSizeScaledPx + JBUIScale.scale((int)4);
        this.rightLineBreakingPointScaledPx = this.stackLeftBorderScaledPx - JBUIScale.scale((int)4);
    }

    public final void recalculateCoordinates(@NotNull Rectangle visibleRect) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        this.mergedItemsBar.getMergedItems().clear();
        this.calculateScaledConstantValues();
        int availableStackHeight = visibleRect.height - this.stackBottomMarginScaledPx;
        double pxPerPercent = (double)availableStackHeight / (double)100;
        int curY = 0;
        curY = visibleRect.y;
        Iterable $this$forEach$iv = this.chartItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartRowItem it = (ChartRowItem)element$iv;
            boolean bl = false;
            curY = it.recalculateCoordinates(pxPerPercent, curY);
        }
        curY = this.mergedItemsBar.recalculateCoordinates(pxPerPercent, curY);
        this.selectionArea.recalculateCoordinates();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void refreshModel() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = this.treeModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.TreeNode");
        Enumeration<? extends TreeNode> enumeration = ((TreeNode)object).children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)refreshModel$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List firstLevelNodes = SequencesKt.toList((Sequence)sequence);
        Iterable iterable = firstLevelNodes;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            ChartValueProvider chartValueProvider = (ChartValueProvider)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getRelativeWeight();
            d = d2 + d3;
        }
        double itemsSum = d;
        iterable = firstLevelNodes;
        TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel = this;
        boolean $i$f$map = false;
        void var6_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void node;
            ChartValueProvider chartValueProvider = (ChartValueProvider)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Color color = node.getItemColor();
            TreePath treePath = TreePathUtil.toTreePath((TreeNode)((TreeNode)node));
            double itemPercentage = (double)100 * node.getRelativeWeight() / itemsSum;
            Intrinsics.checkNotNull((Object)treePath);
            collection2.add(new ChartRowItem(treePath, itemPercentage, color));
        }
        timeDistributionTreeChartCalculationModel.chartItems = (List)destination$iv$iv;
    }

    public final void refreshSelectionArea(@Nullable TreePath selectedPath, boolean isFocused) {
        if (selectedPath == null) {
            this.selectionArea.setSelectedChartRowItem(null);
            this.selectionArea.setSelectionColor(null);
        } else {
            Object v0;
            ChartSelectionArea chartSelectionArea;
            block3: {
                Iterable iterable = this.chartItems;
                chartSelectionArea = this.selectionArea;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    ChartRowItem it = (ChartRowItem)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)selectedPath, (Object)it.getTreePath())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            chartSelectionArea.setSelectedChartRowItem(v0);
            this.selectionArea.setSelectionColor(UIUtil.getTreeSelectionBackground((boolean)isFocused));
        }
    }

    @Nullable
    public final ChartRowItem itemByCoordinates(@NotNull Point p) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Iterable $this$firstOrNull$iv = this.chartItems;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChartRowItem it = (ChartRowItem)element$iv;
                boolean bl = false;
                if (!it.contains(p)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0017J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00103\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00104\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0006\u00105\u001a\u00020&J\u000e\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u000208R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u00109\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0013\u00a8\u0006;"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;", "Lcom/android/build/attribution/ui/view/chart/ChartDrawableElement;", "treePath", "Ljavax/swing/tree/TreePath;", "itemNormalizedHeightPercentage", "", "keyColor", "Ljava/awt/Color;", "<init>", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;Ljavax/swing/tree/TreePath;DLjava/awt/Color;)V", "getTreePath", "()Ljavax/swing/tree/TreePath;", "getItemNormalizedHeightPercentage", "()D", "shadowColor", "Lcom/intellij/ui/JBColor;", "selected", "", "getSelected", "()Z", "hovered", "getHovered", "treeRowY", "", "getTreeRowY", "()I", "setTreeRowY", "(I)V", "treeRowHeight", "getTreeRowHeight", "setTreeRowHeight", "stackBarY", "getStackBarY", "setStackBarY", "stackBarHeight", "getStackBarHeight", "setStackBarHeight", "clickHandlingArea", "Ljava/awt/Polygon;", "getClickHandlingArea", "()Ljava/awt/Polygon;", "setClickHandlingArea", "(Ljava/awt/Polygon;)V", "recalculateCoordinates", "stackHeightPxPerPercent", "curY", "draw", "", "g", "Ljava/awt/Graphics;", "drawBullet", "drawStackBar", "drawConnectorLine", "toSelectionAreaPolygon", "contains", "p", "Ljava/awt/Point;", "shownAsSeparateBar", "getShownAsSeparateBar", "intellij.android.build-attribution"})
    public final class ChartRowItem
    implements ChartDrawableElement {
        @NotNull
        private final TreePath treePath;
        private final double itemNormalizedHeightPercentage;
        @NotNull
        private final Color keyColor;
        @NotNull
        private final JBColor shadowColor;
        private int treeRowY;
        private int treeRowHeight;
        private int stackBarY;
        private int stackBarHeight;
        @Nullable
        private Polygon clickHandlingArea;

        public ChartRowItem(TreePath treePath, @NotNull double itemNormalizedHeightPercentage, Color keyColor) {
            Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
            Intrinsics.checkNotNullParameter((Object)keyColor, (String)"keyColor");
            this.treePath = treePath;
            this.itemNormalizedHeightPercentage = itemNormalizedHeightPercentage;
            this.keyColor = keyColor;
            this.shadowColor = new JBColor(this.keyColor.darker(), this.keyColor.brighter());
        }

        @NotNull
        public final TreePath getTreePath() {
            return this.treePath;
        }

        public final double getItemNormalizedHeightPercentage() {
            return this.itemNormalizedHeightPercentage;
        }

        public final boolean getSelected() {
            return Intrinsics.areEqual((Object)TimeDistributionTreeChartCalculationModel.this.getSelectionArea().getSelectedChartRowItem(), (Object)this);
        }

        public final boolean getHovered() {
            return Intrinsics.areEqual((Object)TimeDistributionTreeChartCalculationModel.this.getHoveredItem(), (Object)this);
        }

        public final int getTreeRowY() {
            return this.treeRowY;
        }

        public final void setTreeRowY(int n) {
            this.treeRowY = n;
        }

        public final int getTreeRowHeight() {
            return this.treeRowHeight;
        }

        public final void setTreeRowHeight(int n) {
            this.treeRowHeight = n;
        }

        public final int getStackBarY() {
            return this.stackBarY;
        }

        public final void setStackBarY(int n) {
            this.stackBarY = n;
        }

        public final int getStackBarHeight() {
            return this.stackBarHeight;
        }

        public final void setStackBarHeight(int n) {
            this.stackBarHeight = n;
        }

        @Nullable
        public final Polygon getClickHandlingArea() {
            return this.clickHandlingArea;
        }

        public final void setClickHandlingArea(@Nullable Polygon polygon) {
            this.clickHandlingArea = polygon;
        }

        public final int recalculateCoordinates(double stackHeightPxPerPercent, int curY) {
            Rectangle rowBounds = (Rectangle)TimeDistributionTreeChartCalculationModel.this.treePathToCoordinates.invoke((Object)this.treePath);
            if (rowBounds == null) {
                this.treeRowY = 0;
                this.treeRowHeight = 0;
            } else {
                this.treeRowY = rowBounds.y;
                this.treeRowHeight = rowBounds.height;
            }
            this.stackBarY = curY + TimeDistributionTreeChartCalculationModel.this.getStackBarsSpacingScaledPx();
            this.stackBarHeight = (int)(stackHeightPxPerPercent * this.itemNormalizedHeightPercentage) - TimeDistributionTreeChartCalculationModel.this.getStackBarsSpacingScaledPx();
            this.clickHandlingArea = this.toSelectionAreaPolygon();
            if (!this.getShownAsSeparateBar()) {
                TimeDistributionTreeChartCalculationModel.this.getMergedItemsBar().getMergedItems().add(this);
                return curY;
            }
            return this.stackBarY + this.stackBarHeight;
        }

        @Override
        public void draw(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            this.drawBullet(g);
            if (this.getShownAsSeparateBar()) {
                this.drawStackBar(g);
                if (!this.getSelected()) {
                    this.drawConnectorLine(g);
                }
            }
        }

        private final void drawBullet(Graphics g) {
            int size = TimeDistributionTreeChartCalculationModel.this.getRowColorBulletSizeScaledPx();
            int y = this.treeRowY + (this.treeRowHeight - size) / 2;
            g.setColor(this.keyColor);
            g.fillRect(0, y, size, size);
            if (!this.getShownAsSeparateBar()) {
                g.setColor((Color)TimeDistributionTreeChartKt.access$getMERGED_ITEMS_COLOR$p());
                int[] nArray = new int[]{0, size, size};
                int[] nArray2 = nArray;
                nArray = new int[]{y + size, y + size, y};
                g.fillPolygon(nArray2, nArray, 3);
            }
            if (this.getHovered()) {
                g.setColor((Color)this.shadowColor);
                g.drawRect(0, y, size, size);
            }
        }

        private final void drawStackBar(Graphics g) {
            g.setColor(this.keyColor);
            g.fillRect(TimeDistributionTreeChartCalculationModel.this.getStackLeftBorderScaledPx(), this.stackBarY, TimeDistributionTreeChartCalculationModel.this.getStackWidthScaledPx(), this.stackBarHeight);
            if (this.getHovered()) {
                g.setColor((Color)this.shadowColor);
                g.drawRect(TimeDistributionTreeChartCalculationModel.this.getStackLeftBorderScaledPx(), this.stackBarY, TimeDistributionTreeChartCalculationModel.this.getStackWidthScaledPx(), this.stackBarHeight);
            }
        }

        private final void drawConnectorLine(Graphics g) {
            int leftMidY = this.treeRowY + this.treeRowHeight / 2;
            int rightMidY = this.stackBarY + this.stackBarHeight / 2;
            g.setColor(this.getHovered() ? (Color)this.shadowColor : this.keyColor);
            int[] nArray = new int[]{TimeDistributionTreeChartCalculationModel.this.getRowColorBulletSizeScaledPx(), TimeDistributionTreeChartCalculationModel.this.getLeftLineBreakingPointScaledPx(), TimeDistributionTreeChartCalculationModel.this.getRightLineBreakingPointScaledPx(), TimeDistributionTreeChartCalculationModel.this.getStackLeftBorderScaledPx()};
            int[] nArray2 = nArray;
            nArray = new int[]{leftMidY, leftMidY, rightMidY, rightMidY};
            g.drawPolyline(nArray2, nArray, 4);
        }

        @NotNull
        public final Polygon toSelectionAreaPolygon() {
            Polygon polygon = new Polygon();
            TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel = TimeDistributionTreeChartCalculationModel.this;
            Polygon $this$toSelectionAreaPolygon_u24lambda_u240 = polygon;
            boolean bl = false;
            int leftTopY = this.treeRowY;
            int leftBottomY = leftTopY + this.treeRowHeight;
            $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(0, leftTopY);
            $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(timeDistributionTreeChartCalculationModel.getLeftLineBreakingPointScaledPx(), leftTopY);
            if (this.getShownAsSeparateBar()) {
                int rightTopY = this.stackBarY - timeDistributionTreeChartCalculationModel.getStackBarsSpacingScaledPx();
                int rightBottomY = rightTopY + this.stackBarHeight + 2 * timeDistributionTreeChartCalculationModel.getStackBarsSpacingScaledPx();
                $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(timeDistributionTreeChartCalculationModel.getRightLineBreakingPointScaledPx(), rightTopY);
                $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(timeDistributionTreeChartCalculationModel.getSelectionRightPointScaledPx(), rightTopY);
                $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(timeDistributionTreeChartCalculationModel.getSelectionRightPointScaledPx(), rightBottomY);
                $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(timeDistributionTreeChartCalculationModel.getRightLineBreakingPointScaledPx(), rightBottomY);
            }
            $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(timeDistributionTreeChartCalculationModel.getLeftLineBreakingPointScaledPx(), leftBottomY);
            $this$toSelectionAreaPolygon_u24lambda_u240.addPoint(0, leftBottomY);
            return polygon;
        }

        public final boolean contains(@NotNull Point p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Polygon polygon = this.clickHandlingArea;
            return polygon != null ? polygon.contains(p) : false;
        }

        public final boolean getShownAsSeparateBar() {
            return this.stackBarHeight >= TimeDistributionTreeChartCalculationModel.this.getMinStackBarSizeScaledPx();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R \u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartSelectionArea;", "Lcom/android/build/attribution/ui/view/chart/ChartDrawableElement;", "<init>", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;)V", "selectedChartRowItem", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "getSelectedChartRowItem", "()Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;", "setSelectedChartRowItem", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;)V", "selectionColor", "Ljava/awt/Color;", "getSelectionColor", "()Ljava/awt/Color;", "setSelectionColor", "(Ljava/awt/Color;)V", "polygon", "Ljava/awt/Polygon;", "getPolygon", "()Ljava/awt/Polygon;", "setPolygon", "(Ljava/awt/Polygon;)V", "recalculateCoordinates", "", "draw", "g", "Ljava/awt/Graphics;", "intellij.android.build-attribution"})
    public final class ChartSelectionArea
    implements ChartDrawableElement {
        @Nullable
        private ChartRowItem selectedChartRowItem;
        @Nullable
        private Color selectionColor;
        @Nullable
        private Polygon polygon;

        @Nullable
        public final ChartRowItem getSelectedChartRowItem() {
            return this.selectedChartRowItem;
        }

        public final void setSelectedChartRowItem(@Nullable ChartRowItem chartRowItem) {
            this.selectedChartRowItem = chartRowItem;
        }

        @Nullable
        public final Color getSelectionColor() {
            return this.selectionColor;
        }

        public final void setSelectionColor(@Nullable Color color) {
            this.selectionColor = color;
        }

        @Nullable
        public final Polygon getPolygon() {
            return this.polygon;
        }

        public final void setPolygon(@Nullable Polygon polygon) {
            this.polygon = polygon;
        }

        public final void recalculateCoordinates() {
            ChartRowItem chartRowItem = this.selectedChartRowItem;
            this.polygon = chartRowItem != null ? chartRowItem.toSelectionAreaPolygon() : null;
        }

        @Override
        public void draw(@NotNull Graphics g) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Polygon polygon = this.polygon;
                if (polygon == null) break block0;
                Polygon it = polygon;
                boolean bl = false;
                g.setColor(this.selectionColor);
                g.fillPolygon(it);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$MergedItemsBar;", "Lcom/android/build/attribution/ui/view/chart/ChartDrawableElement;", "<init>", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;)V", "mergedItems", "", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$ChartRowItem;", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "getMergedItems", "()Ljava/util/List;", "posY", "", "getPosY", "()I", "setPosY", "(I)V", "heightPx", "getHeightPx", "setHeightPx", "recalculateCoordinates", "stackHeightPxPerPercent", "", "curY", "draw", "", "g", "Ljava/awt/Graphics;", "intellij.android.build-attribution"})
    @SourceDebugExtension(value={"SMAP\nTimeDistributionTreeChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeDistributionTreeChart.kt\ncom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel$MergedItemsBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n1#2:454\n*E\n"})
    public final class MergedItemsBar
    implements ChartDrawableElement {
        @NotNull
        private final List<ChartRowItem> mergedItems = new ArrayList();
        private int posY;
        private int heightPx;

        @NotNull
        public final List<ChartRowItem> getMergedItems() {
            return this.mergedItems;
        }

        public final int getPosY() {
            return this.posY;
        }

        public final void setPosY(int n) {
            this.posY = n;
        }

        public final int getHeightPx() {
            return this.heightPx;
        }

        public final void setHeightPx(int n) {
            this.heightPx = n;
        }

        /*
         * WARNING - void declaration
         */
        public final int recalculateCoordinates(double stackHeightPxPerPercent, int curY) {
            this.posY = 0;
            this.heightPx = 0;
            if (!((Collection)this.mergedItems).isEmpty()) {
                Iterable iterable = this.mergedItems;
                double d = 0.0;
                for (Object t : iterable) {
                    void it;
                    ChartRowItem chartRowItem = (ChartRowItem)t;
                    double d2 = d;
                    boolean bl = false;
                    double d3 = it.getItemNormalizedHeightPercentage();
                    d = d2 + d3;
                }
                double accumulatedNormalizedPercentageHeight = d;
                int stackBarHeightPx = (int)(stackHeightPxPerPercent * accumulatedNormalizedPercentageHeight) - TimeDistributionTreeChartCalculationModel.this.getStackBarsSpacingScaledPx();
                this.posY = curY + TimeDistributionTreeChartCalculationModel.this.getStackBarsSpacingScaledPx();
                this.heightPx = Math.max(stackBarHeightPx, TimeDistributionTreeChartCalculationModel.this.getMinStackBarSizeScaledPx());
                return this.posY + this.heightPx;
            }
            return curY;
        }

        @Override
        public void draw(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.heightPx > 0) {
                g.setColor((Color)TimeDistributionTreeChartKt.access$getMERGED_ITEMS_COLOR$p());
                g.fillRect(TimeDistributionTreeChartCalculationModel.this.getStackLeftBorderScaledPx(), this.posY, TimeDistributionTreeChartCalculationModel.this.getStackWidthScaledPx(), this.heightPx);
            }
        }
    }
}

