/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.diagnostic;

import com.android.build.diagnostic.WindowsDefenderCheckService;
import com.android.build.diagnostic.WindowsDefenderCheckServiceKt;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.google.wireless.android.sdk.stats.WindowsDefenderStatus;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.WindowsDefenderChecker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 12\u00020\u0001:\u000212B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0017J\u001c\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005J\u001e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0002J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0002J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u000bH\u0002J\b\u0010/\u001a\u00020\u0012H\u0002J\b\u00100\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00063"}, d2={"Lcom/android/build/diagnostic/WindowsDefenderCheckService;", "", "project", "Lcom/intellij/openapi/project/Project;", "checkerProvider", "Lkotlin/Function0;", "Lcom/intellij/diagnostic/WindowsDefenderChecker;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "(Lcom/intellij/openapi/project/Project;)V", "realTimeProtectionEnabledOnStartup", "", "Ljava/lang/Boolean;", "warningData", "Lcom/android/build/diagnostic/WindowsDefenderCheckService$WindowsDefenderWarningData;", "getWarningData", "()Lcom/android/build/diagnostic/WindowsDefenderCheckService$WindowsDefenderWarningData;", "checkRealTimeProtectionStatus", "", "runAutoExclusionScript", "eventSourcePage", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "callback", "Lkotlin/Function1;", "ignoreCheckForProject", "ignoreCheckGlobally", "ignoreCheck", "globally", "trackShowingManualInstructions", "logState", "status", "Lcom/google/wireless/android/sdk/stats/WindowsDefenderStatus$Status;", "logUserAction", "actionEventType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$EventType;", "notification", "Lcom/intellij/notification/Notification;", "content", "", "type", "Lcom/intellij/notification/NotificationType;", "showWarningNotification", "importantPaths", "", "Ljava/nio/file/Path;", "showResultNotification", "success", "showManualInstructions", "onIgnoreCallback", "Companion", "WindowsDefenderWarningData", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nWindowsDefenderCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsDefenderCheckService.kt\ncom/android/build/diagnostic/WindowsDefenderCheckService\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,259:1\n46#2,6:260\n*S KotlinDebug\n*F\n+ 1 WindowsDefenderCheckService.kt\ncom/android/build/diagnostic/WindowsDefenderCheckService\n*L\n118#1:260,6\n*E\n"})
public final class WindowsDefenderCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<WindowsDefenderChecker> checkerProvider;
    @Nullable
    private Boolean realTimeProtectionEnabledOnStartup;
    @NotNull
    private static final WindowsDefenderWarningData NO_WARNING = new WindowsDefenderWarningData(false, CollectionsKt.emptyList());
    @NotNull
    private static final String manualInstructionsLink = "https://d.android.com/r/tools/build-attribution/antivirus-check-manual-instructions";

    public WindowsDefenderCheckService(@NotNull Project project, @NotNull Function0<? extends WindowsDefenderChecker> checkerProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(checkerProvider, (String)"checkerProvider");
        this.project = project;
        this.checkerProvider = checkerProvider;
    }

    public WindowsDefenderCheckService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, (Function0<? extends WindowsDefenderChecker>)((Function0)WindowsDefenderCheckService::_init_$lambda$0));
    }

    @NotNull
    public final WindowsDefenderWarningData getWarningData() {
        WindowsDefenderChecker checker;
        if (Intrinsics.areEqual((Object)this.realTimeProtectionEnabledOnStartup, (Object)true) && TrustedProjects.isTrusted((Project)this.project) && !(checker = (WindowsDefenderChecker)this.checkerProvider.invoke()).isStatusCheckIgnored(this.project)) {
            List list = checker.getPathsToExclude(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathsToExclude(...)");
            List paths = list;
            return new WindowsDefenderWarningData(true, paths);
        }
        return NO_WARNING;
    }

    public final void checkRealTimeProtectionStatus() {
        try {
            WindowsDefenderChecker checker = (WindowsDefenderChecker)this.checkerProvider.invoke();
            if (checker.isStatusCheckIgnored(this.project)) {
                WindowsDefenderCheckServiceKt.access$getLOG$p().info("status check is disabled");
                this.logState(WindowsDefenderStatus.Status.CHECK_IGNORED);
                return;
            }
            Boolean protection = checker.isRealTimeProtectionEnabled();
            WindowsDefenderCheckServiceKt.access$getLOG$p().info("real-time protection: " + protection);
            this.realTimeProtectionEnabledOnStartup = protection;
            if (protection == null) {
                this.logState(WindowsDefenderStatus.Status.UNKNOWN_STATUS);
            } else if (Intrinsics.areEqual((Object)protection, (Object)false)) {
                this.logState(WindowsDefenderStatus.Status.SCANNING_DISABLED);
            } else if (protection.booleanValue()) {
                WindowsDefenderStatus.Status state2 = WindowsDefenderStatus.Status.ENABLED_AUTO;
                this.logState(state2);
                List list = checker.getPathsToExclude(this.project);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathsToExclude(...)");
                this.showWarningNotification(list);
            }
        }
        catch (Throwable t) {
            WindowsDefenderCheckServiceKt.access$getLOG$p().error("Error reading Windows Defender status", t);
            this.realTimeProtectionEnabledOnStartup = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void runAutoExclusionScript(@NotNull BuildAttributionUiEvent.Page.PageType eventSourcePage, @NotNull Function1<? super Boolean, Unit> callback2) {
        void title$iv;
        void project$iv;
        Intrinsics.checkNotNullParameter((Object)eventSourcePage, (String)"eventSourcePage");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        WindowsDefenderChecker checker = (WindowsDefenderChecker)this.checkerProvider.invoke();
        WindowsDefenderCheckServiceKt.access$getLOG$p().info("Try exclude project paths");
        List list = checker.getPathsToExclude(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathsToExclude(...)");
        List paths = list;
        String string = DiagnosticBundle.message((String)"defender.config.progress", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Project project = this.project;
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, checker, this, paths, eventSourcePage, callback2){
            final /* synthetic */ WindowsDefenderChecker $checker$inlined;
            final /* synthetic */ WindowsDefenderCheckService this$0;
            final /* synthetic */ List $paths$inlined;
            final /* synthetic */ BuildAttributionUiEvent.Page.PageType $eventSourcePage$inlined;
            final /* synthetic */ Function1 $callback$inlined;
            {
                this.$checker$inlined = windowsDefenderChecker;
                this.this$0 = windowsDefenderCheckService;
                this.$paths$inlined = list;
                this.$eventSourcePage$inlined = pageType;
                this.$callback$inlined = function1;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                boolean success = this.$checker$inlined.excludeProjectPaths(WindowsDefenderCheckService.access$getProject$p(this.this$0), this.$paths$inlined);
                if (success) {
                    WindowsDefenderCheckService.access$ignoreCheck(this.this$0, false, runAutoExclusionScript.1.1.INSTANCE);
                    WindowsDefenderCheckService.access$logUserAction(this.this$0, BuildAttributionUiEvent.EventType.DEFENDER_WARNING_AUTO_EXCLUDE_SUCCESS, this.$eventSourcePage$inlined);
                } else {
                    WindowsDefenderCheckService.access$logUserAction(this.this$0, BuildAttributionUiEvent.EventType.DEFENDER_WARNING_AUTO_EXCLUDE_FAILURE, this.$eventSourcePage$inlined);
                }
                this.$callback$inlined.invoke((Object)success);
            }
        });
    }

    public final void ignoreCheckForProject(@NotNull BuildAttributionUiEvent.Page.PageType eventSourcePage, @NotNull Function0<Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)eventSourcePage, (String)"eventSourcePage");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        WindowsDefenderCheckServiceKt.access$getLOG$p().info("Suppress warning for the project clicked");
        this.ignoreCheck(false, callback2);
        this.logUserAction(BuildAttributionUiEvent.EventType.DEFENDER_WARNING_SUPPRESS_CLICKED, eventSourcePage);
    }

    private final void ignoreCheckGlobally(BuildAttributionUiEvent.Page.PageType eventSourcePage, Function0<Unit> callback2) {
        WindowsDefenderCheckServiceKt.access$getLOG$p().info("Suppress warning globally");
        this.ignoreCheck(true, callback2);
        this.logUserAction(BuildAttributionUiEvent.EventType.DEFENDER_WARNING_SUPPRESS_GLOBALLY_CLICKED, eventSourcePage);
    }

    private final void ignoreCheck(boolean globally, Function0<Unit> callback2) {
        WindowsDefenderCheckServiceKt.access$getLOG$p().info("Suppressing check, globally=" + globally);
        Project projectToUse = globally ? null : this.project;
        ((WindowsDefenderChecker)this.checkerProvider.invoke()).ignoreStatusCheck(projectToUse, true);
        callback2.invoke();
    }

    public final void trackShowingManualInstructions(@NotNull BuildAttributionUiEvent.Page.PageType eventSourcePage) {
        Intrinsics.checkNotNullParameter((Object)eventSourcePage, (String)"eventSourcePage");
        this.logUserAction(BuildAttributionUiEvent.EventType.DEFENDER_WARNING_MANUAL_INSTRUCTIONS_CLICKED, eventSourcePage);
    }

    private final void logState(WindowsDefenderStatus.Status status2) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        AndroidStudioEvent.Builder builder2 = UsageTrackerUtils.withProjectId(builder, this.project).setKind(AndroidStudioEvent.EventKind.WINDOWS_DEFENDER_STATUS).setWindowsDefenderStatus(WindowsDefenderStatus.newBuilder().setStatus(status2));
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setWindowsDefenderStatus(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder2);
    }

    /*
     * WARNING - void declaration
     */
    private final void logUserAction(BuildAttributionUiEvent.EventType actionEventType, BuildAttributionUiEvent.Page.PageType eventSourcePage) {
        void $this$logUserAction_u24lambda_u242;
        BuildAttributionUiEvent.Builder builder;
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.BUILD_ATTRIBUTION_UI_EVENT);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"setKind(...)");
        BuildAttributionUiEvent.Builder builder3 = builder = BuildAttributionUiEvent.newBuilder();
        AndroidStudioEvent.Builder builder4 = UsageTrackerUtils.withProjectId(builder2, this.project);
        boolean bl = false;
        $this$logUserAction_u24lambda_u242.setCurrentPage(BuildAttributionUiEvent.Page.newBuilder().setPageType(eventSourcePage).setPageEntryIndex(1).build());
        $this$logUserAction_u24lambda_u242.setEventType(actionEventType);
        AndroidStudioEvent.Builder builder5 = builder4.setBuildAttributionUiEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"setBuildAttributionUiEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder5);
    }

    private final Notification notification(@NlsContexts.NotificationContent String content2, NotificationType type) {
        return new Notification("WindowsDefender", DiagnosticBundle.message((String)"notification.group.defender.config", (Object[])new Object[0]), content2, type);
    }

    private final void showWarningNotification(List<? extends Path> importantPaths) {
        Notification notification;
        if (!TrustedProjects.isTrusted((Project)this.project)) {
            return;
        }
        String pathList = CollectionsKt.joinToString$default((Iterable)importantPaths, (CharSequence)"<br>&nbsp;&nbsp;", (CharSequence)"<br>&nbsp;&nbsp;", null, (int)0, null, WindowsDefenderCheckService::showWarningNotification$lambda$3, (int)28, null);
        String string = DiagnosticBundle.message((String)"defender.config.suppress1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String ignoreForProject = string;
        String string2 = DiagnosticBundle.message((String)"exclude.folders", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String auto = string2;
        String string3 = DiagnosticBundle.message((String)"defender.config.manual", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String manual = string3;
        Object[] objectArray = new Object[]{pathList, auto, ignoreForProject};
        String string4 = AndroidBundle.message("android.defender.config.prompt", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Notification it = notification = this.notification(string4, NotificationType.INFORMATION);
        boolean bl = false;
        it.setImportant(true);
        it.setCollapseDirection(Notification.CollapseActionsDirection.KEEP_LEFTMOST);
        notification.addAction((AnAction)NotificationAction.createSimple((String)auto, () -> WindowsDefenderCheckService.showWarningNotification$lambda$5(this))).addAction((AnAction)NotificationAction.createSimple((String)manual, this::showManualInstructions)).addAction((AnAction)NotificationAction.createSimpleExpiring((String)ignoreForProject, () -> WindowsDefenderCheckService.showWarningNotification$lambda$6(this))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DiagnosticBundle.message((String)"defender.config.suppress2", (Object[])new Object[0]), () -> WindowsDefenderCheckService.showWarningNotification$lambda$7(this))).notify(this.project);
    }

    private final void showResultNotification(boolean success) {
        if (success) {
            String string = DiagnosticBundle.message((String)"defender.config.success", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.notification(string, NotificationType.INFORMATION).notify(this.project);
        } else {
            String string = DiagnosticBundle.message((String)"defender.config.suppress1", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String ignoreForProject = string;
            String string2 = AndroidBundle.message("android.defender.config.failed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.notification(string2, NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimple((String)ActionsBundle.message((String)"show.log.notification.text", (Object[])new Object[0]), ShowLogAction::showLog)).addAction((AnAction)NotificationAction.createSimple((String)AndroidBundle.message("android.defender.config.failed.instructions", new Object[0]), this::showManualInstructions)).addAction((AnAction)NotificationAction.createSimpleExpiring((String)ignoreForProject, () -> WindowsDefenderCheckService.showResultNotification$lambda$8(this))).notify(this.project);
        }
    }

    private final void showManualInstructions() {
        BrowserUtil.browse((String)manualInstructionsLink);
        this.trackShowingManualInstructions(BuildAttributionUiEvent.Page.PageType.WINDOWS_DEFENDER_NOTIFICATION);
    }

    private final void onIgnoreCallback() {
        String action2 = ActionsBundle.message((String)"action.ResetWindowsDefenderNotification.text", (Object[])new Object[0]);
        Object[] objectArray = new Object[]{action2};
        String string = DiagnosticBundle.message((String)"defender.config.restore", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.notification(string, NotificationType.INFORMATION).notify(this.project);
    }

    private static final WindowsDefenderChecker _init_$lambda$0() {
        WindowsDefenderChecker windowsDefenderChecker = WindowsDefenderChecker.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)windowsDefenderChecker, (String)"getInstance(...)");
        return windowsDefenderChecker;
    }

    private static final CharSequence showWarningNotification$lambda$3(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)it).toString();
    }

    private static final void showWarningNotification$lambda$5(WindowsDefenderCheckService this$0) {
        this$0.runAutoExclusionScript(BuildAttributionUiEvent.Page.PageType.WINDOWS_DEFENDER_NOTIFICATION, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)this$0){

            public final void invoke(boolean p0) {
                WindowsDefenderCheckService.access$showResultNotification((WindowsDefenderCheckService)this.receiver, p0);
            }
        }));
    }

    private static final void showWarningNotification$lambda$6(WindowsDefenderCheckService this$0) {
        this$0.ignoreCheckForProject(BuildAttributionUiEvent.Page.PageType.WINDOWS_DEFENDER_NOTIFICATION, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                WindowsDefenderCheckService.access$onIgnoreCallback((WindowsDefenderCheckService)this.receiver);
            }
        }));
    }

    private static final void showWarningNotification$lambda$7(WindowsDefenderCheckService this$0) {
        this$0.ignoreCheckGlobally(BuildAttributionUiEvent.Page.PageType.WINDOWS_DEFENDER_NOTIFICATION, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                WindowsDefenderCheckService.access$onIgnoreCallback((WindowsDefenderCheckService)this.receiver);
            }
        }));
    }

    private static final void showResultNotification$lambda$8(WindowsDefenderCheckService this$0) {
        this$0.ignoreCheckForProject(BuildAttributionUiEvent.Page.PageType.WINDOWS_DEFENDER_NOTIFICATION, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                WindowsDefenderCheckService.access$onIgnoreCallback((WindowsDefenderCheckService)this.receiver);
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final WindowsDefenderCheckService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject$p(WindowsDefenderCheckService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$ignoreCheck(WindowsDefenderCheckService $this, boolean globally, Function0 callback2) {
        $this.ignoreCheck(globally, (Function0<Unit>)callback2);
    }

    public static final /* synthetic */ void access$logUserAction(WindowsDefenderCheckService $this, BuildAttributionUiEvent.EventType actionEventType, BuildAttributionUiEvent.Page.PageType eventSourcePage) {
        $this.logUserAction(actionEventType, eventSourcePage);
    }

    public static final /* synthetic */ void access$showResultNotification(WindowsDefenderCheckService $this, boolean success) {
        $this.showResultNotification(success);
    }

    public static final /* synthetic */ void access$onIgnoreCallback(WindowsDefenderCheckService $this) {
        $this.onIgnoreCallback();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/build/diagnostic/WindowsDefenderCheckService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/build/diagnostic/WindowsDefenderCheckService;", "project", "Lcom/intellij/openapi/project/Project;", "NO_WARNING", "Lcom/android/build/diagnostic/WindowsDefenderCheckService$WindowsDefenderWarningData;", "getNO_WARNING", "()Lcom/android/build/diagnostic/WindowsDefenderCheckService$WindowsDefenderWarningData;", "manualInstructionsLink", "", "getManualInstructionsLink", "()Ljava/lang/String;", "intellij.android.build-attribution"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WindowsDefenderCheckService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(WindowsDefenderCheckService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (WindowsDefenderCheckService)object;
        }

        @NotNull
        public final WindowsDefenderWarningData getNO_WARNING() {
            return NO_WARNING;
        }

        @NotNull
        public final String getManualInstructionsLink() {
            return manualInstructionsLink;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/diagnostic/WindowsDefenderCheckService$WindowsDefenderWarningData;", "", "shouldShowWarning", "", "interestingPaths", "", "Ljava/nio/file/Path;", "<init>", "(ZLjava/util/List;)V", "getShouldShowWarning", "()Z", "getInterestingPaths", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.build-attribution"})
    public static final class WindowsDefenderWarningData {
        private final boolean shouldShowWarning;
        @NotNull
        private final List<Path> interestingPaths;

        public WindowsDefenderWarningData(boolean shouldShowWarning, @NotNull List<? extends Path> interestingPaths) {
            Intrinsics.checkNotNullParameter(interestingPaths, (String)"interestingPaths");
            this.shouldShowWarning = shouldShowWarning;
            this.interestingPaths = interestingPaths;
        }

        public final boolean getShouldShowWarning() {
            return this.shouldShowWarning;
        }

        @NotNull
        public final List<Path> getInterestingPaths() {
            return this.interestingPaths;
        }

        public final boolean component1() {
            return this.shouldShowWarning;
        }

        @NotNull
        public final List<Path> component2() {
            return this.interestingPaths;
        }

        @NotNull
        public final WindowsDefenderWarningData copy(boolean shouldShowWarning, @NotNull List<? extends Path> interestingPaths) {
            Intrinsics.checkNotNullParameter(interestingPaths, (String)"interestingPaths");
            return new WindowsDefenderWarningData(shouldShowWarning, interestingPaths);
        }

        public static /* synthetic */ WindowsDefenderWarningData copy$default(WindowsDefenderWarningData windowsDefenderWarningData, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = windowsDefenderWarningData.shouldShowWarning;
            }
            if ((n & 2) != 0) {
                list = windowsDefenderWarningData.interestingPaths;
            }
            return windowsDefenderWarningData.copy(bl, list);
        }

        @NotNull
        public String toString() {
            return "WindowsDefenderWarningData(shouldShowWarning=" + this.shouldShowWarning + ", interestingPaths=" + this.interestingPaths + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.shouldShowWarning);
            result2 = result2 * 31 + ((Object)this.interestingPaths).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WindowsDefenderWarningData)) {
                return false;
            }
            WindowsDefenderWarningData windowsDefenderWarningData = (WindowsDefenderWarningData)other;
            if (this.shouldShowWarning != windowsDefenderWarningData.shouldShowWarning) {
                return false;
            }
            return Intrinsics.areEqual(this.interestingPaths, windowsDefenderWarningData.interestingPaths);
        }
    }
}

