/*
 * Decompiled with CFR 0.152.
 */
package com.android.declarative.intellij.focus.services;

import com.android.declarative.intellij.focus.services.FocusGradleSettings;
import com.android.declarative.intellij.focus.services.FocusStorage;
import com.android.declarative.intellij.focus.services.ModuleInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.utils.text.TextUtilsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\f\u0010\u0011\u001a\u00020\f*\u00020\fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0006\u0010\u0015\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/declarative/intellij/focus/services/FocusDeclarativeGradleReader;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "focusStorage", "Lcom/android/declarative/intellij/focus/services/FocusStorage;", "getProjectFocusSettings", "Lcom/android/declarative/intellij/focus/services/FocusGradleSettings;", "loadModulesFromSettings", "", "", "loadAllModulesData", "Lcom/android/declarative/intellij/focus/services/ModuleInfo;", "modulesPath", "", "moduleNameToPath", "patchSettings", "", "modulePaths", "loadProjectFocusSettings", "declarative-gradle.focus-plugin"})
@SourceDebugExtension(value={"SMAP\nFocusDeclarativeGradleReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FocusDeclarativeGradleReader.kt\ncom/android/declarative/intellij/focus/services/FocusDeclarativeGradleReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1611#2,9:102\n1863#2:111\n1611#2,9:119\n1863#2:128\n1864#2:130\n1620#2:131\n1864#2:133\n1620#2:134\n1863#2,2:148\n1611#2,9:151\n1863#2:160\n1864#2:163\n1620#2:164\n1368#2:165\n1454#2,5:166\n381#3,7:112\n1#4:129\n1#4:132\n1#4:145\n1#4:161\n1#4:162\n136#5,9:135\n216#5:144\n217#5:146\n145#5:147\n25#6:150\n*S KotlinDebug\n*F\n+ 1 FocusDeclarativeGradleReader.kt\ncom/android/declarative/intellij/focus/services/FocusDeclarativeGradleReader\n*L\n50#1:102,9\n50#1:111\n53#1:119,9\n53#1:128\n53#1:130\n53#1:131\n50#1:133\n50#1:134\n76#1:148,2\n91#1:151,9\n91#1:160\n91#1:163\n91#1:164\n63#1:165\n63#1:166,5\n52#1:112,7\n53#1:129\n50#1:132\n67#1:145\n91#1:162\n67#1:135,9\n67#1:144\n67#1:146\n67#1:147\n88#1:150\n*E\n"})
public final class FocusDeclarativeGradleReader {
    @NotNull
    private final Project project;
    @NotNull
    private final FocusStorage focusStorage;

    public FocusDeclarativeGradleReader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.focusStorage = new FocusStorage(this.project);
    }

    @NotNull
    public final FocusGradleSettings getProjectFocusSettings() {
        if (!this.focusStorage.storageExists()) {
            Set<String> modulePaths = this.loadModulesFromSettings();
            this.focusStorage.storeFocusData(modulePaths, modulePaths);
            this.patchSettings(modulePaths);
        }
        return this.loadProjectFocusSettings();
    }

    private final Set<String> loadModulesFromSettings() {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel buildModel = projectBuildModel;
        Object object = buildModel.getProjectSettingsModel();
        if (object == null || (object = object.modulePaths()) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ModuleInfo> loadAllModulesData(@NotNull List<String> modulesPath) {
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Object $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(modulesPath, (String)"modulesPath");
        Map map2 = new LinkedHashMap();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel buildModel = projectBuildModel;
        Object $this$mapNotNull$iv = modulesPath;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Object $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List list;
            Object object;
            Iterable answer$iv;
            void $this$getOrPut$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String name2 = (String)element$iv$iv;
            boolean bl2 = false;
            String string = this.project.getBasePath();
            if (string == null) {
                string = "";
            }
            GradleBuildModel moduleBuildModel = buildModel.getModuleBuildModel(new File(string, this.moduleNameToPath(name2)));
            Map map3 = map2;
            String key$iv = name2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
            }
            if ((object = moduleBuildModel) != null && (object = object.dependencies()) != null && (object = object.modules()) != null) {
                void $this$mapNotNullTo$iv$iv2;
                Iterable $this$mapNotNull$iv2 = (Iterable)object;
                boolean $i$f$mapNotNull2 = false;
                answer$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    Boolean bl4;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator3.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    ModuleDependencyModel it = (ModuleDependencyModel)element$iv$iv2;
                    boolean bl5 = false;
                    if (it.path().valueAsString() != null) {
                        String depPath;
                        boolean bl6 = false;
                        List list2 = (List)map2.get(name2);
                        bl4 = list2 != null ? Boolean.valueOf(list2.add(TextUtilsKt.dropPrefix((String)depPath, (String)":"))) : null;
                    } else {
                        bl4 = null;
                    }
                    if (bl4 == null) continue;
                    Boolean it$iv$iv = bl4;
                    boolean bl7 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = null;
            }
            if (list == null) continue;
            List it$iv$iv = list;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        $this$mapNotNull$iv = map2;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl9 = false;
            ModuleInfo it$iv$iv = new ModuleInfo((String)it.getKey(), FocusDeclarativeGradleReader.loadAllModulesData$allDependencies(map2, (String)it.getKey(), SetsKt.emptySet()));
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final String moduleNameToPath(String $this$moduleNameToPath) {
        return StringsKt.replace$default((String)TextUtilsKt.dropPrefix((String)$this$moduleNameToPath, (String)":"), (String)":", (String)"/", (boolean)false, (int)4, null);
    }

    private final void patchSettings(Set<String> modulePaths) {
        block1: {
            ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
            ProjectBuildModel buildModel = projectBuildModel;
            GradleSettingsModel projectSettings = buildModel.getProjectSettingsModel();
            Iterable $this$forEach$iv = modulePaths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                GradleSettingsModel gradleSettingsModel = projectSettings;
                if (gradleSettingsModel == null) continue;
                gradleSettingsModel.removeModulePath(it);
            }
            GradleSettingsModel gradleSettingsModel = projectSettings;
            if (gradleSettingsModel == null) break block1;
            gradleSettingsModel.applyChanges();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FocusGradleSettings loadProjectFocusSettings() {
        void $this$mapNotNullTo$iv$iv;
        Pair<List<String>, List<String>> pair = this.focusStorage.getFocusData();
        List allModules = (List)pair.component1();
        List modulesInFocus = (List)pair.component2();
        Project $this$thisLogger$iv = this.project;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Project.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Reading settings");
        Set<ModuleInfo> modules = this.loadAllModulesData(allModules);
        Iterable $this$mapNotNull$iv = modulesInFocus;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ModuleInfo it$iv$iv;
            Object v1;
            block2: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String moduleInFocus = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = modules;
                for (Object t : iterable2) {
                    ModuleInfo it = (ModuleInfo)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)moduleInFocus)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            if ((ModuleInfo)v1 == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set inFocus = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new FocusGradleSettings(this.project, modules, inFocus);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> loadAllModulesData$allDependencies(Map<String, List<String>> map2, String path, Set<String> seen) {
        if (seen.contains(path)) {
            return SetsKt.emptySet();
        }
        List<String> list = map2.get(path);
        if (list != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            List<String> dependentPaths = list;
            boolean bl = false;
            Iterable iterable = dependentPaths;
            Collection collection2 = dependentPaths;
            boolean $i$f$flatMap = false;
            void var9_9 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String element = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = FocusDeclarativeGradleReader.loadAllModulesData$allDependencies(map2, element, SetsKt.plus(seen, (Object)element));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv)));
        }
        return SetsKt.emptySet();
    }
}

