/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ResourceResolverCache;
import com.android.tools.environment.Logger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"postSplashAttrReference", "Lcom/android/ide/common/rendering/api/ResourceReference;", "kotlin.jvm.PlatformType", "findPostSplashTheme", "", "themeStyle", "configuration", "Lcom/android/tools/configurations/Configuration;", "intellij.android.render-resources"})
public final class DefaultThemeProviderKt {
    private static final ResourceReference postSplashAttrReference = ResourceReference.attr((ResourceNamespace)ResourceNamespace.RES_AUTO, (String)"postSplashScreenTheme");

    private static final String findPostSplashTheme(String themeStyle, Configuration configuration2) {
        String resolveTheme;
        ResourceReference reference;
        Logger log = Logger.Companion.getInstance(Configuration.class);
        ResourceUrl themeUrl = ResourceUrl.parseStyleParentReference((String)themeStyle);
        if (themeUrl == null) {
            if (log.isDebugEnabled()) {
                String string = "Unable to parse theme %s";
                Object[] objectArray = new Object[]{themeStyle};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                log.debug(string2);
            }
            return themeStyle;
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespacePrefix((String)themeUrl.namespace, (ResourceNamespace)ResourceNamespace.RES_AUTO, (ResourceNamespace.Resolver)ResourceNamespace.Resolver.EMPTY_RESOLVER);
        ResourceNamespace resourceNamespace = namespace;
        if (resourceNamespace == null) {
            resourceNamespace = ResourceNamespace.RES_AUTO;
        }
        if ((reference = themeUrl.resolve(resourceNamespace, ResourceNamespace.Resolver.EMPTY_RESOLVER)) == null) {
            if (log.isDebugEnabled()) {
                String string = "Unable to resolve reference for theme %s";
                Object[] objectArray = new Object[]{themeUrl};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                log.debug(string3);
            }
            return themeStyle;
        }
        ResourceResolverCache resolverCache = configuration2.getSettings().getResolverCache();
        ResourceResolver resourceResolver = resolverCache.getResourceResolver(configuration2.getTarget(), themeUrl.toString(), configuration2.getFullConfig(), configuration2.getOverlays());
        Intrinsics.checkNotNullExpressionValue((Object)resourceResolver, (String)"getResourceResolver(...)");
        ResourceResolver resourceResolver2 = resourceResolver;
        StyleResourceValue theme = resourceResolver2.getStyle(reference);
        if (theme == null) {
            if (log.isDebugEnabled()) {
                String string = "Unable to resolve theme %s";
                Object[] objectArray = new Object[]{themeUrl};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                log.debug(string4);
            }
            return themeStyle;
        }
        StyleItemResourceValue value2 = resourceResolver2.findItemInStyle(theme, postSplashAttrReference);
        ResourceValue resolvedValue = resourceResolver2.resolveResValue((ResourceValue)value2);
        ResourceValue resourceValue = resolvedValue;
        String postSplashTheme = resourceValue != null && (resourceValue = resourceValue.getResourceUrl()) != null ? resourceValue.toString() : null;
        String string = postSplashTheme;
        if (string == null) {
            string = resolveTheme = themeStyle;
        }
        if (log.isDebugEnabled()) {
            String string5 = "Post splash resolved=%s, original theme=%s";
            Object[] objectArray = new Object[]{postSplashTheme, themeUrl};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            log.debug(string6);
        }
        return resolveTheme;
    }

    public static final /* synthetic */ String access$findPostSplashTheme(String themeStyle, Configuration configuration2) {
        return DefaultThemeProviderKt.findPostSplashTheme(themeStyle, configuration2);
    }
}

