/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.dom.attrs;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.environment.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeDefinition
implements Cloneable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    @NotNull
    private final ResourceReference myAttr;
    @Nullable
    private final String myLibraryName;
    @Nullable
    private String myGlobalDescription;
    @Nullable
    private String myGroupName;
    @NotNull
    private Map<String, Integer> myValueMappings = Collections.emptyMap();
    @NotNull
    private Map<String, String> myValueDescriptions = Collections.emptyMap();
    @NotNull
    private Set<AttributeFormat> myFormats;
    @Nullable
    private Map<ResourceReference, String> myDescriptionsInStyleableContexts;

    public AttributeDefinition(@NotNull ResourceNamespace namespace, @NotNull String name2) {
        this(namespace, name2, null, null);
    }

    public AttributeDefinition(@NotNull ResourceNamespace namespace, @NotNull String name2, @Nullable String libraryName, @Nullable Collection<AttributeFormat> formats) {
        assert (name2.indexOf(58) < 0);
        this.myAttr = ResourceReference.attr((ResourceNamespace)namespace, (String)name2);
        this.myLibraryName = libraryName;
        this.myFormats = formats == null || formats.isEmpty() ? EnumSet.noneOf(AttributeFormat.class) : EnumSet.copyOf(formats);
    }

    public AttributeDefinition(@NotNull AttributeDefinition other) {
        this.myAttr = other.myAttr;
        this.myLibraryName = other.myLibraryName;
        this.myGlobalDescription = other.myGlobalDescription;
        this.myGroupName = other.myGroupName;
        this.myValueMappings = other.myValueMappings;
        this.myValueDescriptions = other.myValueDescriptions;
        this.myFormats = EnumSet.copyOf(other.myFormats);
        this.myDescriptionsInStyleableContexts = other.myDescriptionsInStyleableContexts == null ? null : new HashMap<ResourceReference, String>(other.myDescriptionsInStyleableContexts);
    }

    @Nullable
    public Integer getValueMapping(@NotNull String flagName) {
        return this.myValueMappings.get(flagName);
    }

    @NotNull
    public ResourceReference getResourceReference() {
        return this.myAttr;
    }

    @NotNull
    public String getName() {
        return this.myAttr.getName();
    }

    @Nullable
    public String getLibraryName() {
        return this.myLibraryName;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        return Collections.unmodifiableSet(this.myFormats);
    }

    @Nullable
    public String getGroupName() {
        return this.myGroupName;
    }

    @NotNull
    public String[] getValues() {
        return this.myValueMappings.isEmpty() ? EMPTY_STRING_ARRAY : this.myValueMappings.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    @Nullable
    public String getDescription(@Nullable ResourceReference parentStyleable) {
        String description2 = parentStyleable == null || this.myDescriptionsInStyleableContexts == null ? null : this.myDescriptionsInStyleableContexts.get(parentStyleable);
        return description2 == null ? this.myGlobalDescription : description2;
    }

    @Deprecated
    @Nullable
    public String getDescriptionByParentStyleableName(@Nullable String parentStyleable) {
        if (parentStyleable == null || this.myDescriptionsInStyleableContexts == null) {
            return this.myGlobalDescription;
        }
        String description2 = this.myDescriptionsInStyleableContexts.get(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.TODO(), (String)parentStyleable));
        if (description2 == null) {
            description2 = this.myDescriptionsInStyleableContexts.get(ResourceReference.styleable((ResourceNamespace)ResourceNamespace.ANDROID, (String)parentStyleable));
        }
        return description2 == null ? this.myGlobalDescription : description2;
    }

    @Nullable
    public String getValueDescription(@NotNull String value2) {
        return this.myValueDescriptions.get(value2);
    }

    public boolean isAttributeDeprecated() {
        return this.myGlobalDescription != null && StringsKt.contains((CharSequence)this.myGlobalDescription, (CharSequence)"deprecated", (boolean)true);
    }

    public boolean isValueDeprecated(@NotNull String value2) {
        String description2 = this.getValueDescription(value2);
        return description2 != null && StringsKt.contains((CharSequence)description2, (CharSequence)"deprecated", (boolean)true);
    }

    void addFormats(@NotNull Collection<AttributeFormat> formats) {
        this.myFormats.addAll(formats);
    }

    public void setValueMappings(@NotNull Map<String, Integer> valueMappings) {
        if (!this.myValueMappings.isEmpty() && !this.myValueMappings.equals(valueMappings)) {
            AttributeDefinition.getLog().warn("An attempt to redefine value mappings of " + this.myAttr.getQualifiedName());
        }
        this.myValueMappings = Collections.unmodifiableMap(valueMappings);
    }

    void setValueDescriptions(@NotNull Map<String, String> valueDescriptions) {
        if (!this.myValueDescriptions.isEmpty() && !this.myValueDescriptions.equals(valueDescriptions)) {
            AttributeDefinition.getLog().warn("An attempt to redefine value descriptions of " + this.myAttr.getQualifiedName());
        }
        this.myValueDescriptions = Collections.unmodifiableMap(valueDescriptions);
    }

    void setGroupName(@Nullable String groupName) {
        this.myGroupName = groupName;
    }

    void setDescription(@NotNull String description2, @Nullable ResourceReference parentStyleable) {
        if (parentStyleable == null || this.myGlobalDescription == null) {
            this.myGlobalDescription = description2;
        }
        if (parentStyleable != null) {
            if (this.myDescriptionsInStyleableContexts == null) {
                this.myDescriptionsInStyleableContexts = new HashMap<ResourceReference, String>(3);
            }
            this.myDescriptionsInStyleableContexts.put(parentStyleable, description2);
        }
    }

    public String toString() {
        return this.myAttr.getQualifiedName() + " (" + this.myLibraryName + ") [" + this.myFormats + "]";
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeDefinition.class);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition)obj;
        return Objects.equals(this.myAttr, other.myAttr) && Objects.equals(this.myLibraryName, other.myLibraryName) && Objects.equals(this.myGlobalDescription, other.myGlobalDescription) && Objects.equals(this.myGroupName, other.myGroupName) && Objects.equals(this.myValueMappings, other.myValueMappings) && Objects.equals(this.myValueDescriptions, other.myValueDescriptions) && Objects.equals(this.myFormats, other.myFormats) && Objects.equals(this.myDescriptionsInStyleableContexts, other.myDescriptionsInStyleableContexts);
    }

    public int hashCode() {
        return Objects.hash(this.myAttr, this.myLibraryName, this.myGlobalDescription, this.myGroupName, this.myValueMappings, this.myValueDescriptions, this.myFormats, this.myDescriptionsInStyleableContexts);
    }
}

