/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.TrackingMdnsService;
import com.android.tools.idea.adb.wireless.WiFiPairingContentTabbedPaneContainer;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class WiFiPairingContentPanel {
    @NotNull
    private JPanel myRootContainer;
    @NotNull
    private WiFiPairingContentTabbedPaneContainer myQrCodePanel;
    @NotNull
    private WiFiPairingContentTabbedPaneContainer myPairingCodePanel;

    public WiFiPairingContentPanel(@NotNull Disposable parentDisposable) {
        this.setupUI();
        this.myPairingCodePanel.setParentDisposable(parentDisposable);
        this.myQrCodePanel.setParentDisposable(parentDisposable);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootContainer;
    }

    public void setQrCodeComponent(@NotNull JComponent component) {
        this.myQrCodePanel.setContent(component);
    }

    public void setPairingCodeComponent(@NotNull JComponent component, @Nullable TrackingMdnsService mdnsServiceUnderPairing) {
        this.myPairingCodePanel.setContent(component);
        if (mdnsServiceUnderPairing == null) {
            this.myPairingCodePanel.setAsyncProcessText("Available Wi-Fi devices");
        }
    }

    private void setupUI() {
        this.myRootContainer = new JPanel();
        this.myRootContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0));
        JBTabbedPane jBTabbedPane1 = new JBTabbedPane();
        jBTabbedPane1.setTabComponentInsets(new Insets(0, 0, 0, 0));
        this.myRootContainer.add((Component)jBTabbedPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        this.myQrCodePanel = new WiFiPairingContentTabbedPaneContainer();
        jBTabbedPane1.addTab("Pair using QR code", (Component)this.myQrCodePanel.getRootComponent());
        this.myPairingCodePanel = new WiFiPairingContentTabbedPaneContainer();
        jBTabbedPane1.addTab("Pair using pairing code", (Component)this.myPairingCodePanel.getRootComponent());
    }
}

