/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Shorts;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.TimedZipHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.Function;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkFileSystem
extends ArchiveFileSystem {
    public static final Set<String> EXTENSIONS = ImmutableSet.of((Object)"apk", (Object)"aar", (Object)"iapk", (Object)"zip", (Object)"aab");
    public static final String PROTOCOL = "apk";
    public static final String APK_SEPARATOR = "!/";

    public static ApkFileSystem getInstance() {
        return (ApkFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        return StringUtil.trimEnd((String)rootPath, (String)APK_SEPARATOR);
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        return localPath + APK_SEPARATOR;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        return VfsImplUtil.getHandler((ArchiveFileSystem)this, (VirtualFile)entryFile, (Function)(SystemInfo.isWindows ? TimedZipHandler::new : ZipHandler::new));
    }

    @NotNull
    public String getRelativePath(@NotNull VirtualFile file) {
        return super.getRelativePath(file);
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        int apkSeparatorIndex = normalizedPath.indexOf(APK_SEPARATOR);
        return apkSeparatorIndex > 0 ? normalizedPath.substring(0, apkSeparatorIndex + APK_SEPARATOR.length()) : "";
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull @NonNls String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        byte[] bytes = super.contentsToByteArray(file);
        if (!this.isBinaryXml(file, bytes)) {
            return bytes;
        }
        return BinaryXmlParser.decodeXml((byte[])bytes);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        return EXTENSIONS.contains(local.getExtension());
    }

    public boolean isBinaryXml(VirtualFile file, byte[] bytes) {
        return ApkFileSystem.isBinaryXml(this.getRelativePath(file), bytes);
    }

    public static boolean isBinaryXml(String relativePath, byte[] bytes) {
        boolean encodedXmlPath;
        if (!relativePath.endsWith(".xml")) {
            return false;
        }
        boolean bl = encodedXmlPath = relativePath.equals("AndroidManifest.xml") || relativePath.startsWith("res") && !relativePath.startsWith("res/raw");
        if (!encodedXmlPath) {
            return false;
        }
        short code = Shorts.fromBytes((byte)bytes[1], (byte)bytes[0]);
        return code == Chunk.Type.XML.code();
    }
}

