/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.idea.apk.viewer.dex.ShowDisassemblyAction;
import com.android.tools.idea.smali.SmaliFileType;
import com.intellij.CommonBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexCodeViewer
extends DialogWrapper {
    private final Editor myEditor;

    public DexCodeViewer(@NotNull Project project, @NotNull String nodeName, @NotNull String byteCode) {
        super(project, false);
        this.setModal(false);
        this.setCancelButtonText(CommonBundle.message((String)"button.without.mnemonic.close", (Object[])new Object[0]));
        this.setOKButtonText("Set");
        this.getOKAction().setEnabled(false);
        this.setCrossClosesWindow(true);
        this.setResizable(true);
        this.setTitle("DEX Byte Code for " + nodeName);
        EditorFactory factory2 = EditorFactory.getInstance();
        Document doc = ((EditorFactoryImpl)factory2).createDocument((CharSequence)byteCode, true, false);
        doc.setReadOnly(true);
        this.myEditor = factory2.createEditor(doc, project);
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.getInstance();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)SmaliFileType.getInstance(), (Project)project, null);
        ((EditorEx)this.myEditor).setHighlighter(editorHighlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme()));
        ((EditorEx)this.myEditor).setCaretVisible(true);
        EditorSettings settings = this.myEditor.getSettings();
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        this.myEditor.setBorder(null);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)this.myEditor.getComponent());
        panel2.setPreferredSize((Dimension)JBUI.size((int)640, (int)480));
        return panel2;
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getCancelAction()};
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getComponent();
    }

    @NonNls
    @Nullable
    protected String getDimensionServiceKey() {
        return ShowDisassemblyAction.class.getName();
    }

    public void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

